/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage.impl.jdbc;

import de.esoco.storage.Storage;
import de.esoco.storage.StorageException;
import de.esoco.storage.impl.jdbc.JdbcStorage;
import de.esoco.storage.impl.jdbc.JdbcStorageDefinition;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

class JdbcDataSourceStorageDefinition
extends JdbcStorageDefinition {
    private static final long serialVersionUID = 1L;
    private final DataSource dataSource;

    JdbcDataSourceStorageDefinition(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JdbcDataSourceStorageDefinition other = (JdbcDataSourceStorageDefinition)((Object)object);
        return this.dataSource.equals(other.dataSource);
    }

    @Override
    public int hashCode() {
        return 37 * this.dataSource.hashCode();
    }

    @Override
    protected Storage createStorage() throws StorageException {
        try {
            Connection connection = this.dataSource.getConnection();
            JdbcStorage storage = new JdbcStorage(connection, this.getDatabaseParameters(connection));
            return storage;
        }
        catch (SQLException e) {
            throw new StorageException("Storage creation failed", e);
        }
    }
}

