/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage.impl.jdbc;

import de.esoco.storage.Storage;
import de.esoco.storage.StorageException;
import de.esoco.storage.impl.jdbc.JdbcStorage;
import de.esoco.storage.impl.jdbc.JdbcStorageDefinition;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

class JdbcDriverStorageDefinition
extends JdbcStorageDefinition {
    private static final long serialVersionUID = 1L;
    private final String connectURL;
    private final Properties connectionProperties = new Properties();

    JdbcDriverStorageDefinition(String connectURL, Properties properties) {
        if (connectURL == null) {
            throw new IllegalArgumentException("URL");
        }
        this.connectURL = connectURL;
        if (properties != null) {
            this.connectionProperties.putAll((Map<?, ?>)properties);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JdbcDriverStorageDefinition other = (JdbcDriverStorageDefinition)((Object)object);
        return this.connectURL.equals(other.connectURL) && this.connectionProperties.equals(other.connectionProperties);
    }

    @Override
    public int hashCode() {
        return this.connectURL.hashCode() * 37 + this.connectionProperties.hashCode();
    }

    public String toString() {
        return "JdbcDriverStorageDefinition [connectURL=" + this.connectURL + "]";
    }

    @Override
    protected Storage createStorage() throws StorageException {
        try {
            Connection connection = DriverManager.getConnection(this.connectURL, this.connectionProperties);
            return new JdbcStorage(connection, this.getDatabaseParameters(connection));
        }
        catch (SQLException e) {
            throw new StorageException("Storage creation failed", e);
        }
    }
}

