/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage.impl.jdbc;

import de.esoco.lib.expression.ElementAccess;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.Predicates;
import de.esoco.lib.expression.StringFunctions;
import de.esoco.lib.expression.function.Cast;
import de.esoco.lib.expression.function.FunctionChain;
import de.esoco.lib.expression.function.GetSubstring;
import de.esoco.lib.expression.predicate.Comparison;
import de.esoco.lib.expression.predicate.ElementPredicate;
import de.esoco.lib.expression.predicate.FunctionPredicate;
import de.esoco.lib.expression.predicate.PredicateJoin;
import de.esoco.lib.logging.Log;
import de.esoco.lib.manage.Closeable;
import de.esoco.lib.property.SortDirection;
import de.esoco.storage.Query;
import de.esoco.storage.QueryPredicate;
import de.esoco.storage.QueryResult;
import de.esoco.storage.Storage;
import de.esoco.storage.StorageException;
import de.esoco.storage.StorageManager;
import de.esoco.storage.StorageMapping;
import de.esoco.storage.StoragePredicates;
import de.esoco.storage.StorageRelationTypes;
import de.esoco.storage.impl.jdbc.JdbcQueryResult;
import de.esoco.storage.impl.jdbc.JdbcRelationTypes;
import de.esoco.storage.impl.jdbc.JdbcStorage;
import de.esoco.storage.impl.jdbc.SqlExpressionFormat;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.type.MetaTypes;

public class JdbcQuery<T>
extends RelatedObject
implements Query<T>,
Closeable {
    private static final String SELECT_TEMPLATE = "SELECT %s FROM %s";
    private static final String SQL_NEGATION = " NOT ";
    private final QueryPredicate<T> query;
    private final StorageMapping<T, Relatable, ?> mapping;
    private final String queryCriteria;
    private final String orderCriteria;
    private final JdbcStorage storage;
    private final List<Object> compareAttributes = new ArrayList<Object>();
    private final List<Object> compareValues = new ArrayList<Object>();
    private final List<ElementPredicate<?, ?>> sortPredicates = new ArrayList();
    private JdbcQueryResult<T> currentResult;
    private PreparedStatement queryStatement;

    JdbcQuery(JdbcStorage storage, QueryPredicate<T> query) throws StorageException {
        this.storage = storage;
        this.query = query;
        Class<T> type = query.getQueryType();
        Predicate criteria = query.getCriteria();
        this.mapping = StorageManager.getMapping(type);
        Predicate<T> defaultCriteria = this.mapping.getDefaultCriteria(type);
        if (defaultCriteria != null) {
            criteria = Predicates.and(criteria, defaultCriteria);
        }
        this.queryCriteria = this.parseQueryCriteria(this.mapping, criteria);
        this.orderCriteria = this.createOrderCriteria(this.sortPredicates);
        if (query.hasRelation(StorageRelationTypes.QUERY_OFFSET)) {
            this.set(StorageRelationTypes.QUERY_OFFSET, (Integer)query.get(StorageRelationTypes.QUERY_OFFSET));
        }
        if (query.hasRelation(StorageRelationTypes.QUERY_LIMIT)) {
            this.set(StorageRelationTypes.QUERY_LIMIT, (Integer)query.get(StorageRelationTypes.QUERY_LIMIT));
        }
        if (query.hasRelation(StorageRelationTypes.QUERY_DEPTH)) {
            this.set(StorageRelationTypes.QUERY_DEPTH, (Integer)query.get(StorageRelationTypes.QUERY_DEPTH));
        } else if (criteria != null && criteria instanceof Relatable && ((Relatable)criteria).hasRelation(StorageRelationTypes.QUERY_DEPTH)) {
            this.set(StorageRelationTypes.QUERY_DEPTH, (Integer)((Relatable)criteria).get(StorageRelationTypes.QUERY_DEPTH));
        } else if (storage.hasRelation(StorageRelationTypes.QUERY_DEPTH)) {
            this.set(StorageRelationTypes.QUERY_DEPTH, (Integer)storage.get(StorageRelationTypes.QUERY_DEPTH));
        }
    }

    static <T> QueryPredicate<T> createChildQueryPredicate(StorageMapping<?, ?, ?> parentMapping, StorageMapping<T, Relatable, ?> childMapping, Object parentId, int queryDepth) {
        Relatable attr;
        Relatable parentAttr = childMapping.getParentAttribute(parentMapping);
        if (parentAttr == null) {
            throw new IllegalStateException(String.format("No parent attribute for %s in %s", parentMapping, childMapping));
        }
        Predicate criteria = StoragePredicates.ifAttribute(childMapping, parentAttr, (Predicate<Object>)Predicates.equalTo((Object)parentId));
        if (parentMapping != childMapping && (attr = childMapping.getParentAttribute(childMapping)) != null) {
            criteria = criteria.and(StoragePredicates.ifAttribute(childMapping, attr, (Predicate<Object>)Predicates.isNull()));
        }
        QueryPredicate<T> query = new QueryPredicate<T>(childMapping.getMappedType(), criteria);
        query.set(StorageRelationTypes.QUERY_DEPTH, queryDepth);
        query.set(JdbcRelationTypes.JDBC_CHILD_QUERY);
        return query;
    }

    public void close() {
        try {
            if (this.currentResult != null) {
                this.currentResult.close();
                this.currentResult = null;
            }
        }
        catch (Exception e) {
            Log.warn((String)"Closing ResultSet failed", (Throwable)e);
        }
        try {
            if (this.queryStatement != null) {
                this.queryStatement.close();
                this.queryStatement = null;
            }
        }
        catch (SQLException e) {
            Log.error((String)"Closing Statement failed", (Throwable)e);
        }
    }

    @Override
    public QueryResult<T> execute() throws StorageException {
        long start = System.currentTimeMillis();
        try {
            if (this.queryStatement != null) {
                this.queryStatement.close();
            }
            this.queryStatement = this.prepareQueryStatement();
            Log.debugf((String)"QueryParams: %s", (Object[])new Object[]{this.compareValues});
            this.setQueryParameters(this.queryStatement);
            ResultSet resultSet = this.queryStatement.executeQuery();
            boolean childQuery = this.query.hasFlag(JdbcRelationTypes.JDBC_CHILD_QUERY) || this.query.hasFlag(StorageRelationTypes.IS_CHILD_QUERY);
            this.checkLogLongQuery(start);
            this.currentResult = new JdbcQueryResult<T>(this.storage, this.mapping, resultSet, 0, childQuery);
            if (this.hasRelation(StorageRelationTypes.QUERY_DEPTH)) {
                this.currentResult.set(StorageRelationTypes.QUERY_DEPTH, (Integer)this.get(StorageRelationTypes.QUERY_DEPTH));
            }
            return this.currentResult;
        }
        catch (SQLException e) {
            String message = "Query execution failed: " + this.query;
            Log.error((String)message, (Throwable)e);
            throw new StorageException(message, e);
        }
    }

    @Override
    public Set<Object> getDistinct(Relatable attribute) throws StorageException {
        String sql = JdbcStorage.formatStatement(SELECT_TEMPLATE, "DISTINCT " + this.storage.getSqlName(attribute, true), this.storage.getSqlName(this.mapping, true)) + this.queryCriteria;
        HashSet<Object> result = new HashSet<Object>();
        try (PreparedStatement statement = this.storage.getConnection().prepareStatement(sql);){
            this.setQueryParameters(statement);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Object value = resultSet.getObject(1);
                value = this.mapping.checkAttributeValue(attribute, value);
                result.add(value);
            }
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
        return result;
    }

    @Override
    public QueryPredicate<T> getQueryPredicate() {
        return this.query;
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public int positionOf(Object id) {
        String idAttr = this.storage.getSqlName(this.mapping.getIdAttribute(), true);
        String criteria = "";
        String order = "";
        if (this.queryCriteria != null && this.queryCriteria.length() > 0) {
            criteria = this.queryCriteria;
        }
        if (this.orderCriteria != null && this.orderCriteria.length() > 0) {
            order = this.orderCriteria;
        }
        String sql = JdbcStorage.formatStatement("SELECT row FROM (SELECT row_number() OVER(%s) as row, %s FROM %s %s) AS rownums WHERE %s = ?", order, idAttr, this.storage.getSqlName(this.mapping, true), criteria, idAttr);
        try {
            return this.queryInteger(sql, id) - 1;
        }
        catch (StorageException e) {
            Log.debug((String)"Database doesn't support row_number() function", (Throwable)e);
            return -1;
        }
    }

    @Override
    public int size() throws StorageException {
        String sql = JdbcStorage.formatStatement(SELECT_TEMPLATE, "COUNT(*)", this.storage.getSqlName(this.mapping, true)) + this.queryCriteria;
        return this.queryInteger(sql, new Object[0]);
    }

    String createOrderCriteria(List<ElementPredicate<?, ?>> sortPredicates) {
        String result = "";
        if (sortPredicates.size() > 0) {
            StringBuilder criteria = new StringBuilder(" ORDER BY ");
            for (ElementPredicate<?, ?> predicate : sortPredicates) {
                Object attr = predicate.getElementDescriptor();
                criteria.append(this.storage.getSqlName(attr, true));
                if (predicate.get(MetaTypes.SORT_DIRECTION) == SortDirection.DESCENDING) {
                    criteria.append(" DESC");
                }
                criteria.append(',');
            }
            criteria.setLength(criteria.length() - 1);
            result = criteria.toString();
        }
        return result;
    }

    String getColumnList(StorageMapping<?, ?, ?> mapping) {
        Collection<?> attributes = mapping.getAttributes();
        StringBuilder columns = new StringBuilder(attributes.size() * 10);
        for (Object attr : attributes) {
            columns.append(this.storage.getSqlName(attr, true)).append(',');
        }
        if (!mapping.hasFlag(JdbcRelationTypes.SQL_DISABLE_CHILD_COUNTS)) {
            for (StorageMapping childMapping : mapping.getChildMappings()) {
                columns.append(this.storage.getChildCountColumn(childMapping));
                columns.append(',');
            }
        }
        columns.setLength(columns.length() - 1);
        return columns.toString();
    }

    void parseAttributePredicate(StorageMapping<?, ?, ?> mapping, String attribute, Predicate<?> value, StringBuilder result) {
        if (value instanceof QueryPredicate) {
            this.parseDetailQuery(mapping, attribute, (QueryPredicate)value, result);
        } else {
            this.parseCriteria(mapping, attribute, value, result);
        }
    }

    void parseComparison(Comparison<?, ?> comparison, String attribute, StringBuilder result, boolean negate) {
        Object compareValue = comparison.getRightValue();
        String placeholders = this.getComparisonPlaceholders(compareValue);
        this.compareValues.add(compareValue);
        if (comparison instanceof SqlExpressionFormat) {
            String expression = ((SqlExpressionFormat)comparison).format(this.storage, (Predicate<?>)comparison, attribute, placeholders, negate);
            result.append(expression);
        } else {
            result.append(attribute).append(' ');
            if (comparison instanceof Comparison.EqualTo) {
                if (compareValue != null) {
                    result.append(negate ? "<>" : "=");
                } else {
                    result.append(negate ? "IS NOT NULL" : "IS NULL");
                    placeholders = null;
                }
            } else if (comparison instanceof Comparison.ElementOf) {
                result.append(negate ? "NOT IN" : "IN");
            } else if (comparison instanceof Comparison.LessThan || comparison instanceof Comparison.LessOrEqual) {
                if (negate) {
                    result.append('>');
                    if (comparison instanceof Comparison.LessThan) {
                        result.append('=');
                    }
                } else {
                    result.append('<');
                    if (comparison instanceof Comparison.LessOrEqual) {
                        result.append('=');
                    }
                }
            } else if (comparison instanceof Comparison.GreaterThan || comparison instanceof Comparison.GreaterOrEqual) {
                if (negate) {
                    result.append('<');
                    if (comparison instanceof Comparison.GreaterThan) {
                        result.append('=');
                    }
                } else {
                    result.append('>');
                    if (comparison instanceof Comparison.GreaterOrEqual) {
                        result.append('=');
                    }
                }
            } else {
                throw new IllegalArgumentException("Unsupported comparison: " + comparison);
            }
            if (placeholders != null) {
                result.append(' ').append(placeholders);
            }
        }
    }

    boolean parseCriteria(StorageMapping<?, ?, ?> mapping, String attribute, Predicate<?> criteria, StringBuilder result) {
        boolean negate = false;
        boolean valid = true;
        if (criteria instanceof Predicates.Not) {
            criteria = ((Predicates.Not)criteria).getInvertedPredicate();
            negate = true;
            result.append(SQL_NEGATION);
        }
        if (criteria instanceof PredicateJoin) {
            this.parseJoin(mapping, (PredicateJoin)criteria, result);
        } else if (criteria instanceof ElementPredicate) {
            ElementPredicate element = (ElementPredicate)criteria;
            valid = this.parseElementPredicate(mapping, element, result);
        } else if (criteria instanceof FunctionPredicate) {
            FunctionPredicate function = (FunctionPredicate)criteria;
            valid = this.parseFunctionPredicate(mapping, function, result);
        } else if (criteria instanceof Comparison) {
            if (negate) {
                result.setLength(result.length() - SQL_NEGATION.length());
            }
            this.parseComparison((Comparison)criteria, attribute, result, negate);
        } else {
            throw new IllegalArgumentException("Unsupported query predicate: " + criteria);
        }
        return valid;
    }

    void parseDetailQuery(StorageMapping<?, ?, ?> mainMapping, String attribute, QueryPredicate<?> detail, StringBuilder result) {
        String detailAttr;
        String mainAttr;
        StorageMapping<?, ?, ?> detailMapping = StorageManager.getMapping(detail.getQueryType());
        Object parentAttr = detailMapping.getParentAttribute(mainMapping);
        String childTable = this.storage.getSqlName(detailMapping, true);
        if (parentAttr != null) {
            mainAttr = this.storage.getSqlName(mainMapping.getIdAttribute(), true);
            detailAttr = this.storage.getSqlName(parentAttr, true);
        } else {
            Function getDetailAttr = (Function)detail.get(StorageRelationTypes.STORAGE_FUNCTION);
            mainAttr = attribute;
            if (getDetailAttr != null) {
                detailAttr = this.parseFunction(getDetailAttr);
                this.compareAttributes.remove(this.compareAttributes.size() - 1);
            } else {
                detailAttr = this.storage.getSqlName(detailMapping.getIdAttribute(), true);
            }
        }
        result.append(mainAttr);
        result.append(" IN (");
        result.append(JdbcStorage.formatStatement(SELECT_TEMPLATE, detailAttr, childTable));
        result.append(" WHERE ");
        this.parseCriteria(detailMapping, null, detail.getCriteria(), result);
        result.append(')');
    }

    boolean parseElementPredicate(StorageMapping<?, ?, ?> mapping, ElementPredicate<?, ?> element, StringBuilder result) {
        Predicate value;
        boolean hasCriteria;
        if (element.get(MetaTypes.SORT_DIRECTION) != null) {
            this.sortPredicates.add(element);
        }
        boolean bl = hasCriteria = (value = element.getPredicate()) != Predicates.alwaysTrue();
        if (hasCriteria) {
            String column = this.getColumnName(element.getElementDescriptor(), hasCriteria && !(value instanceof QueryPredicate));
            this.parseAttributePredicate(mapping, column, value, result);
        }
        return hasCriteria;
    }

    String parseFunction(Function<?, ?> function) {
        String sqlFunction = null;
        if (function == StringFunctions.toLowerCase()) {
            sqlFunction = "LOWER(%s)";
        } else if (function == StringFunctions.toUpperCase()) {
            sqlFunction = "UPPER(%s)";
        } else if (function instanceof Cast) {
            Class castType = (Class)((Cast)function).getRightValue();
            sqlFunction = String.format("CAST(%s as %s)", "%s", this.storage.mapSqlDatatype(castType));
        } else if (function instanceof GetSubstring) {
            GetSubstring substring = (GetSubstring)function;
            int begin = substring.getBeginIndex() + 1;
            int end = substring.getEndIndex() + 1;
            sqlFunction = end == 0 ? String.format("SUBSTRING(%s,%d)", "%s", begin) : String.format("SUBSTRING(%s,%d,%d)", "%s", begin, end);
        } else if (function instanceof FunctionChain) {
            FunctionChain chain = (FunctionChain)function;
            sqlFunction = String.format(this.parseFunction(chain.getOuter()), this.parseFunction(chain.getInner()));
        } else {
            sqlFunction = function instanceof ElementAccess ? this.getColumnName(((ElementAccess)function).getElementDescriptor(), true) : this.getColumnName(function, true);
        }
        return sqlFunction;
    }

    boolean parseFunctionPredicate(StorageMapping<?, ?, ?> mapping, FunctionPredicate<?, ?> functionPredicate, StringBuilder result) {
        Function function = functionPredicate.getFunction();
        if (!(function instanceof FunctionChain)) {
            throw new IllegalArgumentException("Unparseable function predicate: " + function);
        }
        FunctionChain chain = (FunctionChain)function;
        this.parseAttributePredicate(mapping, this.parseFunction((Function<?, ?>)chain), functionPredicate.getPredicate(), result);
        return true;
    }

    boolean parseJoin(StorageMapping<?, ?, ?> mapping, PredicateJoin<?> join, StringBuilder result) {
        boolean bothValid;
        StringBuilder left = new StringBuilder();
        StringBuilder right = new StringBuilder();
        boolean leftValid = this.parseCriteria(mapping, null, join.getLeft(), left);
        boolean rightValid = this.parseCriteria(mapping, null, join.getRight(), right);
        leftValid = leftValid && left.length() > 0;
        rightValid = rightValid && right.length() > 0;
        boolean bl = bothValid = leftValid && rightValid;
        if (bothValid) {
            result.append('(');
        }
        result.append((CharSequence)left);
        if (bothValid) {
            if (join instanceof Predicates.And) {
                result.append(" AND ");
            } else if (join instanceof Predicates.Or) {
                result.append(" OR ");
            } else {
                throw new IllegalArgumentException("Unsupported predicate join: " + join);
            }
        }
        result.append((CharSequence)right);
        if (bothValid) {
            result.append(')');
        }
        return leftValid || rightValid;
    }

    String parseQueryCriteria(StorageMapping<?, ?, ?> mapping, Predicate<?> criteria) {
        StringBuilder result = new StringBuilder();
        this.sortPredicates.clear();
        if (criteria != null) {
            this.parseCriteria(mapping, null, criteria, result);
            if (result.length() > 0) {
                result.insert(0, " WHERE ");
            }
        }
        return result.toString();
    }

    PreparedStatement prepareQueryStatement() throws StorageException {
        try {
            int offset = (Integer)this.get(StorageRelationTypes.QUERY_OFFSET);
            int limit = (Integer)this.get(StorageRelationTypes.QUERY_LIMIT);
            StringBuilder sql = new StringBuilder(JdbcStorage.formatStatement(SELECT_TEMPLATE, this.getColumnList(this.mapping), this.storage.getSqlName(this.mapping, true)));
            sql.append(this.queryCriteria);
            sql.append(this.orderCriteria);
            if (offset > 0) {
                sql.append(" OFFSET ").append(offset);
            }
            if (limit > 0) {
                sql.append(" LIMIT ").append(limit);
            }
            Log.debug((String)("Query: " + sql));
            Connection connection = this.storage.getConnection();
            PreparedStatement statement = connection.getMetaData().supportsResultSetType(1004) ? connection.prepareStatement(sql.toString(), 1004, 1007) : connection.prepareStatement(sql.toString());
            return statement;
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    int setQueryParameters(PreparedStatement statement) throws SQLException, StorageException {
        assert (this.compareAttributes.size() == this.compareValues.size());
        int count = this.compareValues.size();
        int index = 1;
        for (int i = 0; i < count; ++i) {
            Object attribute = this.compareAttributes.get(i);
            Object value = this.compareValues.get(i);
            if (value instanceof Collection) {
                for (Object element : (Collection)value) {
                    statement.setObject(index++, this.storage.mapValue(this.mapping, attribute, element));
                }
                continue;
            }
            if (value == null) continue;
            statement.setObject(index++, this.storage.mapValue(this.mapping, attribute, value));
        }
        return index;
    }

    private void checkLogLongQuery(long startTime) {
        long duration = System.currentTimeMillis() - startTime;
        if (duration > 1000L) {
            if (duration > 3000L) {
                Log.warnf((String)"Very high query time: %d.%03d for %s\n", (Object[])new Object[]{duration / 1000L, duration % 1000L, this.queryStatement});
            } else {
                Log.infof((String)"High query time: %d.%03d for %s\n", (Object[])new Object[]{duration / 1000L, duration % 1000L, this.queryStatement});
            }
        }
    }

    private String getColumnName(Object elementDescriptor, boolean isCompareAttr) {
        String attribute = this.storage.getSqlName(elementDescriptor, true);
        if (isCompareAttr) {
            this.compareAttributes.add(elementDescriptor);
        }
        return attribute;
    }

    private String getComparisonPlaceholders(Object compareValue) {
        StringBuilder result = new StringBuilder();
        if (compareValue instanceof Collection) {
            ArrayList values = new ArrayList((Collection)compareValue);
            int count = values.size();
            result.append('(');
            if (count > 0) {
                while (count-- > 1) {
                    result.append("?,");
                }
                result.append("?");
            }
            result.append(")");
        } else {
            result.append('?');
        }
        return result.toString();
    }

    private int queryInteger(String sql, Object ... parameters) throws StorageException {
        int count;
        try (PreparedStatement statement = this.storage.getConnection().prepareStatement(sql);){
            int index = this.setQueryParameters(statement);
            if (parameters != null) {
                for (Object param : parameters) {
                    statement.setObject(index++, param);
                }
            }
            ResultSet result = statement.executeQuery();
            result.next();
            count = result.getInt(1);
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
        return count;
    }
}

