/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage.impl.jdbc;

import de.esoco.lib.logging.Log;
import de.esoco.storage.QueryList;
import de.esoco.storage.QueryPredicate;
import de.esoco.storage.QueryResult;
import de.esoco.storage.StorageDefinition;
import de.esoco.storage.StorageException;
import de.esoco.storage.StorageMapping;
import de.esoco.storage.StorageRelationTypes;
import de.esoco.storage.impl.jdbc.JdbcQuery;
import de.esoco.storage.impl.jdbc.JdbcStorage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;

class JdbcQueryResult<T>
extends RelatedObject
implements QueryResult<T> {
    private final JdbcStorage storage;
    private final StorageMapping<T, Relatable, ?> mapping;
    private final ResultSet resultSet;
    private final boolean isChildQuery;
    private int offset = 0;
    private boolean offsetRelative = false;
    private boolean hasNext = false;

    JdbcQueryResult(JdbcStorage storage, StorageMapping<T, Relatable, ?> storageMapping, ResultSet resultSet, int offset, boolean isChildQuery) throws SQLException {
        this.storage = storage;
        this.mapping = storageMapping;
        this.resultSet = resultSet;
        this.offset = offset + 1;
        this.isChildQuery = isChildQuery;
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            Log.error((String)"Closing ResultSet failed", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() throws StorageException {
        try {
            if (this.offset != 0) {
                this.hasNext = this.offsetRelative ? this.resultSet.relative(this.offset) : this.resultSet.absolute(this.offset);
                this.offset = 0;
            } else {
                this.hasNext = this.resultSet.next();
            }
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
        return this.hasNext;
    }

    @Override
    public T next() throws StorageException {
        T result = null;
        if (this.hasNext) {
            try {
                int i;
                int resultSize = this.resultSet.getMetaData().getColumnCount();
                boolean useChildCounts = this.storage.isChildCountsEnabled(this.mapping);
                int childMappings = this.mapping.getChildMappings().size();
                int columns = useChildCounts ? resultSize - childMappings : resultSize;
                ArrayList<Object> values = new ArrayList<Object>(columns);
                int[] childCounts = null;
                for (i = 1; i <= columns; ++i) {
                    Object value = this.resultSet.getObject(i);
                    values.add(value);
                }
                if (useChildCounts) {
                    childCounts = new int[childMappings];
                    for (i = 0; i < childMappings; ++i) {
                        childCounts[i] = this.resultSet.getInt(++columns);
                    }
                }
                result = this.mapping.createObject(values, this.isChildQuery);
                Relatable resultRelatable = ObjectRelations.getRelatable(result);
                int queryDepth = (Integer)this.get(StorageRelationTypes.QUERY_DEPTH);
                if (!resultRelatable.hasFlag(StorageRelationTypes.PERSISTENT)) {
                    resultRelatable.set(StorageRelationTypes.PERSISTENT);
                    if (queryDepth > 0) {
                        this.readChildren(this.mapping, result, queryDepth - 1, childCounts);
                    }
                }
                Log.debugf((String)"QueryResult: %s", (Object[])new Object[]{result});
                return result;
            }
            catch (SQLException e) {
                throw new StorageException(e);
            }
        }
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    @Override
    public void setPosition(int index, boolean relative) {
        this.offset = relative ? index : (index >= 0 ? index + 1 : index);
        this.offsetRelative = relative;
    }

    private <C extends StorageMapping<?, Relatable, ?>> void readChildren(final StorageMapping<T, Relatable, C> parentMapping, final T parent, int depth, int[] childCounts) throws StorageException {
        Collection<C> childMappings = parentMapping.getChildMappings();
        int childMappingCount = childMappings.size();
        if (childMappingCount > 0) {
            int currentMapping = 0;
            Object parentId = parentMapping.getAttributeValue(parent, parentMapping.getIdAttribute());
            for (final StorageMapping mapping : childMappings) {
                int childCount = childCounts != null ? childCounts[currentMapping++] : -1;
                if (childCount == 0) continue;
                StorageMapping childMapping = mapping;
                QueryPredicate childQuery = JdbcQuery.createChildQueryPredicate(parentMapping, childMapping, parentId, depth);
                QueryList.ElementInitializer<Object> initializer = new QueryList.ElementInitializer<Object>(){

                    @Override
                    public void initElements(List<Object> children) {
                        parentMapping.initChildren(parent, children, mapping);
                    }
                };
                QueryList<Object> children = new QueryList<Object>((StorageDefinition)((Object)this.storage.get(StorageRelationTypes.STORAGE_DEFINITION)), childQuery, childCount, initializer);
                parentMapping.setChildren(parent, children, mapping);
            }
        }
    }
}

