/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage.impl.jdbc;

import de.esoco.lib.datatype.GenericEnum;
import de.esoco.lib.datatype.ObjectId;
import de.esoco.lib.datatype.Period;
import de.esoco.lib.logging.Log;
import de.esoco.lib.property.HasOrder;
import de.esoco.lib.text.TextUtil;
import de.esoco.storage.Query;
import de.esoco.storage.QueryPredicate;
import de.esoco.storage.Storage;
import de.esoco.storage.StorageException;
import de.esoco.storage.StorageManager;
import de.esoco.storage.StorageMapping;
import de.esoco.storage.StorageRelationTypes;
import de.esoco.storage.impl.jdbc.JdbcQuery;
import de.esoco.storage.impl.jdbc.JdbcRelationTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;
import org.obrel.type.MetaTypes;
import org.obrel.type.StandardTypes;

public class JdbcStorage
extends Storage {
    private static final String DEFAULT_STRING_DATATYPE = "VARCHAR(1000)";
    private static final String INSERT_TEMPLATE = "INSERT INTO %s (%s) VALUES (%s)";
    private static final String UPDATE_TEMPLATE = "UPDATE %s SET %s WHERE %s";
    private static final String DELETE_TEMPLATE = "DELETE FROM %s WHERE %s = %s";
    private static final String CREATE_TABLE_TEMPLATE = "CREATE TABLE %s (%s)";
    private static final String DROP_TABLE_TEMPLATE = "DROP TABLE %s";
    private static final String PRIMARY_KEY_TEMPLATE = "PRIMARY KEY(%s),";
    private static final String FOREIGN_KEY_TEMPLATE = "FOREIGN KEY(%s) REFERENCES %s(%s),";
    private static final String INDEX_TEMPLATE = "CREATE INDEX idx_%1$s_%2$s ON \"%1$s\"(\"%2$s\")";
    private static final String CHILD_COUNT_PREFIX = "_cc_";
    private static final Map<Class<?>, String> STANDARD_SQL_DATATYPE_MAP;
    private static boolean childCountsEnabled;
    private static int nextId;
    private Connection connection;
    private final String databaseName;
    private final String fuzzySearchFunction;
    private final char identifierQuote;
    private Map<Class<?>, String> datatypeMap = STANDARD_SQL_DATATYPE_MAP;

    JdbcStorage(Connection connection, Relatable params) throws SQLException {
        this.connection = connection;
        this.databaseName = connection.getMetaData().getDatabaseProductName();
        this.set(StandardTypes.OBJECT_ID, ObjectId.intId((int)nextId++));
        connection.setAutoCommit(false);
        this.fuzzySearchFunction = (String)params.get(JdbcRelationTypes.SQL_FUZZY_SEARCH_FUNCTION);
        this.identifierQuote = ((Character)params.get(JdbcRelationTypes.SQL_IDENTITIFIER_QUOTE)).charValue();
        ObjectRelations.copyRelations((Relatable)params, (Relatable)this, (boolean)false);
        if (!((Map)params.get(JdbcRelationTypes.SQL_DATATYPE_MAP)).isEmpty()) {
            this.datatypeMap = new HashMap(STANDARD_SQL_DATATYPE_MAP);
            this.datatypeMap.putAll((Map)params.get(JdbcRelationTypes.SQL_DATATYPE_MAP));
            this.datatypeMap = Collections.unmodifiableMap(this.datatypeMap);
        }
    }

    static boolean containsTable(Connection connection, String table) throws StorageException {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet tables = metaData.getTables(null, null, table, null);
            boolean exists = tables.next();
            tables.close();
            Log.debug((String)(table + (exists ? " exists" : " doesn't exist")));
            return exists;
        }
        catch (SQLException e) {
            throw new StorageException("Could not access table metadata", e);
        }
    }

    static String formatStatement(String format, Object ... args) {
        return String.format(format, args);
    }

    public static void setChildCountsEnabled(boolean enabled) {
        childCountsEnabled = enabled;
    }

    @Override
    public void commit() throws StorageException {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new StorageException("Commit failed", e);
        }
    }

    @Override
    public void deleteObject(Object object) throws StorageException {
        StorageMapping<?, ?, ?> mapping = StorageManager.getMapping(object.getClass());
        Object idAttribute = mapping.getIdAttribute();
        String table = this.getSqlName(mapping, true);
        String idAttr = this.getSqlName(idAttribute, true);
        Object id = mapping.getAttributeValue(object, idAttribute);
        String sql = JdbcStorage.formatStatement(DELETE_TEMPLATE, table, idAttr, id);
        Log.debug((String)sql);
        this.executeUpdate(sql, null, null, false, false);
    }

    public void executeUpdate(String sql, Object ... params) throws StorageException {
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            int paramIndex = 1;
            for (Object param : params) {
                statement.setObject(paramIndex++, param);
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new StorageException(e);
        }
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public String getFuzzySearchFunction() {
        return this.fuzzySearchFunction;
    }

    @Override
    public String getStorageImplementationName() {
        return this.databaseName;
    }

    @Override
    public boolean isValid() {
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException e) {
            Log.warn((String)"JdbcStorage.isValid() failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> Query<T> query(QueryPredicate<T> queryPredicate) throws StorageException {
        return new JdbcQuery<T>(this, queryPredicate);
    }

    @Override
    public void rollback() throws StorageException {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new StorageException("Commit failed", e);
        }
    }

    public String toString() {
        return "JdbcStorage[" + this.connection + "]";
    }

    @Override
    protected void close() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            Log.warn((String)"Closing JDBC connection failed", (Throwable)e);
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            Log.warn((String)"Closing JDBC connection failed", (Throwable)e);
        }
        this.connection = null;
    }

    @Override
    protected boolean hasObjectStorage(StorageMapping<?, ?, ?> mapping) throws StorageException {
        return JdbcStorage.containsTable(this.connection, this.getSqlName(mapping, false));
    }

    @Override
    protected void initObjectStorage(StorageMapping<?, ?, ?> mapping) throws StorageException {
        if (!JdbcStorage.containsTable(this.connection, this.getSqlName(mapping, false))) {
            String createStatement = (String)mapping.get(JdbcRelationTypes.SQL_CREATE_STATEMENT);
            if (createStatement != null) {
                this.executeUpdate(createStatement, null, null, false, false);
            } else {
                this.createTable(mapping);
            }
            for (StorageMapping childMapping : mapping.getChildMappings()) {
                if (childMapping == mapping) continue;
                this.initObjectStorage(childMapping);
            }
        }
    }

    @Override
    protected void removeObjectStorage(StorageMapping<?, ?, ?> mapping) throws StorageException {
        if (JdbcStorage.containsTable(this.connection, this.getSqlName(mapping, false))) {
            String dropStatement = String.format(DROP_TABLE_TEMPLATE, this.getSqlName(mapping, true));
            this.executeUpdate(dropStatement, null, null, false, false);
        }
    }

    @Override
    protected void storeObject(Object object) throws Exception {
        Relatable relatable = ObjectRelations.getRelatable((Object)object);
        boolean insert = !relatable.hasFlag(StorageRelationTypes.PERSISTENT);
        StorageMapping<?, ?, ?> mapping = StorageManager.getMapping(object.getClass());
        this.storeReferences(relatable, mapping);
        if (this.needsToBeStored(relatable)) {
            this.storeAttributes(mapping, object, insert);
        }
        for (StorageMapping childMapping : mapping.getChildMappings()) {
            this.store(mapping.getChildren(object, childMapping));
        }
    }

    String getChildCountColumn(StorageMapping<?, ?, ?> childMapping) {
        String column = (String)childMapping.get(JdbcRelationTypes.SQL_CHILD_COUNT_COLUMN);
        if (column == null) {
            column = this.getSqlName(childMapping, true);
            column = CHILD_COUNT_PREFIX + column.substring(1, column.length() - 1);
            childMapping.set(JdbcRelationTypes.SQL_CHILD_COUNT_COLUMN, column);
        }
        return column;
    }

    String getSqlName(Object object, boolean quoted) {
        Relatable relatable = ObjectRelations.getRelatable((Object)object);
        String name = (String)relatable.get(JdbcRelationTypes.SQL_NAME);
        if (name == null) {
            name = (String)relatable.get(StorageRelationTypes.STORAGE_NAME);
            if (name == null) {
                name = TextUtil.uppercaseIdentifier((String)object.toString()).toLowerCase();
            }
            relatable.set(JdbcRelationTypes.SQL_NAME, (Object)name);
        }
        if (quoted && this.identifierQuote != '\u0000') {
            name = this.identifierQuote + name + this.identifierQuote;
        }
        return name;
    }

    final boolean isChildCountsEnabled(StorageMapping<?, ?, ?> mapping) {
        return childCountsEnabled && !mapping.hasFlag(JdbcRelationTypes.SQL_DISABLE_CHILD_COUNTS);
    }

    String mapSqlDatatype(Class<?> datatype) {
        if (datatype.isEnum()) {
            datatype = Enum.class;
        } else if (List.class.isAssignableFrom(datatype)) {
            datatype = List.class;
        } else if (Set.class.isAssignableFrom(datatype)) {
            datatype = Set.class;
        } else if (Map.class.isAssignableFrom(datatype)) {
            datatype = Map.class;
        }
        String sqlDatatype = this.datatypeMap.get(datatype);
        if (sqlDatatype == null) {
            sqlDatatype = DEFAULT_STRING_DATATYPE;
            Log.warnf((String)"No datatype mapping for '%s', using '%s' as default", (Object[])new Object[]{datatype, DEFAULT_STRING_DATATYPE});
        }
        return sqlDatatype;
    }

    <T> Object mapValue(StorageMapping<T, Relatable, ?> mapping, Object attribute, Object value) throws StorageException {
        RelationType type;
        Relatable attrRelatable = ObjectRelations.getRelatable((Object)attribute);
        value = value instanceof Enum || value instanceof GenericEnum || value instanceof Period ? (value instanceof HasOrder ? ((HasOrder)value).ordinal() + "-" + value : value.toString()) : (value instanceof RelationType ? ((type = (RelationType)value).hasFlag(JdbcRelationTypes.SQL_OMIT_NAMESPACE) ? type.getSimpleName() : type.getName()) : (value instanceof Class ? ((Class)value).getName() : mapping.mapValue(attrRelatable, value)));
        if (value != null) {
            if (value.getClass() == java.util.Date.class) {
                value = new Timestamp(((java.util.Date)value).getTime());
            } else if (attrRelatable.get(JdbcRelationTypes.SQL_DATATYPE) == DEFAULT_STRING_DATATYPE) {
                value = value.toString();
            }
        }
        return value;
    }

    private String createInsertStatement(StorageMapping<Object, Relatable, ?> mapping, boolean generatedId) throws StorageException {
        int size = mapping.getAttributes().size();
        StringBuilder columns = new StringBuilder(size * 10);
        StringBuilder parameters = new StringBuilder(size * 2);
        String sql = null;
        for (Relatable attr : mapping.getAttributes()) {
            String column = this.getSqlName(attr, true);
            if (attr.hasFlag(MetaTypes.AUTOGENERATED) && generatedId) continue;
            columns.append(column).append(',');
            parameters.append("?,");
        }
        if (columns.length() == 0) {
            throw new StorageException("No columns to insert: " + mapping);
        }
        if (this.isChildCountsEnabled(mapping)) {
            for (StorageMapping childMapping : mapping.getChildMappings()) {
                columns.append(this.getChildCountColumn(childMapping));
                columns.append(',');
                parameters.append("?,");
            }
        }
        columns.setLength(columns.length() - 1);
        parameters.setLength(parameters.length() - 1);
        sql = this.getSqlName(mapping, true);
        sql = JdbcStorage.formatStatement(INSERT_TEMPLATE, sql, columns, parameters);
        return sql;
    }

    private void createTable(StorageMapping<?, ?, ?> mapping) throws StorageException {
        StringBuilder columns = new StringBuilder();
        ArrayList<Relatable> referenceAttrs = new ArrayList<Relatable>();
        LinkedHashSet<Relatable> indexedAttrs = new LinkedHashSet<Relatable>();
        String tableName = this.getSqlName(mapping, true);
        String objectIdColumn = null;
        for (Relatable attr : mapping.getAttributes()) {
            String sqlName = this.getSqlName(attr, true);
            columns.append(sqlName);
            columns.append(' ');
            columns.append(this.mapColumnDatatype(mapping, attr));
            if (attr.hasFlag(MetaTypes.UNIQUE)) {
                columns.append(" UNIQUE");
            }
            if (attr.hasFlag(MetaTypes.MANDATORY)) {
                columns.append(" NOT NULL");
            }
            if (attr.hasFlag(MetaTypes.INDEXED)) {
                indexedAttrs.add(attr);
            }
            columns.append(',');
            if (attr.hasFlag(MetaTypes.OBJECT_ID_ATTRIBUTE)) {
                objectIdColumn = sqlName;
                continue;
            }
            if (!attr.hasFlag(MetaTypes.PARENT_ATTRIBUTE) && !attr.hasFlag(StorageRelationTypes.REFERENCE_ATTRIBUTE)) continue;
            referenceAttrs.add(attr);
        }
        if (this.isChildCountsEnabled(mapping)) {
            for (StorageMapping childMapping : mapping.getChildMappings()) {
                columns.append(this.getChildCountColumn(childMapping));
                columns.append(" INTEGER,");
            }
        }
        if (objectIdColumn != null) {
            columns.append(JdbcStorage.formatStatement(PRIMARY_KEY_TEMPLATE, objectIdColumn));
        }
        for (Relatable referenceAttr : referenceAttrs) {
            StorageMapping targetMapping = (StorageMapping)referenceAttr.get(StorageRelationTypes.STORAGE_MAPPING);
            if (!referenceAttr.hasFlag(MetaTypes.PARENT_ATTRIBUTE)) {
                this.initObjectStorage(targetMapping);
            }
            columns.append(JdbcStorage.formatStatement(FOREIGN_KEY_TEMPLATE, this.getSqlName(referenceAttr, true), this.getSqlName(targetMapping, true), this.getSqlName(targetMapping.getIdAttribute(), true)));
        }
        columns.setLength(columns.length() - 1);
        String sql = JdbcStorage.formatStatement(CREATE_TABLE_TEMPLATE, tableName, columns);
        Log.debug((String)sql);
        this.executeUpdate(sql, null, null, false, false);
        if (indexedAttrs.size() > 0) {
            String table = this.getSqlName(mapping, false);
            for (Relatable attr : indexedAttrs) {
                sql = JdbcStorage.formatStatement(INDEX_TEMPLATE, table, this.getSqlName(attr, false));
                Log.debug((String)sql);
                this.executeUpdate(sql, null, null, false, false);
            }
        }
    }

    private String createUpdateStatement(StorageMapping<?, ?, ?> mapping) throws StorageException {
        int size = mapping.getAttributes().size();
        StringBuilder columns = new StringBuilder(size * 10);
        StringBuilder identity = new StringBuilder();
        for (Relatable attr : mapping.getAttributes()) {
            String column = this.getSqlName(attr, true);
            if (attr.hasFlag(MetaTypes.OBJECT_ID_ATTRIBUTE)) {
                identity.append(column).append("=?");
                continue;
            }
            columns.append(column).append("=?,");
        }
        if (columns.length() == 0 || identity.length() == 0) {
            throw new StorageException("No columns or primary key for update: " + mapping);
        }
        if (this.isChildCountsEnabled(mapping)) {
            for (StorageMapping childMapping : mapping.getChildMappings()) {
                columns.append(this.getChildCountColumn(childMapping));
                columns.append("=?,");
            }
        }
        columns.setLength(columns.length() - 1);
        return JdbcStorage.formatStatement(UPDATE_TEMPLATE, this.getSqlName(mapping, true), columns, identity);
    }

    private void executeUpdate(String sql, StorageMapping<Object, Relatable, ?> mapping, Object object, boolean insert, boolean generatedId) throws StorageException {
        try (PreparedStatement statement = this.prepareStatement(sql, generatedId);){
            if (mapping != null) {
                this.setStatementParameters(statement, mapping, object, insert, generatedId);
            }
            statement.executeUpdate();
            if (generatedId) {
                this.setGeneratedKey(statement, mapping, object);
            }
        }
        catch (SQLException e) {
            String message = object != null ? String.format("SQL %s failed for %s (%s", insert ? "insert" : "update", object, sql) : String.format("SQL statement failed: " + sql, new Object[0]);
            Log.error((String)message, (Throwable)e);
            throw new StorageException(message, e);
        }
    }

    private String getAutoIdDatatype(StorageMapping<?, ?, ?> mapping, RelationType<String> autoIdAttrType) {
        String sqlDatatype = mapping.hasRelation(autoIdAttrType) ? (String)mapping.get(autoIdAttrType) : (String)this.get(autoIdAttrType);
        return sqlDatatype;
    }

    private String mapColumnDatatype(StorageMapping<?, ?, ?> mapping, Relatable columnAttr) throws StorageException {
        String sqlDatatype = null;
        if (columnAttr.hasRelation(JdbcRelationTypes.SQL_DATATYPE)) {
            sqlDatatype = (String)columnAttr.get(JdbcRelationTypes.SQL_DATATYPE);
        } else {
            if (columnAttr.hasRelation(StorageRelationTypes.STORAGE_DATATYPE)) {
                Class datatype = (Class)columnAttr.get(StorageRelationTypes.STORAGE_DATATYPE);
                if (columnAttr.hasFlag(MetaTypes.AUTOGENERATED)) {
                    sqlDatatype = datatype == Long.class ? this.getAutoIdDatatype(mapping, JdbcRelationTypes.SQL_LONG_AUTO_IDENTITY_DATATYPE) : this.getAutoIdDatatype(mapping, JdbcRelationTypes.SQL_AUTO_IDENTITY_DATATYPE);
                } else {
                    sqlDatatype = this.mapSqlDatatype(datatype);
                    if (sqlDatatype.indexOf(37) >= 0) {
                        sqlDatatype = String.format(sqlDatatype, columnAttr.get(StorageRelationTypes.STORAGE_LENGTH));
                    }
                }
            }
            if (sqlDatatype != null) {
                columnAttr.set(JdbcRelationTypes.SQL_DATATYPE, (Object)sqlDatatype);
            } else {
                throw new StorageException("No SQL datatype mapping for: " + columnAttr);
            }
        }
        return sqlDatatype;
    }

    private boolean needsToBeStored(Relatable relatable) {
        return !relatable.hasRelation(MetaTypes.MODIFIED) || relatable.hasFlag(MetaTypes.MODIFIED);
    }

    private PreparedStatement prepareStatement(String sQL, boolean returnKeys) throws StorageException {
        try {
            int returnKeysMode = returnKeys ? 1 : 2;
            return this.connection.prepareStatement(sQL, returnKeysMode);
        }
        catch (SQLException e) {
            Log.error((String)("Preparing statement failed: " + sQL), (Throwable)e);
            throw new StorageException("Preparing statement failed", e);
        }
    }

    private Object setGeneratedKey(Statement statement, StorageMapping<Object, Relatable, ?> mapping, Object object) throws StorageException {
        Relatable idAttribute = mapping.getIdAttribute();
        long generatedKey = -1L;
        try {
            ResultSet keyResult = null;
            if (idAttribute != null) {
                DatabaseMetaData metaData = this.connection.getMetaData();
                if (metaData.supportsGetGeneratedKeys()) {
                    keyResult = statement.getGeneratedKeys();
                }
                if (keyResult != null && keyResult.next()) {
                    generatedKey = keyResult.getLong(1);
                }
                if (idAttribute.get(StorageRelationTypes.STORAGE_DATATYPE) == Long.class) {
                    mapping.setAttributeValue(object, idAttribute, generatedKey);
                } else {
                    mapping.setAttributeValue(object, idAttribute, (int)generatedKey);
                }
                Log.debugf((String)"Generated key %d for %s", (Object[])new Object[]{generatedKey, object});
            }
        }
        catch (SQLException e) {
            throw new StorageException("Retrieving generated key failed", e);
        }
        return generatedKey;
    }

    private <C extends StorageMapping<?, Relatable, ?>> void setStatementParameters(PreparedStatement statement, StorageMapping<Object, Relatable, C> mapping, Object object, boolean insert, boolean ignoreId) throws SQLException, StorageException {
        ArrayList<Object> params = new ArrayList<Object>();
        Object identityValue = null;
        int paramIndex = 1;
        for (Relatable attr : mapping.getAttributes()) {
            Object param = mapping.getAttributeValue(object, attr);
            boolean setParam = true;
            param = this.mapValue(mapping, attr, param);
            if (attr.hasFlag(MetaTypes.OBJECT_ID_ATTRIBUTE)) {
                identityValue = param;
                boolean bl = setParam = insert && !ignoreId;
            }
            if (!setParam) continue;
            statement.setObject(paramIndex++, param);
            params.add(param);
        }
        if (this.isChildCountsEnabled(mapping)) {
            for (StorageMapping childMapping : mapping.getChildMappings()) {
                int children = mapping.getChildren(object, childMapping).size();
                Integer childCount = children;
                statement.setObject(paramIndex++, childCount);
                params.add(childCount);
            }
        }
        if (!insert) {
            if (identityValue != null) {
                statement.setObject(paramIndex++, identityValue);
                params.add(identityValue);
            } else {
                throw new StorageException("No identity attribute defined in " + mapping);
            }
        }
        Log.debugf((String)"StatementParams: %s", (Object[])new Object[]{params});
    }

    private void storeAttributes(StorageMapping<Object, Relatable, ?> mapping, Object object, boolean insert) throws StorageException {
        String sql;
        Relatable idAttribute = mapping.getIdAttribute();
        boolean generatedId = false;
        if (insert) {
            if (idAttribute.hasFlag(MetaTypes.AUTOGENERATED)) {
                Object id = mapping.getAttributeValue(object, idAttribute);
                generatedId = id == null || ((Number)id).longValue() <= 0L;
            }
            sql = this.createInsertStatement(mapping, generatedId);
        } else {
            sql = this.createUpdateStatement(mapping);
        }
        Log.debug((String)sql);
        this.executeUpdate(sql, mapping, object, insert, generatedId);
    }

    private void storeReferences(Relatable object, StorageMapping<Object, Relatable, ?> mapping) throws StorageException {
        for (Relatable attr : mapping.getAttributes()) {
            Relatable refRelatable;
            Object reference;
            StorageMapping referenceMapping;
            if (mapping.isHierarchyAttribute(attr) || (referenceMapping = (StorageMapping)attr.get(StorageRelationTypes.STORAGE_MAPPING)) == null || (reference = mapping.getAttributeValue(object, attr)) == null || (refRelatable = ObjectRelations.getRelatable((Object)reference)).hasRelation(StorageRelationTypes.STORING) || !this.needsToBeStored(refRelatable)) continue;
            referenceMapping.storeReference(object, reference);
        }
    }

    static {
        childCountsEnabled = true;
        nextId = 1;
        HashMap<Class<Object>, String> sqlDatatypeMap = new HashMap<Class<Object>, String>();
        sqlDatatypeMap.put(Byte.class, "TINYINT");
        sqlDatatypeMap.put(Byte.TYPE, "TINYINT");
        sqlDatatypeMap.put(byte[].class, "VARBINARY(%d)");
        sqlDatatypeMap.put(Short.class, "SHORT");
        sqlDatatypeMap.put(Short.TYPE, "SHORT");
        sqlDatatypeMap.put(Integer.class, "INTEGER");
        sqlDatatypeMap.put(Integer.TYPE, "INTEGER");
        sqlDatatypeMap.put(Long.class, "BIGINT");
        sqlDatatypeMap.put(Long.TYPE, "BIGINT");
        sqlDatatypeMap.put(Float.class, "REAL");
        sqlDatatypeMap.put(Float.TYPE, "REAL");
        sqlDatatypeMap.put(Double.class, "DOUBLE");
        sqlDatatypeMap.put(Double.TYPE, "DOUBLE");
        sqlDatatypeMap.put(Boolean.class, "BOOLEAN");
        sqlDatatypeMap.put(Boolean.TYPE, "BOOLEAN");
        sqlDatatypeMap.put(BigInteger.class, "DECIMAL(1000)");
        sqlDatatypeMap.put(BigDecimal.class, "DECIMAL");
        sqlDatatypeMap.put(String.class, "VARCHAR(%d)");
        sqlDatatypeMap.put(Enum.class, "VARCHAR(255)");
        sqlDatatypeMap.put(Class.class, "VARCHAR(511)");
        sqlDatatypeMap.put(RelationType.class, "VARCHAR(511)");
        sqlDatatypeMap.put(Period.class, "VARCHAR(255)");
        sqlDatatypeMap.put(java.util.Date.class, "TIMESTAMP");
        sqlDatatypeMap.put(Timestamp.class, "TIMESTAMP");
        sqlDatatypeMap.put(Date.class, "DATE");
        sqlDatatypeMap.put(Time.class, "TIME");
        sqlDatatypeMap.put(List.class, "VARCHAR(%d)");
        sqlDatatypeMap.put(Set.class, "VARCHAR(%d)");
        sqlDatatypeMap.put(Map.class, "VARCHAR(%d)");
        STANDARD_SQL_DATATYPE_MAP = Collections.unmodifiableMap(sqlDatatypeMap);
    }
}

