/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage.impl.jdbc;

import de.esoco.lib.json.JsonObject;
import de.esoco.storage.StorageDefinition;
import de.esoco.storage.impl.jdbc.JdbcDataSourceStorageDefinition;
import de.esoco.storage.impl.jdbc.JdbcDriverStorageDefinition;
import de.esoco.storage.impl.jdbc.JdbcRelationTypes;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;

public abstract class JdbcStorageDefinition
extends StorageDefinition {
    private static final long serialVersionUID = 1L;

    public static JdbcStorageDefinition create(DataSource dataSource) {
        return new JdbcDataSourceStorageDefinition(dataSource);
    }

    public static JdbcDriverStorageDefinition create(String connectURL) {
        return new JdbcDriverStorageDefinition(connectURL, null);
    }

    public static JdbcDriverStorageDefinition create(String connectURL, Properties properties) {
        return new JdbcDriverStorageDefinition(connectURL, properties);
    }

    protected Relatable getDatabaseParameters(Connection connection) throws SQLException {
        RelatedObject parameters = new RelatedObject();
        String fuzzyFunction = System.getProperty("storage.sql.fuzzy");
        if (fuzzyFunction == null) {
            fuzzyFunction = "soundex";
        }
        String databaseName = connection.getMetaData().getDatabaseProductName().toLowerCase();
        Map datatypeMap = (Map)parameters.get(JdbcRelationTypes.SQL_DATATYPE_MAP);
        if (databaseName.contains("postgres")) {
            fuzzyFunction = "dmetaphone";
            parameters.set(JdbcRelationTypes.SQL_AUTO_IDENTITY_DATATYPE, (Object)"SERIAL");
            parameters.set(JdbcRelationTypes.SQL_LONG_AUTO_IDENTITY_DATATYPE, (Object)"BIGSERIAL");
            parameters.set(JdbcRelationTypes.SQL_QUERY_PAGING_EXPRESSION, null);
            parameters.set(JdbcRelationTypes.SQL_QUERY_LIMIT_EXPRESSION, null);
            datatypeMap.put(String.class, "TEXT");
            datatypeMap.put(byte[].class, "BYTEA");
            datatypeMap.put(Map.class, "HSTORE");
            datatypeMap.put(JsonObject.class, "JSONB");
        } else if (databaseName.contains("mysql") || databaseName.contains("mariadb")) {
            parameters.set(JdbcRelationTypes.SQL_IDENTITIFIER_QUOTE, (Object)Character.valueOf('`'));
            datatypeMap.put(String.class, "TEXT");
        }
        parameters.set(JdbcRelationTypes.SQL_FUZZY_SEARCH_FUNCTION, (Object)fuzzyFunction);
        return parameters;
    }

    static {
        JdbcRelationTypes.init();
    }
}

