/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage.mapping;

import de.esoco.lib.datatype.Period;
import de.esoco.lib.expression.Conversions;
import de.esoco.lib.logging.Log;
import de.esoco.lib.manage.TransactionManager;
import de.esoco.lib.manage.Transactional;
import de.esoco.lib.property.HasOrder;
import de.esoco.lib.reflect.ReflectUtil;
import de.esoco.storage.Storage;
import de.esoco.storage.StorageException;
import de.esoco.storage.StorageManager;
import de.esoco.storage.StorageMapping;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationType;
import org.obrel.type.MetaTypes;

public abstract class AbstractStorageMapping<T, A extends Relatable, C extends StorageMapping<?, A, ?>>
extends RelatedObject
implements StorageMapping<T, A, C> {
    @Override
    public Object checkAttributeValue(A attribute, Object value) throws StorageException {
        if (value != null) {
            Class<?> valueType;
            Class datatype = this.getAttributeDatatype((Relatable)attribute);
            if (datatype != String.class) {
                if (datatype.isPrimitive()) {
                    datatype = ReflectUtil.getWrapperType((Class)datatype);
                }
                if (value instanceof String) {
                    value = this.parseStringValue(attribute, datatype, (String)value);
                } else if (datatype == Long.class && value instanceof Number) {
                    value = ((Number)value).longValue();
                } else if (datatype == BigInteger.class && value instanceof BigDecimal) {
                    value = ((BigDecimal)value).toBigIntegerExact();
                }
            }
            if (!datatype.isAssignableFrom(valueType = value.getClass())) {
                String message = String.format("Attribute type mismatch: %s (expected: %s)", valueType, datatype);
                throw new IllegalArgumentException(message);
            }
        }
        return value;
    }

    @Override
    public Object mapValue(A attribute, Object value) throws StorageException {
        if (value instanceof Collection || value instanceof Map) {
            value = Conversions.asString((Object)value);
        }
        return value;
    }

    @Override
    public void storeReference(Relatable sourceObject, T referencedObject) throws StorageException {
        TransactionManager.begin();
        try {
            Storage storage = StorageManager.getStorage(referencedObject.getClass());
            TransactionManager.addTransactionElement((Transactional)storage);
            storage.store(referencedObject);
            TransactionManager.commit();
        }
        catch (Exception e) {
            try {
                TransactionManager.rollback();
            }
            catch (Exception rollback) {
                Log.error((String)"Transaction rollback failed", (Throwable)rollback);
            }
            if (e instanceof StorageException) {
                throw (StorageException)e;
            }
            throw new StorageException(e);
        }
    }

    private Object parseStringValue(A attribute, Class<?> datatype, String value) {
        Object result;
        if (datatype == Class.class) {
            try {
                result = Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        } else if (RelationType.class.isAssignableFrom(datatype)) {
            result = RelationType.valueOf((String)value);
            if (result == null) {
                throw new IllegalStateException("Undefined RelationType " + value);
            }
        } else if (datatype.isEnum()) {
            if (HasOrder.class.isAssignableFrom(datatype)) {
                value = value.substring(value.indexOf(45) + 1);
            }
            result = Enum.valueOf(datatype, value.toUpperCase());
        } else {
            result = datatype == Period.class ? Period.valueOf((String)value) : (Collection.class.isAssignableFrom(datatype) ? Conversions.parseCollection((String)value, datatype, (Class)((Class)attribute.get(MetaTypes.ELEMENT_DATATYPE)), (boolean)attribute.hasFlag(MetaTypes.ORDERED)) : (Map.class.isAssignableFrom(datatype) ? Conversions.parseMap((String)value, datatype, (Class)((Class)attribute.get(MetaTypes.KEY_DATATYPE)), (Class)((Class)attribute.get(MetaTypes.VALUE_DATATYPE)), (boolean)attribute.hasFlag(MetaTypes.ORDERED)) : this.tryInvokeParseMethod(datatype, value)));
        }
        return result;
    }

    private Object tryInvokeParseMethod(Class<?> datatype, String value) {
        Object[] args = new Object[]{value};
        Object parsedValue = value;
        try {
            parsedValue = ReflectUtil.newInstance(datatype, (Object[])args, null);
        }
        catch (Exception e) {
            try {
                parsedValue = ReflectUtil.invokePublic(datatype, (String)"valueOf", (Object[])args, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parsedValue;
    }
}

