/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage.mapping;

import de.esoco.lib.logging.Log;
import de.esoco.storage.StorageException;
import de.esoco.storage.StorageManager;
import de.esoco.storage.StorageMapping;
import de.esoco.storage.StorageRelationTypes;
import de.esoco.storage.mapping.AbstractStorageMapping;
import de.esoco.storage.mapping.FieldDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.obrel.core.ObjectRelations;
import org.obrel.type.MetaTypes;

public class ClassMapping<T>
extends AbstractStorageMapping<T, FieldDescriptor, ClassMapping<?>> {
    private static final int IGNORED_MODIFIERS = 200;
    private final Class<T> mappedType;
    private FieldDescriptor idAttribute;
    private FieldDescriptor parentAttribute;
    private List<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
    private Map<ClassMapping<?>, FieldDescriptor> childFields = new LinkedHashMap();

    public ClassMapping(Class<T> mappedType) {
        this.mappedType = mappedType;
        ObjectRelations.getRelatable(mappedType).set(StorageRelationTypes.STORAGE_MAPPING, (Object)this);
        this.analyzeFields();
        this.set(StorageRelationTypes.STORAGE_NAME, mappedType.getSimpleName());
    }

    @Override
    public T createObject(List<?> attributeValues, boolean asChild) {
        try {
            T object = this.mappedType.newInstance();
            int valueIndex = 0;
            for (FieldDescriptor field : this.fieldDescriptors) {
                Object value = attributeValues.get(valueIndex++);
                if (field.hasFlag(MetaTypes.PARENT_ATTRIBUTE)) continue;
                value = this.checkAttributeValue(field, value);
                field.setFieldValue(object, value);
            }
            return object;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create instance of " + this.mappedType, e);
        }
    }

    @Override
    public Class<?> getAttributeDatatype(FieldDescriptor field) {
        return field.getField().getType();
    }

    @Override
    public Object getAttributeValue(T object, FieldDescriptor field) throws StorageException {
        Object value = field.getFieldValue(object);
        if (value != null && field.hasRelation(StorageRelationTypes.STORAGE_MAPPING)) {
            StorageMapping mapping = (StorageMapping)field.get(StorageRelationTypes.STORAGE_MAPPING);
            value = mapping.getAttributeValue(value, mapping.getIdAttribute());
        }
        return value;
    }

    @Override
    public Collection<FieldDescriptor> getAttributes() {
        return this.fieldDescriptors;
    }

    @Override
    public Collection<ClassMapping<?>> getChildMappings() {
        return this.childFields.keySet();
    }

    @Override
    public Collection<?> getChildren(T object, ClassMapping<?> childMapping) {
        return (Collection)this.childFields.get(childMapping).getFieldValue(object);
    }

    public FieldDescriptor getFieldDescriptor(String fieldName) {
        for (FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
            if (!fieldDescriptor.getField().getName().equals(fieldName)) continue;
            return fieldDescriptor;
        }
        return null;
    }

    @Override
    public FieldDescriptor getIdAttribute() {
        return this.idAttribute;
    }

    @Override
    public Class<T> getMappedType() {
        return this.mappedType;
    }

    @Override
    public FieldDescriptor getParentAttribute(StorageMapping<?, ?, ?> parentMapping) {
        FieldDescriptor result = null;
        if (this.parentAttribute != null && this.parentAttribute.get(StorageRelationTypes.STORAGE_MAPPING) == parentMapping) {
            result = this.parentAttribute;
        }
        return result;
    }

    @Override
    public void initChildren(T parent, List<?> children, ClassMapping<?> childMapping) {
        for (Object child : children) {
            childMapping.parentAttribute.setFieldValue(child, parent);
        }
    }

    @Override
    public boolean isDeleteAllowed() {
        return true;
    }

    @Override
    public boolean isHierarchyAttribute(FieldDescriptor attribute) {
        return attribute.hasFlag(MetaTypes.PARENT_ATTRIBUTE);
    }

    @Override
    public void setAttributeValue(T object, FieldDescriptor field, Object value) {
        field.setFieldValue(object, value);
    }

    @Override
    public void setChildren(T parent, List<?> children, ClassMapping<?> childMapping) {
        this.childFields.get(childMapping).setFieldValue(parent, children);
    }

    public String toString() {
        return String.format("ClassMapping[%s]", this.mappedType.getSimpleName());
    }

    private void analyzeFields() {
        for (Field field : this.mappedType.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if ((modifiers & 0xC8) != 0) continue;
            FieldDescriptor fieldDescriptor = new FieldDescriptor(field);
            if (fieldDescriptor.hasFlag(MetaTypes.OBJECT_ID_ATTRIBUTE)) {
                this.idAttribute = fieldDescriptor;
            } else if (fieldDescriptor.hasFlag(MetaTypes.PARENT_ATTRIBUTE)) {
                this.parentAttribute = fieldDescriptor;
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                ClassMapping<?> childMapping = this.createChildMapping(field);
                this.childFields.put(childMapping, fieldDescriptor);
                Log.debug((String)String.format("Child Mapping: %s,%s", new Object[]{childMapping, fieldDescriptor}));
                continue;
            }
            this.fieldDescriptors.add(fieldDescriptor);
            Log.debug((String)String.format("Field Mapping: %s", new Object[]{fieldDescriptor}));
        }
        this.fieldDescriptors = Collections.unmodifiableList(this.fieldDescriptors);
        this.childFields = Collections.unmodifiableMap(this.childFields);
    }

    private ClassMapping<?> createChildMapping(Field field) {
        Type[] types;
        assert (Collection.class.isAssignableFrom(field.getType()));
        Type genericType = field.getGenericType();
        Class elementType = null;
        if (genericType instanceof ParameterizedType && (types = ((ParameterizedType)genericType).getActualTypeArguments()).length == 1 && types[0] instanceof Class) {
            elementType = (Class)types[0];
        }
        if (elementType == null) {
            throw new IllegalArgumentException("Could not determine element type of " + field.getName());
        }
        ClassMapping childMapping = (ClassMapping)StorageManager.getMapping(elementType);
        return childMapping;
    }
}

