/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.storage.mapping;

import de.esoco.storage.StorageManager;
import de.esoco.storage.StorageRelationTypes;
import de.esoco.storage.mapping.ClassMapping;
import java.lang.reflect.Field;
import org.obrel.core.RelatedObject;
import org.obrel.type.MetaTypes;

public class FieldDescriptor
extends RelatedObject {
    private Field field;

    FieldDescriptor(Field field) {
        this.field = field;
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if (fieldName.length() >= 2 && Character.isLowerCase(fieldName.charAt(0)) && Character.isUpperCase(fieldName.charAt(1))) {
            fieldName = fieldName.substring(1);
        }
        this.set(StorageRelationTypes.STORAGE_NAME, fieldName);
        this.set(StorageRelationTypes.STORAGE_DATATYPE, fieldType);
        if (fieldName.equalsIgnoreCase("id")) {
            this.set(MetaTypes.OBJECT_ID_ATTRIBUTE, true);
            if (fieldType == Integer.TYPE || fieldType == Integer.class || fieldType == Long.TYPE || fieldType == Long.class) {
                this.set(MetaTypes.AUTOGENERATED, true);
            }
        } else if (fieldName.equalsIgnoreCase("parent")) {
            ClassMapping parentMapping = (ClassMapping)StorageManager.getMapping(field.getType());
            this.set(StorageRelationTypes.STORAGE_MAPPING, parentMapping);
            this.set(MetaTypes.PARENT_ATTRIBUTE, true);
            this.set(StorageRelationTypes.STORAGE_DATATYPE, Integer.TYPE);
        }
    }

    public final Field getField() {
        return this.field;
    }

    public String toString() {
        return String.format("FieldDescriptor[%s,%s]", this.field.getName(), this.field.getType().getSimpleName());
    }

    Object getFieldValue(Object object) {
        try {
            return this.field.get(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot access field " + this.field.getName());
        }
    }

    void setFieldValue(Object object, Object value) {
        try {
            this.field.set(object, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot access field " + this.field.getName(), e);
        }
    }
}

