/*
 * Decompiled with CFR 0.152.
 */
package de.evosec.gradle.gitflow.release;

import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import de.evosec.gradle.gitflow.release.ReleasePlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Internal;

public class AbstractTask
extends DefaultTask {
    @Internal
    private ReleasePlugin plugin;
    @Internal
    private JGitFlow flow;

    void setPlugin(ReleasePlugin plugin) {
        this.plugin = plugin;
    }

    public ReleasePlugin getPlugin() {
        return this.plugin;
    }

    protected JGitFlow ensureGitFlow() throws JGitFlowException {
        if (this.flow == null) {
            this.flow = JGitFlow.getOrInit((File)this.findWorkTree());
        }
        return this.flow;
    }

    protected void updateVersionAndCommit(JGitFlow flow, String targetVersion, String versionType) throws GitAPIException {
        String filepattern = this.findWorkTree().toPath().normalize().relativize(this.findPropertiesFile()).toString();
        this.updateVersionProperty(targetVersion);
        flow.git().add().addFilepattern(filepattern).call();
        flow.git().commit().setMessage("update version to " + targetVersion + " " + versionType).call();
    }

    private File findWorkTree() {
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        repositoryBuilder.findGitDir();
        if (repositoryBuilder.getGitDir() == null) {
            throw new IllegalStateException("unable to find git working directory");
        }
        try {
            return repositoryBuilder.build().getWorkTree();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to find git working directory", e);
        }
    }

    protected void checkPropertiesFile() {
        Properties properties = new Properties();
        Path path = this.findPropertiesFile();
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            properties.load(is);
        }
        catch (IOException e) {
            throw new GradleException("unable to read " + this.getFilename(path), (Throwable)e);
        }
        if (!this.isVersionDefined()) {
            this.getProject().setVersion((Object)properties.getProperty("version"));
        }
    }

    @Internal
    private boolean isVersionDefined() {
        return this.getProject().getVersion() != null && !"unspecified".equals(this.getProject().getVersion());
    }

    private Path findPropertiesFile() {
        String versionPropertyFileName = this.plugin.getExtension().getVersionPropertyFile();
        File propertiesFile = this.getProject().file((Object)versionPropertyFileName);
        if (!propertiesFile.isFile()) {
            throw new GradleException("version property file [" + versionPropertyFileName + "] not found, please create it manually and and specify the version property.");
        }
        return propertiesFile.getAbsoluteFile().toPath();
    }

    protected void updateVersionProperty(String newVersion) {
        String oldVersion = "${project.version}";
        if (!Objects.equals(oldVersion, newVersion)) {
            this.getProject().setVersion((Object)newVersion);
            this.getProject().subprojects(subProject -> subProject.setVersion((Object)newVersion));
            Path propFile = this.findPropertiesFile();
            this.writeVersion(propFile, "version", newVersion);
        }
    }

    private void writeVersion(Path path, String key, String version) {
        try {
            String propertiesFile = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            Pattern pattern = Pattern.compile("^(" + key + "\\s*=\\s*).+$", 8);
            Matcher matcher = pattern.matcher(propertiesFile);
            if (!matcher.find()) {
                throw new GradleException("could not write version");
            }
            propertiesFile = matcher.replaceAll("$1" + version);
            Files.write(path, propertiesFile.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GradleException("unable to update " + this.getFilename(path), (Throwable)e);
        }
    }

    private String getFilename(Path path) {
        Path fileName = path.getFileName();
        return fileName == null ? path.toString() : fileName.toString();
    }
}

