/*
 * Decompiled with CFR 0.152.
 */
package de.evosec.gradle.gitflow.release;

import java.util.Map;
import org.gradle.api.Project;

public class ReleaseExtension {
    private String username = null;
    private String password = null;
    private int androidVersionCodeOffset = 0;
    private boolean failOnSnapshotDependencies = true;
    private boolean pushAfterReleaseFinish = false;
    private boolean incrementMinorVersion = false;
    private boolean allowUntracked = false;
    private String versionPropertyFile = "gradle.properties";

    public ReleaseExtension(Project project) {
    }

    public void afterEvaluate(Project project) {
        Map properties = project.getProperties();
        if (project.hasProperty("release.username")) {
            this.setUsername(properties.get("release.username").toString());
        }
        if (project.hasProperty("release.password")) {
            this.setPassword(properties.get("release.password").toString());
        }
        if (project.hasProperty("release.versionPropertyFile")) {
            this.setVersionPropertyFile(properties.get("release.versionPropertyFile").toString());
        }
        if (project.hasProperty("release.allowUntracked")) {
            this.setAllowUntracked(Boolean.valueOf(properties.get("release.allowUntracked").toString()));
        }
        if (project.hasProperty("release.incrementMinorVersion")) {
            this.setIncrementMinorVersion(Boolean.valueOf(properties.get("release.incrementMinorVersion").toString()));
        }
        if (project.hasProperty("release.pushAfterReleaseFinish")) {
            this.setPushAfterReleaseFinish(Boolean.valueOf(properties.get("release.pushAfterReleaseFinish").toString()));
        }
        if (project.hasProperty("release.failOnSnapshotDependencies")) {
            this.setFailOnSnapshotDependencies(Boolean.valueOf(properties.get("release.failOnSnapshotDependencies").toString()));
        }
        if (project.hasProperty("release.androidVersionCodeOffset")) {
            this.setAndroidVersionCodeOffset(Integer.parseInt(properties.get("release.androidVersionCodeOffset").toString()));
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getAndroidVersionCodeOffset() {
        return this.androidVersionCodeOffset;
    }

    public void setAndroidVersionCodeOffset(int androidVersionCodeOffset) {
        this.androidVersionCodeOffset = androidVersionCodeOffset;
    }

    public boolean isFailOnSnapshotDependencies() {
        return this.failOnSnapshotDependencies;
    }

    public void setFailOnSnapshotDependencies(boolean failOnSnapshotDependencies) {
        this.failOnSnapshotDependencies = failOnSnapshotDependencies;
    }

    public boolean isPushAfterReleaseFinish() {
        return this.pushAfterReleaseFinish;
    }

    public void setPushAfterReleaseFinish(boolean pushAfterReleaseFinish) {
        this.pushAfterReleaseFinish = pushAfterReleaseFinish;
    }

    public boolean isIncrementMinorVersion() {
        return this.incrementMinorVersion;
    }

    public void setIncrementMinorVersion(boolean incrementMinorVersion) {
        this.incrementMinorVersion = incrementMinorVersion;
    }

    public boolean isAllowUntracked() {
        return this.allowUntracked;
    }

    public void setAllowUntracked(boolean allowUntracked) {
        this.allowUntracked = allowUntracked;
    }

    public String getVersionPropertyFile() {
        return this.versionPropertyFile;
    }

    public void setVersionPropertyFile(String versionPropertyFile) {
        this.versionPropertyFile = versionPropertyFile;
    }
}

