/*
 * Decompiled with CFR 0.152.
 */
package de.evosec.gradle.gitflow.release;

import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.github.zafarkhaja.semver.Version;
import de.evosec.gradle.gitflow.release.AbstractTask;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class ReleaseFinishTask
extends AbstractTask {
    @TaskAction
    public void releaseFinish() throws JGitFlowException, GitAPIException {
        JGitFlow flow = this.ensureGitFlow();
        Version version = Version.valueOf((String)this.getProject().getVersion().toString());
        flow.releaseFinish(version.getNormalVersion()).setAllowUntracked(this.getPlugin().getExtension().isAllowUntracked()).call();
        this.delay();
        version = this.getPlugin().getExtension().isIncrementMinorVersion() ? version.incrementMinorVersion("SNAPSHOT") : version.incrementPatchVersion("SNAPSHOT");
        this.updateVersionAndCommit(flow, version.toString(), "development");
        if (this.getPlugin().getExtension().isPushAfterReleaseFinish()) {
            flow.git().push().setPushTags().setPushAll().call();
        }
    }

    private void delay() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new GradleException("release finish interrupted", (Throwable)e);
        }
    }
}

