/*
 * Decompiled with CFR 0.152.
 */
package de.evosec.gradle.gitflow.release;

import com.github.zafarkhaja.semver.Version;
import de.evosec.gradle.gitflow.release.GitCredentialsProvider;
import de.evosec.gradle.gitflow.release.ReleaseExtension;
import de.evosec.gradle.gitflow.release.ReleaseFinishTask;
import de.evosec.gradle.gitflow.release.ReleaseStartTask;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtraPropertiesExtension;

public class ReleasePlugin
implements Plugin<Project> {
    private ReleaseExtension extension;

    public void apply(Project project) {
        this.extension = (ReleaseExtension)project.getExtensions().create("release", ReleaseExtension.class, new Object[]{project});
        project.afterEvaluate(this.extension::afterEvaluate);
        CredentialsProvider.setDefault((CredentialsProvider)new GitCredentialsProvider(this.extension));
        project.allprojects(this::setAndroidVersion);
        project.getTasks().create("releaseStart", ReleaseStartTask.class, task -> task.setPlugin(this));
        project.getTasks().create("releaseFinish", ReleaseFinishTask.class, task -> task.setPlugin(this));
    }

    ReleaseExtension getExtension() {
        return this.extension;
    }

    private void setAndroidVersion(Project project) {
        Object extObj = project.getExtensions().findByName("ext");
        if (!(extObj instanceof ExtraPropertiesExtension)) {
            return;
        }
        Version version = Version.valueOf((String)project.getVersion().toString());
        int versionCode = this.extension.getAndroidVersionCodeOffset();
        versionCode += version.getPatchVersion();
        versionCode += version.getMinorVersion() * 1000;
        ExtraPropertiesExtension ext = (ExtraPropertiesExtension)extObj;
        ext.set("releaseAndroidVersionCode", (Object)(versionCode += version.getMajorVersion() * 1000000));
        ext.set("releaseAndroidVersionName", (Object)project.getVersion().toString());
    }
}

