/*
 * Decompiled with CFR 0.152.
 */
package de.evosec.gradle.gitflow.release;

import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.github.zafarkhaja.semver.Version;
import de.evosec.gradle.gitflow.release.AbstractTask;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.tasks.TaskAction;

public class ReleaseStartTask
extends AbstractTask {
    @TaskAction
    public void releaseStart() throws JGitFlowException, GitAPIException {
        this.checkPropertiesFile();
        this.checkSnapshotDependencies();
        JGitFlow flow = this.ensureGitFlow();
        Version version = Version.valueOf((String)this.getProject().getVersion().toString());
        try {
            flow.releaseStart(version.getNormalVersion()).setAllowUntracked(this.getPlugin().getExtension().isAllowUntracked()).call();
        }
        catch (DirtyWorkingTreeException e) {
            throw new GradleException(e.getMessage(), (Throwable)e);
        }
        this.updateVersionAndCommit(flow, version.getNormalVersion(), "release");
    }

    private void checkSnapshotDependencies() {
        StringBuilder messageBuilder = new StringBuilder();
        Action<Project> dependencyChecker = this.getDependencyChecker(messageBuilder);
        dependencyChecker.execute((Object)this.getProject());
        this.getProject().subprojects(dependencyChecker);
        String message = messageBuilder.toString();
        if (!message.isEmpty()) {
            message = "Snapshot dependencies detected: " + message;
            this.warnOrThrow(this.getPlugin().getExtension().isFailOnSnapshotDependencies(), message);
        }
    }

    private Action<Project> getDependencyChecker(StringBuilder messageBuilder) {
        return project -> {
            List snapshotDependencies = project.getConfigurations().stream().flatMap(c -> c.getDependencies().stream()).filter(d -> !(d instanceof ProjectDependency)).filter(d -> d.getVersion() != null && d.getVersion().contains("SNAPSHOT")).map(d -> {
                String group = d.getGroup() == null ? "" : d.getGroup();
                return group + ":" + d.getName() + ":" + d.getVersion();
            }).collect(Collectors.toList());
            if (!snapshotDependencies.isEmpty()) {
                messageBuilder.append("\n\t").append(project.getName()).append(": ").append(snapshotDependencies);
            }
        };
    }

    private void warnOrThrow(boolean doThrow, String message) {
        if (doThrow) {
            throw new GradleException(message);
        }
        this.getProject().getLogger().warn(message);
    }
}

