/*
 * Decompiled with CFR 0.152.
 */
package de.exlll.configlib;

import de.exlll.configlib.CommentNodeExtractor;
import de.exlll.configlib.ConfigurationException;
import de.exlll.configlib.ConfigurationProperties;
import de.exlll.configlib.FileConfigurationStore;
import de.exlll.configlib.IOStreamConfigurationStore;
import de.exlll.configlib.TypeSerializer;
import de.exlll.configlib.Validator;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Queue;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.representer.BaseRepresenter;
import org.snakeyaml.engine.v2.representer.StandardRepresenter;

public final class YamlConfigurationStore<T>
implements FileConfigurationStore<T>,
IOStreamConfigurationStore<T> {
    private static final Dump YAML_DUMPER = YamlConfigurationStore.newYamlDumper();
    private static final Load YAML_LOADER = YamlConfigurationStore.newYamlLoader();
    private final YamlConfigurationProperties properties;
    private final TypeSerializer<T, ?> serializer;
    private final CommentNodeExtractor extractor;

    public YamlConfigurationStore(Class<T> configurationType, YamlConfigurationProperties properties) {
        Validator.requireNonNull(configurationType, (String)"configuration type");
        this.properties = (YamlConfigurationProperties)((Object)Validator.requireNonNull((Object)((Object)properties), (String)"properties"));
        this.serializer = TypeSerializer.newSerializerFor(configurationType, (ConfigurationProperties)properties);
        this.extractor = new CommentNodeExtractor((ConfigurationProperties)properties);
    }

    public void write(T configuration, OutputStream outputStream) {
        Validator.requireNonNull(configuration, (String)"configuration");
        Validator.requireNonNull((Object)outputStream, (String)"output stream");
        Queue extractedCommentNodes = this.extractor.extractCommentNodes(configuration);
        YamlWriter yamlFileWriter = new YamlWriter(outputStream, this.properties);
        String dumpedYaml = this.tryDump(configuration);
        yamlFileWriter.writeYaml(dumpedYaml, extractedCommentNodes);
    }

    public void save(T configuration, Path configurationFile) {
        Validator.requireNonNull(configuration, (String)"configuration");
        Validator.requireNonNull((Object)configurationFile, (String)"configuration file");
        this.tryCreateParentDirectories(configurationFile);
        Queue extractedCommentNodes = this.extractor.extractCommentNodes(configuration);
        YamlWriter yamlFileWriter = new YamlWriter(configurationFile, this.properties);
        String dumpedYaml = this.tryDump(configuration);
        yamlFileWriter.writeYaml(dumpedYaml, extractedCommentNodes);
    }

    private void tryCreateParentDirectories(Path configurationFile) {
        Path parent = configurationFile.getParent();
        if (!Files.exists(parent, new LinkOption[0]) && this.properties.createParentDirectories()) {
            try {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String tryDump(T configuration) {
        Map serializedConfiguration = this.serializer.serialize(configuration);
        try {
            return YAML_DUMPER.dumpToString((Object)serializedConfiguration);
        }
        catch (YamlEngineException e) {
            String msg = "The given configuration could not be converted into YAML. \nDo all custom serializers produce valid target types?";
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    public T read(InputStream inputStream) {
        Validator.requireNonNull((Object)inputStream, (String)"input stream");
        try {
            Object yaml = YAML_LOADER.loadFromInputStream(inputStream);
            Map<?, ?> conf = this.requireYamlMapForRead(yaml);
            return (T)this.serializer.deserialize(conf);
        }
        catch (YamlEngineException e) {
            String msg = "The input stream does not contain valid YAML.";
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    private Map<?, ?> requireYamlMapForRead(Object yaml) {
        if (yaml == null) {
            String msg = "The input stream is empty or only contains null.";
            throw new ConfigurationException(msg);
        }
        if (!(yaml instanceof Map)) {
            String msg = "The contents of the input stream do not represent a configuration. A valid configuration contains a YAML map but instead a '" + yaml.getClass() + "' was found.";
            throw new ConfigurationException(msg);
        }
        Map map = (Map)yaml;
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T load(Path configurationFile) {
        Validator.requireNonNull((Object)configurationFile, (String)"configuration file");
        try (BufferedReader reader = Files.newBufferedReader(configurationFile, this.properties.getCharset());){
            Object yaml2 = YAML_LOADER.loadFromReader((Reader)reader);
            Map<?, ?> conf = this.requireYamlMapForLoad(yaml2, configurationFile);
            Object object = this.serializer.deserialize(conf);
            return (T)object;
        }
        catch (YamlEngineException e) {
            String msg = "The configuration file at %s does not contain valid YAML.";
            throw new ConfigurationException(msg.formatted(configurationFile), (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<?, ?> requireYamlMapForLoad(Object yaml, Path configurationFile) {
        if (yaml == null) {
            String msg = "The configuration file at %s is empty or only contains null.";
            throw new ConfigurationException(msg.formatted(configurationFile));
        }
        if (!(yaml instanceof Map)) {
            String msg = "The contents of the YAML file at %s do not represent a configuration. A valid configuration file contains a YAML map but instead a '" + yaml.getClass() + "' was found.";
            throw new ConfigurationException(msg.formatted(configurationFile));
        }
        Map map = (Map)yaml;
        return map;
    }

    public T update(Path configurationFile) {
        Validator.requireNonNull((Object)configurationFile, (String)"configuration file");
        if (Files.exists(configurationFile, new LinkOption[0])) {
            T configuration = this.load(configurationFile);
            this.save(configuration, configurationFile);
            return configuration;
        }
        Object defaultConfiguration = this.serializer.newDefaultInstance();
        this.save(defaultConfiguration, configurationFile);
        return (T)defaultConfiguration;
    }

    static Dump newYamlDumper() {
        DumpSettings settings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setIndent(2).build();
        return new Dump(settings, (BaseRepresenter)new YamlConfigurationRepresenter(settings));
    }

    static Load newYamlLoader() {
        LoadSettings settings = LoadSettings.builder().build();
        return new Load(settings);
    }

    static final class YamlConfigurationRepresenter
    extends StandardRepresenter {
        public YamlConfigurationRepresenter(DumpSettings settings) {
            super(settings);
        }

        protected Node representSequence(Tag tag, Iterable<?> sequence, FlowStyle flowStyle) {
            Node node = super.representSequence(tag, sequence, flowStyle);
            this.representedObjects.clear();
            return node;
        }

        protected Node representMapping(Tag tag, Map<?, ?> mapping, FlowStyle flowStyle) {
            Node node = super.representMapping(tag, mapping, flowStyle);
            this.representedObjects.clear();
            return node;
        }
    }
}

