/*
 * Decompiled with CFR 0.152.
 */
package de.extra.client.plugins.outputplugin.ws;

import de.drv.dsrv.extra.marshaller.IExtraUnmarschaller;
import de.extra.client.core.annotation.PluginConfigType;
import de.extra.client.core.annotation.PluginConfiguration;
import de.extra.client.core.annotation.PluginValue;
import de.extrastandard.api.exception.ExceptionCode;
import de.extrastandard.api.exception.ExtraCoreRuntimeException;
import de.extrastandard.api.exception.ExtraOutputPluginRuntimeException;
import de.extrastandard.api.plugin.IOutputPlugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;
import org.springframework.xml.transform.StringResult;

@Named(value="wsOutputPlugin")
@PluginConfiguration(pluginBeanName="wsOutputPlugin", pluginType=PluginConfigType.OutputPlugins)
public class WsOutputPlugin
implements IOutputPlugin {
    private static final Logger logger = LoggerFactory.getLogger(WsOutputPlugin.class);
    private static final Logger operation_logger = LoggerFactory.getLogger((String)"de.extra.client.operation");
    @Inject
    @Named(value="webServiceTemplate")
    private WebServiceTemplate webServiceTemplate;
    @PluginValue(key="endpoint.url")
    private String endpointUrl;
    @Inject
    @Named(value="eXTraNoValidationjaxb2Marshaller")
    private Jaxb2Marshaller noValidationJaxb2Marshaller;
    @Inject
    @Named(value="extraUnmarschaller")
    private IExtraUnmarschaller extraUnmarschaller;

    public InputStream outputData(InputStream requestAsStream) {
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        logger.debug("sending request");
        operation_logger.info("Webservice Aufruf von: {}", (Object)this.endpointUrl);
        StreamSource source = new StreamSource(requestAsStream);
        StreamResult result = new StreamResult(temp);
        try {
            this.webServiceTemplate.sendSourceAndReceiveToResult(this.endpointUrl, (Source)source, (Result)result);
        }
        catch (SoapFaultClientException soapFaultClientException) {
            operation_logger.error("Server meldet SOAP-Fehler: {}", (Object)soapFaultClientException.getFaultStringOrReason());
            ExtraOutputPluginRuntimeException extraOutputPluginRuntimeException = this.extractSoapFaultClientException(soapFaultClientException);
            throw extraOutputPluginRuntimeException;
        }
        return new ByteArrayInputStream(temp.toByteArray());
    }

    private ExtraOutputPluginRuntimeException extractSoapFaultClientException(SoapFaultClientException soapFaultClientException) {
        try {
            StringBuilder message = new StringBuilder();
            StringResult resultFault = new StringResult();
            TransformerFactory.newInstance().newTransformer().transform(soapFaultClientException.getSoapFault().getSource(), (Result)resultFault);
            String resultFaultAsString = resultFault.toString();
            message.append(resultFaultAsString);
            return new ExtraOutputPluginRuntimeException(ExceptionCode.EXTRA_TRANSFER_EXCEPTION, message.toString());
        }
        catch (Exception e) {
            operation_logger.error("Schwerwiegender Fehler beim Extrahieren des SOAP-Fehlers!", (Object)e.getMessage());
            throw new ExtraCoreRuntimeException(ExceptionCode.UNEXPECTED_INTERNAL_EXCEPTION, "Schwerwiegender Fehler beim Extrahieren des SOAP-Fehlers!" + e.getMessage());
        }
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }
}

