/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.webidl.generator.jni.java;

import de.fabmax.webidl.generator.CodeGenerator;
import de.fabmax.webidl.generator.CodeGeneratorKt;
import de.fabmax.webidl.generator.jni.java.JavaClass;
import de.fabmax.webidl.generator.jni.java.JavaType;
import de.fabmax.webidl.generator.jni.java.JniJavaGenerator;
import de.fabmax.webidl.model.IdlAttribute;
import de.fabmax.webidl.model.IdlDecorator;
import de.fabmax.webidl.model.IdlEnum;
import de.fabmax.webidl.model.IdlFunction;
import de.fabmax.webidl.model.IdlFunctionParameter;
import de.fabmax.webidl.model.IdlInterface;
import de.fabmax.webidl.model.IdlModel;
import de.fabmax.webidl.model.IdlType;
import java.io.Closeable;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 O2\u00020\u0001:\u0001OB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020'H\u0002J\u0018\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020,H\u0002J,\u00101\u001a\u00020'2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005032\u0006\u00104\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u00105\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u00106\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J \u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020#2\u000e\b\u0002\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\u0014\u0010&\u001a\u00020'*\u00020<2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0014\u0010&\u001a\u00020'*\u00020>2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u0014\u0010?\u001a\u00020'*\u00020>2\u0006\u0010=\u001a\u00020\u0012H\u0002J\u001c\u0010@\u001a\u00020'*\u00020>2\u0006\u0010A\u001a\u00020B2\u0006\u0010+\u001a\u00020,H\u0002J\u001c\u0010C\u001a\u00020'*\u00020>2\u0006\u0010D\u001a\u00020B2\u0006\u0010+\u001a\u00020,H\u0002J\u0014\u0010E\u001a\u00020'*\u00020)2\u0006\u0010F\u001a\u00020\u0005H\u0002J\u001c\u0010G\u001a\u00020'*\u00020>2\u0006\u0010A\u001a\u00020B2\u0006\u0010+\u001a\u00020,H\u0002J\u001c\u0010H\u001a\u00020'*\u00020>2\u0006\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020,H\u0002J\f\u0010I\u001a\u00020\t*\u00020>H\u0002J\f\u0010J\u001a\u00020\t*\u00020>H\u0002J\u0014\u0010K\u001a\u00020\t*\u0002002\u0006\u0010L\u001a\u00020>H\u0002J\u001c\u0010K\u001a\u00020\t*\u00020M2\u0006\u0010L\u001a\u00020>2\u0006\u0010N\u001a\u00020BH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R#\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00160\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lde/fabmax/webidl/generator/jni/java/JniJavaGenerator;", "Lde/fabmax/webidl/generator/CodeGenerator;", "()V", "externallyAllocatableClasses", "", "", "getExternallyAllocatableClasses", "()Ljava/util/Set;", "generateInterfaceStackAllocators", "", "getGenerateInterfaceStackAllocators", "()Z", "setGenerateInterfaceStackAllocators", "(Z)V", "generateSimpleStackAllocators", "getGenerateSimpleStackAllocators", "setGenerateSimpleStackAllocators", "nativeObject", "Lde/fabmax/webidl/generator/jni/java/JavaClass;", "nullableAttributes", "getNullableAttributes", "nullableParameters", "Lkotlin/Pair;", "getNullableParameters", "onClassLoad", "getOnClassLoad", "()Ljava/lang/String;", "setOnClassLoad", "(Ljava/lang/String;)V", "packagePrefix", "getPackagePrefix", "setPackagePrefix", "typeMap", "", "JavaType", "Lde/fabmax/webidl/generator/jni/java/JavaType;", "idlType", "Lde/fabmax/webidl/model/IdlType;", "generate", "", "model", "Lde/fabmax/webidl/model/IdlModel;", "generateDestructor", "w", "Ljava/io/Writer;", "generateFrameworkClasses", "generateGet", "attrib", "Lde/fabmax/webidl/model/IdlAttribute;", "generateJavadoc", "paramDocs", "", "returnDoc", "generateSizeOf", "makeClassMappings", "makeTypeDoc", "javaType", "decorators", "", "Lde/fabmax/webidl/model/IdlDecorator;", "Lde/fabmax/webidl/model/IdlEnum;", "javaClass", "Lde/fabmax/webidl/model/IdlInterface;", "generateCallback", "generateConstructor", "ctorFunc", "Lde/fabmax/webidl/model/IdlFunction;", "generateFunction", "func", "generatePackage", "idlPkg", "generatePlacedConstructor", "generateSet", "hasDefaultConstructor", "isCallback", "isNullable", "idlIf", "Lde/fabmax/webidl/model/IdlFunctionParameter;", "idlFunc", "Companion", "webidl-util"})
public final class JniJavaGenerator
extends CodeGenerator {
    @NotNull
    private String packagePrefix = "";
    @NotNull
    private final Set<String> externallyAllocatableClasses;
    private boolean generateSimpleStackAllocators;
    private boolean generateInterfaceStackAllocators;
    @NotNull
    private final Set<String> nullableAttributes;
    @NotNull
    private final Set<Pair<String, String>> nullableParameters;
    @NotNull
    private String onClassLoad;
    private JavaClass nativeObject;
    private final Map<String, JavaClass> typeMap;
    @NotNull
    public static final String NATIVE_OBJECT_NAME = "NativeObject";
    @NotNull
    private static final Map<String, String> idlPrimitiveTypeMap;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getPackagePrefix() {
        return this.packagePrefix;
    }

    public final void setPackagePrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.packagePrefix = string;
    }

    @NotNull
    public final Set<String> getExternallyAllocatableClasses() {
        return this.externallyAllocatableClasses;
    }

    public final boolean getGenerateSimpleStackAllocators() {
        return this.generateSimpleStackAllocators;
    }

    public final void setGenerateSimpleStackAllocators(boolean bl) {
        this.generateSimpleStackAllocators = bl;
    }

    public final boolean getGenerateInterfaceStackAllocators() {
        return this.generateInterfaceStackAllocators;
    }

    public final void setGenerateInterfaceStackAllocators(boolean bl) {
        this.generateInterfaceStackAllocators = bl;
    }

    @NotNull
    public final Set<String> getNullableAttributes() {
        return this.nullableAttributes;
    }

    @NotNull
    public final Set<Pair<String, String>> getNullableParameters() {
        return this.nullableParameters;
    }

    @NotNull
    public final String getOnClassLoad() {
        return this.onClassLoad;
    }

    public final void setOnClassLoad(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.onClassLoad = string;
    }

    @Override
    public void generate(@NotNull IdlModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.deleteDirectory(new File(this.getOutputDirectory()));
        this.generateFrameworkClasses();
        this.makeClassMappings(model);
        Iterator iterator = model.collectPackages().iterator();
        while (iterator.hasNext()) {
            String pkg;
            String string = pkg = (String)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pkg");
            this.generatePackage(model, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void generateFrameworkClasses() {
        void $this$apply;
        JavaClass javaClass = new JavaClass(NATIVE_OBJECT_NAME, false, "", this.packagePrefix);
        boolean bl = false;
        boolean bl2 = false;
        JavaClass javaClass2 = javaClass;
        JniJavaGenerator jniJavaGenerator = this;
        boolean bl3 = false;
        $this$apply.setProtectedDefaultContructor(true);
        $this$apply.setGeneratePointerWrapMethods(false);
        $this$apply.setStaticCode(this.onClassLoad);
        Unit unit = Unit.INSTANCE;
        jniJavaGenerator.nativeObject = javaClass;
        JavaClass javaClass3 = this.nativeObject;
        if (javaClass3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
        }
        JavaClass javaClass4 = this.nativeObject;
        if (javaClass4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
        }
        javaClass3.generateSource(this.createOutFileWriter(javaClass4.getFileName()), (Function1<? super Writer, Unit>)((Function1)generateFrameworkClasses.2.INSTANCE));
        JavaClass javaClass5 = new JavaClass("JniThreadManager", false, "", this.packagePrefix);
        bl2 = false;
        boolean bl4 = false;
        JavaClass $this$apply2 = javaClass5;
        boolean bl5 = false;
        $this$apply2.setProtectedDefaultContructor(false);
        $this$apply2.setGeneratePointerWrapMethods(false);
        $this$apply2.setStaticCode(this.onClassLoad);
        Collection collection = $this$apply2.getImportFqns();
        String string = "java.util.concurrent.atomic.AtomicBoolean";
        boolean bl6 = false;
        collection.add(string);
        JavaClass jniThreadManager = javaClass5;
        jniThreadManager.generateSource(this.createOutFileWriter(jniThreadManager.getFileName()), (Function1<? super Writer, Unit>)((Function1)generateFrameworkClasses.3.INSTANCE));
        Object object = new JavaClass("JavaNativeRef", false, "", this.packagePrefix);
        bl4 = false;
        boolean bl7 = false;
        JavaClass $this$apply3 = object;
        boolean bl8 = false;
        $this$apply3.setProtectedDefaultContructor(false);
        $this$apply3.setGeneratePointerWrapMethods(false);
        $this$apply3.setStaticCode(this.onClassLoad);
        JavaClass javaClass6 = this.nativeObject;
        if (javaClass6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
        }
        $this$apply3.setSuperClass(javaClass6);
        JavaClass javaNativeRef = object;
        object = this.createOutFileWriter(javaNativeRef.getFileName());
        bl4 = false;
        bl7 = false;
        Throwable throwable = null;
        try {
            Writer w = (Writer)object;
            boolean bl9 = false;
            javaNativeRef.generatePackage(w);
            javaNativeRef.generateImports(w);
            Writer writer = w.append(StringsKt.trimIndent((String)("\n            public class JavaNativeRef<T> extends NativeObject {\n                \n                static {\n                    " + javaNativeRef.getStaticCode() + "\n                }\n                \n                private static native long _new_instance(Object javaRef);\n                private static native void _delete_instance(long address);\n                private static native Object _get_java_ref(long address);\n\n                public static <T> JavaNativeRef<T> fromNativeObject(NativeObject nativeObj) {\n                    return new JavaNativeRef<T>(nativeObj != null ? nativeObj.address : 0L);\n                }\n\n                protected JavaNativeRef(long address) {\n                    super(address);\n                }\n\n                public JavaNativeRef(Object javaRef) {\n                    address = _new_instance(javaRef);\n                }\n                \n                public T get() {\n                    checkNotNull();\n                    return (T) _get_java_ref(address);\n                }\n                \n                public void destroy() {\n                    checkNotNull();\n                    _delete_instance(address);\n                }\n            }\n            ")));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void makeClassMappings(IdlModel model) {
        this.typeMap.clear();
        JavaClass javaClass = this.nativeObject;
        if (javaClass == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
        }
        String string = javaClass.getName();
        JavaClass javaClass2 = this.nativeObject;
        if (javaClass2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
        }
        this.typeMap.put(string, javaClass2);
        Iterator<Object> iterator = model.collectPackages().iterator();
        while (iterator.hasNext()) {
            Unit unit;
            JavaClass $this$apply;
            Map<String, JavaClass> map;
            String string2;
            boolean bl;
            boolean bl2;
            JavaClass javaClass3;
            String idlPkg;
            String string3 = idlPkg = (String)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"idlPkg");
            for (IdlInterface idlIf : model.getInterfacesByPackage(string3)) {
                javaClass3 = new JavaClass(idlIf.getName(), false, idlPkg, this.packagePrefix);
                bl2 = false;
                bl = false;
                JavaClass javaClass4 = javaClass3;
                string2 = idlIf.getName();
                map = this.typeMap;
                boolean bl3 = false;
                $this$apply.setProtectedDefaultContructor(!this.hasDefaultConstructor(idlIf) && !this.isCallback(idlIf));
                $this$apply.setGeneratePointerWrapMethods(true);
                unit = Unit.INSTANCE;
                map.put(string2, javaClass3);
            }
            for (IdlEnum idlEn : model.getEnumsByPackage(idlPkg)) {
                javaClass3 = new JavaClass(idlEn.getName(), true, idlPkg, this.packagePrefix);
                bl2 = false;
                bl = false;
                $this$apply = javaClass3;
                string2 = idlEn.getName();
                map = this.typeMap;
                boolean bl4 = false;
                $this$apply.setProtectedDefaultContructor(false);
                $this$apply.setGeneratePointerWrapMethods(false);
                $this$apply.setStaticCode(this.onClassLoad);
                unit = Unit.INSTANCE;
                map.put(string2, javaClass3);
            }
        }
        for (IdlInterface idlIf : model.getInterfaces()) {
            JavaClass javaClass5;
            Iterable $this$forEach$iv;
            Collection collection;
            boolean bl = false;
            Set imports = new LinkedHashSet();
            Iterable $this$forEach$iv2 = idlIf.getSuperInterfaces();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl5 = false;
                collection = imports;
                boolean bl6 = false;
                collection.add(it);
            }
            if (idlIf.getSuperInterfaces().isEmpty() && !this.isCallback(idlIf)) {
                $this$forEach$iv2 = imports;
                JavaClass javaClass6 = this.nativeObject;
                if (javaClass6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
                }
                String $i$f$forEach2 = javaClass6.getName();
                boolean bl7 = false;
                $this$forEach$iv2.add($i$f$forEach2);
            }
            $this$forEach$iv2 = idlIf.getFunctions();
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                IdlFunction func = (IdlFunction)element$iv;
                boolean bl8 = false;
                if (func.getReturnType().isComplexType()) {
                    collection = imports;
                    String string4 = func.getReturnType().getTypeName();
                    boolean bl9 = false;
                    collection.add(string4);
                } else if (func.getReturnType().isAnyOrVoidPtr()) {
                    collection = imports;
                    JavaClass javaClass7 = this.nativeObject;
                    if (javaClass7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
                    }
                    String string5 = javaClass7.getName();
                    boolean bl10 = false;
                    collection.add(string5);
                }
                $this$forEach$iv = func.getParameters();
                boolean $i$f$forEach4 = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    boolean bl11;
                    String string6;
                    Collection collection2;
                    IdlFunctionParameter param = (IdlFunctionParameter)element$iv2;
                    boolean bl12 = false;
                    if (param.getType().isComplexType()) {
                        collection2 = imports;
                        string6 = param.getType().getTypeName();
                        bl11 = false;
                        collection2.add(string6);
                        continue;
                    }
                    if (!param.getType().isAnyOrVoidPtr()) continue;
                    collection2 = imports;
                    JavaClass javaClass8 = this.nativeObject;
                    if (javaClass8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
                    }
                    string6 = javaClass8.getName();
                    bl11 = false;
                    collection2.add(string6);
                }
            }
            $this$forEach$iv2 = idlIf.getAttributes();
            $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                boolean bl13;
                String string7;
                IdlAttribute attrib = (IdlAttribute)element$iv;
                boolean bl14 = false;
                if (attrib.getType().isComplexType()) {
                    $this$forEach$iv = imports;
                    string7 = attrib.getType().getTypeName();
                    bl13 = false;
                    $this$forEach$iv.add(string7);
                    continue;
                }
                if (!attrib.getType().isAnyOrVoidPtr()) continue;
                $this$forEach$iv = imports;
                JavaClass javaClass9 = this.nativeObject;
                if (javaClass9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
                }
                string7 = javaClass9.getName();
                bl13 = false;
                $this$forEach$iv.add(string7);
            }
            if (this.typeMap.get(idlIf.getName()) == null) {
                throw (Throwable)new IllegalStateException("Unknown idl type: " + idlIf.getName());
            }
            if (this.isCallback(idlIf)) {
                String superType = idlIf.getDecoratorValue("JSImplementation", "");
                JavaClass javaClass10 = this.typeMap.get(superType);
                if (javaClass10 == null) {
                    throw (Throwable)new IllegalStateException("Unknown JSImplementation type: " + superType);
                }
                javaClass5.setSuperClass(javaClass10);
                Collection collection3 = idlIf.getSuperInterfaces();
                boolean bl15 = false;
                if (!collection3.isEmpty()) {
                    System.err.println("warning: " + idlIf.getName() + " is callback implementation of " + superType + " and additionally implements " + idlIf.getSuperInterfaces());
                    System.err.println("warning: multiple super interfaces are not supported!");
                }
            } else if (idlIf.getSuperInterfaces().isEmpty()) {
                JavaClass javaClass11 = this.nativeObject;
                if (javaClass11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nativeObject");
                }
                javaClass5.setSuperClass(javaClass11);
            } else {
                if (idlIf.getSuperInterfaces().size() > 1) {
                    System.err.println("warning: " + idlIf.getName() + " implements " + idlIf.getSuperInterfaces());
                    System.err.println("warning: multiple super interfaces are not supported!");
                }
                JavaClass javaClass12 = this.typeMap.get(idlIf.getSuperInterfaces().get(0));
                if (javaClass12 == null) {
                    throw (Throwable)new IllegalStateException("Unknown idl type: " + idlIf.getSuperInterfaces().get(0));
                }
                javaClass5.setSuperClass(javaClass12);
            }
            Iterable $this$forEach$iv3 = imports;
            boolean $i$f$forEach5 = false;
            for (Object element$iv : $this$forEach$iv3) {
                JavaClass javaClass13;
                String it = (String)element$iv;
                boolean bl16 = false;
                Collection collection4 = javaClass5.getImports();
                if (this.typeMap.get(it) == null) {
                    throw (Throwable)new IllegalStateException("Unknown idl type: " + it);
                }
                boolean bl17 = false;
                collection4.add(javaClass13);
            }
        }
    }

    private final boolean isCallback(IdlInterface $this$isCallback) {
        return $this$isCallback.hasDecorator("JSImplementation");
    }

    private final boolean hasDefaultConstructor(IdlInterface $this$hasDefaultConstructor) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasDefaultConstructor.getFunctions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IdlFunction it = (IdlFunction)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)$this$hasDefaultConstructor.getName()) && it.getParameters().isEmpty())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void generatePackage(IdlModel $this$generatePackage, String idlPkg) {
        JavaClass javaClass;
        Iterable $this$forEach$iv = $this$generatePackage.getInterfacesByPackage(idlPkg);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdlInterface idlIf = (IdlInterface)element$iv;
            boolean bl = false;
            if (this.typeMap.get(idlIf.getName()) == null) {
                throw (Throwable)new IllegalStateException("Unknown idl type: " + $this$generatePackage.getName());
            }
            if (this.isCallback(idlIf)) {
                this.generateCallback(idlIf, javaClass);
                continue;
            }
            this.generate(idlIf, javaClass);
        }
        $this$forEach$iv = $this$generatePackage.getEnumsByPackage(idlPkg);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdlEnum idlEn = (IdlEnum)element$iv;
            boolean bl = false;
            if (this.typeMap.get(idlEn.getName()) == null) {
                throw (Throwable)new IllegalStateException("Unknown idl type: " + $this$generatePackage.getName());
            }
            this.generate(idlEn, javaClass);
        }
    }

    private final void generateCallback(IdlInterface $this$generateCallback, JavaClass javaClass) {
        String string = javaClass.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.path");
        javaClass.generateSource(this.createOutFileWriter(string), (Function1<? super Writer, Unit>)((Function1)new Function1<Writer, Unit>(this, $this$generateCallback, javaClass){
            final /* synthetic */ JniJavaGenerator this$0;
            final /* synthetic */ IdlInterface $this_generateCallback;
            final /* synthetic */ JavaClass $javaClass;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Writer $this$generateSource) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$generateSource, (String)"$receiver");
                $this$generateSource.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n            protected " + this.$javaClass.getName() + "() {\n                address = _" + this.$javaClass.getName() + "();\n            }\n            private native long _" + this.$javaClass.getName() + "();\n            \n            // Destructor\n        ")), 4)).append("\n\n");
                JniJavaGenerator.access$generateDestructor(this.this$0, $this$generateSource);
                Iterable $this$filter$iv = this.$this_generateCallback.getFunctions();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IdlFunction it = (IdlFunction)element$iv$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)this.$this_generateCallback.getName()) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List nonCtorFunctions = (List)destination$iv$iv;
                $this$filter$iv = nonCtorFunctions;
                $i$f$filter = false;
                if (!$this$filter$iv.isEmpty()) {
                    $this$generateSource.append("    // Functions\n\n");
                    Iterable $this$forEach$iv = nonCtorFunctions;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        String string;
                        Collection<JavaType> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Object element$iv$iv;
                        IdlFunction func = (IdlFunction)element$iv;
                        boolean bl = false;
                        element$iv$iv = func.getParameters();
                        Iterable iterable2 = func.getParameters();
                        boolean $i$f$map = false;
                        void var12_16 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl2 = false;
                            JavaType javaType = JniJavaGenerator.access$JavaType(this.this$0, it.getType());
                            collection.add(javaType);
                        }
                        collection = (List)destination$iv$iv2;
                        List nativeToJavaParams = CollectionsKt.zip((Iterable)iterable2, (Iterable)collection);
                        JavaType returnType = JniJavaGenerator.access$JavaType(this.this$0, func.getReturnType());
                        String returnPrefix = func.getReturnType().isVoid() ? "" : "return ";
                        String returnSuffix = func.getReturnType().isComplexType() || func.getReturnType().isAnyOrVoidPtr() ? ".getAddress()" : "";
                        String internalParams2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)generateCallback.1.internalParams.1.INSTANCE, (int)31, null);
                        String params2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)generateCallback.1.params.1.INSTANCE, (int)31, null);
                        String callParams2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)generateCallback.1.callParams.1.INSTANCE, (int)31, null);
                        if (func.getReturnType().isVoid()) {
                            string = " ";
                        } else if (func.getReturnType().isPrimitive()) {
                            String string2;
                            switch (func.getReturnType().getTypeName()) {
                                case "boolean": {
                                    string2 = "false";
                                    break;
                                }
                                case "float": {
                                    string2 = "0.0f";
                                    break;
                                }
                                case "double": {
                                    string2 = "0.0";
                                    break;
                                }
                                case "DOMString": {
                                    string2 = "\"\"";
                                    break;
                                }
                                default: {
                                    string2 = "0";
                                }
                            }
                            String returnVal = string2;
                            string = '\n' + CodeGeneratorKt.indent(24) + "return " + returnVal + ";\n" + CodeGeneratorKt.indent(20);
                        } else {
                            string = '\n' + CodeGeneratorKt.indent(24) + "return null;\n" + CodeGeneratorKt.indent(20);
                        }
                        String defaultReturnVal = string;
                        boolean bl2 = false;
                        Map paramDocs = new LinkedHashMap<K, V>();
                        Iterable $this$forEach$iv2 = nativeToJavaParams;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            void nat;
                            Pair $dstr$nat$java = (Pair)element$iv2;
                            boolean bl3 = false;
                            IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)$dstr$nat$java.component1();
                            JavaType java = (JavaType)$dstr$nat$java.component2();
                            paramDocs.put(nat.getName(), JniJavaGenerator.access$makeTypeDoc(this.this$0, java, nat.getDecorators()));
                        }
                        String returnDoc = returnType.getIdlType().isVoid() ? "" : JniJavaGenerator.access$makeTypeDoc(this.this$0, returnType, func.getDecorators());
                        $this$generateSource.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n                    /*\n                     * Called from native code\n                     */\n                    private " + returnType.getInternalType() + " _" + func.getName() + '(' + internalParams2 + ") {\n                        " + returnPrefix + func.getName() + '(' + callParams2 + ')' + returnSuffix + ";\n                    }")), 4)).append("\n\n");
                        JniJavaGenerator.access$generateJavadoc(this.this$0, paramDocs, returnDoc, $this$generateSource);
                        $this$generateSource.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n                    public " + returnType.getJavaType() + ' ' + func.getName() + '(' + params2 + ") {" + defaultReturnVal + "}\n                ")), 4)).append("\n\n");
                    }
                }
            }
            {
                this.this$0 = jniJavaGenerator;
                this.$this_generateCallback = idlInterface;
                this.$javaClass = javaClass;
                super(1);
            }
        }));
    }

    private final void generate(IdlInterface $this$generate, JavaClass javaClass) {
        String string = javaClass.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.path");
        javaClass.generateSource(this.createOutFileWriter(string), (Function1<? super Writer, Unit>)((Function1)new Function1<Writer, Unit>(this, $this$generate){
            final /* synthetic */ JniJavaGenerator this$0;
            final /* synthetic */ IdlInterface $this_generate;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Writer $this$generateSource) {
                void $this$filterTo$iv$iv;
                Object element$iv2;
                boolean $i$f$forEach;
                Iterable<E> $this$forEach$iv;
                Iterator<E> $this$filterTo$iv$iv2;
                Intrinsics.checkNotNullParameter((Object)$this$generateSource, (String)"$receiver");
                Iterable $this$filter$iv = this.$this_generate.getFunctions();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                Iterator<T> iterator = $this$filterTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    T element$iv$iv = iterator.next();
                    IdlFunction it = (IdlFunction)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.$this_generate.getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List ctorFunctions = (List)destination$iv$iv;
                if (this.this$0.getExternallyAllocatableClasses().contains(this.$this_generate.getName())) {
                    JniJavaGenerator.access$generateSizeOf(this.this$0, $this$generateSource);
                    $this$generateSource.append("    // Placed Constructors\n\n");
                    $this$forEach$iv = ctorFunctions;
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        IdlFunction ctor = (IdlFunction)element$iv2;
                        boolean bl = false;
                        JniJavaGenerator.access$generatePlacedConstructor(this.this$0, this.$this_generate, ctor, $this$generateSource);
                    }
                }
                $this$forEach$iv = ctorFunctions;
                $i$f$forEach = false;
                if (!$this$forEach$iv.isEmpty()) {
                    $this$generateSource.append("    // Constructors\n\n");
                    $this$forEach$iv = ctorFunctions;
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        IdlFunction ctor = (IdlFunction)element$iv2;
                        boolean bl = false;
                        JniJavaGenerator.access$generateConstructor(this.this$0, this.$this_generate, ctor, $this$generateSource);
                    }
                }
                if (!this.$this_generate.hasDecorator("NoDelete")) {
                    $this$generateSource.append("    // Destructor\n\n");
                    JniJavaGenerator.access$generateDestructor(this.this$0, $this$generateSource);
                }
                $this$forEach$iv = this.$this_generate.getAttributes();
                $i$f$forEach = false;
                if (!$this$forEach$iv.isEmpty()) {
                    $this$generateSource.append("    // Attributes\n\n");
                    $this$forEach$iv = this.$this_generate.getAttributes();
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        IdlAttribute attrib = (IdlAttribute)element$iv2;
                        boolean bl = false;
                        JniJavaGenerator.access$generateGet(this.this$0, attrib, $this$generateSource);
                        if (attrib.isReadonly()) continue;
                        JniJavaGenerator.access$generateSet(this.this$0, this.$this_generate, attrib, $this$generateSource);
                    }
                }
                Iterable $this$filter$iv2 = this.$this_generate.getFunctions();
                boolean $i$f$filter2 = false;
                element$iv2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo2 = false;
                for (E element$iv$iv : $this$filterTo$iv$iv) {
                    IdlFunction it = (IdlFunction)element$iv$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)this.$this_generate.getName()) ^ true)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List nonCtorFunctions = (List)destination$iv$iv2;
                $this$filter$iv2 = nonCtorFunctions;
                $i$f$filter2 = false;
                if (!$this$filter$iv2.isEmpty()) {
                    $this$generateSource.append("    // Functions\n\n");
                    Iterable $this$forEach$iv2 = nonCtorFunctions;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv3 : $this$forEach$iv2) {
                        IdlFunction func = (IdlFunction)element$iv3;
                        boolean bl = false;
                        JniJavaGenerator.access$generateFunction(this.this$0, this.$this_generate, func, $this$generateSource);
                    }
                }
            }
            {
                this.this$0 = jniJavaGenerator;
                this.$this_generate = idlInterface;
                super(1);
            }
        }));
    }

    private final boolean isNullable(IdlFunctionParameter $this$isNullable, IdlInterface idlIf, IdlFunction idlFunc) {
        return this.nullableParameters.contains(TuplesKt.to((Object)(idlIf.getName() + '.' + idlFunc.getName()), (Object)$this$isNullable.getName()));
    }

    private final boolean isNullable(IdlAttribute $this$isNullable, IdlInterface idlIf) {
        return this.nullableAttributes.contains(idlIf.getName() + '.' + $this$isNullable.getName());
    }

    private final void generateSizeOf(Writer w) {
        w.append(CodeGeneratorKt.prependIndent("private static native int __sizeOf();\npublic static final int SIZEOF = __sizeOf();\npublic static final int ALIGNOF = 8;", 4)).append("\n\n");
    }

    /*
     * WARNING - void declaration
     */
    private final void generatePlacedConstructor(IdlInterface $this$generatePlacedConstructor, IdlFunction ctorFunc, Writer w) {
        Map pDocs;
        Collection<JavaType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = ctorFunc.getParameters();
        Iterable iterable2 = ctorFunc.getParameters();
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JavaType javaType = this.JavaType(it.getType());
            collection.add(javaType);
        }
        collection = (List)destination$iv$iv;
        List nativeToJavaParams = CollectionsKt.zip((Iterable)iterable2, (Iterable)collection);
        String nativeArgs2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)generatePlacedConstructor.nativeArgs.1.INSTANCE, (int)31, null);
        String javaArgs2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)generatePlacedConstructor.javaArgs.1.INSTANCE, (int)31, null);
        String callArgs2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)((Function1)new Function1<Pair<? extends IdlFunctionParameter, ? extends JavaType>, CharSequence>(this, $this$generatePlacedConstructor, ctorFunc){
            final /* synthetic */ JniJavaGenerator this$0;
            final /* synthetic */ IdlInterface $this_generatePlacedConstructor;
            final /* synthetic */ IdlFunction $ctorFunc;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CharSequence invoke(@NotNull Pair<IdlFunctionParameter, JavaType> $dstr$nat$java) {
                void nat;
                Intrinsics.checkNotNullParameter($dstr$nat$java, (String)"<name for destructuring parameter 0>");
                IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)$dstr$nat$java.component1();
                JavaType java = (JavaType)$dstr$nat$java.component2();
                return java.unbox(nat.getName(), JniJavaGenerator.access$isNullable(this.this$0, (IdlFunctionParameter)nat, this.$this_generatePlacedConstructor, this.$ctorFunc));
            }
            {
                this.this$0 = jniJavaGenerator;
                this.$this_generatePlacedConstructor = idlInterface;
                this.$ctorFunc = idlFunction;
                super(1);
            }
        }), (int)31, null);
        destination$iv$iv = nativeArgs2;
        $i$f$mapTo = false;
        if (destination$iv$iv.length() > 0) {
            nativeArgs2 = ", " + nativeArgs2;
        }
        destination$iv$iv = javaArgs2;
        $i$f$mapTo = false;
        if (destination$iv$iv.length() > 0) {
            javaArgs2 = ", " + javaArgs2;
        }
        destination$iv$iv = callArgs2;
        $i$f$mapTo = false;
        if (destination$iv$iv.length() > 0) {
            callArgs2 = ", " + callArgs2;
        }
        $i$f$mapTo = false;
        Map paramDocs = new LinkedHashMap();
        Iterable $this$forEach$iv = nativeToJavaParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void nat;
            Pair $dstr$nat$java = (Pair)element$iv;
            boolean bl = false;
            IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)$dstr$nat$java.component1();
            JavaType java = (JavaType)$dstr$nat$java.component2();
            paramDocs.put(nat.getName(), this.makeTypeDoc(java, nat.getDecorators()));
        }
        if (this.generateSimpleStackAllocators) {
            pDocs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"address", (Object)"Pre-allocated memory, where the object is created.")});
            pDocs.putAll(paramDocs);
            this.generateJavadoc(pDocs, "Stack allocated object of " + $this$generatePlacedConstructor.getName(), w);
            w.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n                public static " + $this$generatePlacedConstructor.getName() + " createAt(long address" + javaArgs2 + ") {\n                    __placement_new_" + ctorFunc.getName() + "(address" + callArgs2 + ");\n                    " + $this$generatePlacedConstructor.getName() + " createdObj = wrapPointer(address);\n                    createdObj.isExternallyAllocated = true;\n                    return createdObj;\n                }\n            ")), 4)).append("\n\n");
        }
        if (this.generateInterfaceStackAllocators) {
            pDocs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"<T>", (Object)"Allocator class, e.g. LWJGL's MemoryStack."), TuplesKt.to((Object)"allocator", (Object)"Object to use for allocation, e.g. an instance of LWJGL's MemoryStack."), TuplesKt.to((Object)"allocate", (Object)"Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.")});
            pDocs.putAll(paramDocs);
            this.generateJavadoc(pDocs, "Stack allocated object of " + $this$generatePlacedConstructor.getName(), w);
            w.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n                public static <T> " + $this$generatePlacedConstructor.getName() + " createAt(T allocator, Allocator<T> allocate" + javaArgs2 + ") {\n                    long address = allocate.on(allocator, ALIGNOF, SIZEOF); \n                    __placement_new_" + ctorFunc.getName() + "(address" + callArgs2 + ");\n                    " + $this$generatePlacedConstructor.getName() + " createdObj = wrapPointer(address);\n                    createdObj.isExternallyAllocated = true;\n                    return createdObj;\n                }\n            ")), 4)).append("\n\n");
        }
        w.append("    private static native void __placement_new_" + ctorFunc.getName() + "(long address" + nativeArgs2 + ");\n\n");
    }

    /*
     * WARNING - void declaration
     */
    private final void generateConstructor(IdlInterface $this$generateConstructor, IdlFunction ctorFunc, Writer w) {
        Collection<JavaType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = ctorFunc.getParameters();
        Iterable iterable2 = ctorFunc.getParameters();
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JavaType javaType = this.JavaType(it.getType());
            collection.add(javaType);
        }
        collection = (List)destination$iv$iv;
        List nativeToJavaParams = CollectionsKt.zip((Iterable)iterable2, (Iterable)collection);
        String nativeArgs2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)generateConstructor.nativeArgs.1.INSTANCE, (int)31, null);
        String javaArgs2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)generateConstructor.javaArgs.1.INSTANCE, (int)31, null);
        String callArgs2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)((Function1)new Function1<Pair<? extends IdlFunctionParameter, ? extends JavaType>, CharSequence>(this, $this$generateConstructor, ctorFunc){
            final /* synthetic */ JniJavaGenerator this$0;
            final /* synthetic */ IdlInterface $this_generateConstructor;
            final /* synthetic */ IdlFunction $ctorFunc;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CharSequence invoke(@NotNull Pair<IdlFunctionParameter, JavaType> $dstr$nat$java) {
                void nat;
                Intrinsics.checkNotNullParameter($dstr$nat$java, (String)"<name for destructuring parameter 0>");
                IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)$dstr$nat$java.component1();
                JavaType java = (JavaType)$dstr$nat$java.component2();
                return java.unbox(nat.getName(), JniJavaGenerator.access$isNullable(this.this$0, (IdlFunctionParameter)nat, this.$this_generateConstructor, this.$ctorFunc));
            }
            {
                this.this$0 = jniJavaGenerator;
                this.$this_generateConstructor = idlInterface;
                this.$ctorFunc = idlFunction;
                super(1);
            }
        }), (int)31, null);
        $i$f$mapTo = false;
        Map paramDocs = new LinkedHashMap();
        Iterable $this$forEach$iv = nativeToJavaParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void nat;
            Pair $dstr$nat$java = (Pair)element$iv;
            boolean bl = false;
            IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)$dstr$nat$java.component1();
            JavaType java = (JavaType)$dstr$nat$java.component2();
            paramDocs.put(nat.getName(), this.makeTypeDoc(java, nat.getDecorators()));
        }
        this.generateJavadoc(paramDocs, "", w);
        w.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n            public " + $this$generateConstructor.getName() + '(' + javaArgs2 + ") {\n                address = _" + ctorFunc.getName() + '(' + callArgs2 + ");\n            }\n            private static native long _" + ctorFunc.getName() + '(' + nativeArgs2 + ");\n        ")), 4)).append("\n\n");
    }

    private final void generateDestructor(Writer w) {
        w.append(CodeGeneratorKt.prependIndent("public void destroy() {\n    if (address == 0L) {\n        throw new IllegalStateException(this + \" is already deleted\");\n    }\n    if (isExternallyAllocated) {\n        throw new IllegalStateException(this + \" is externally allocated and cannot be manually destroyed\");\n    }\n    _delete_native_instance(address);\n    address = 0L;\n}\nprivate static native long _delete_native_instance(long address);", 4)).append("\n\n");
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFunction(IdlInterface $this$generateFunction, IdlFunction func, Writer w) {
        Collection<JavaType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = func.getParameters();
        Iterable iterable2 = func.getParameters();
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JavaType javaType = this.JavaType(it.getType());
            collection.add(javaType);
        }
        collection = (List)destination$iv$iv;
        List nativeToJavaParams = CollectionsKt.zip((Iterable)iterable2, (Iterable)collection);
        String staticMod = func.isStatic() ? " static" : "";
        String javaArgs2 = CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)generateFunction.javaArgs.1.INSTANCE, (int)31, null);
        JavaType returnType = this.JavaType(func.getReturnType());
        String nativeArgs2 = func.isStatic() ? "" : "long address";
        String callArgs2 = func.isStatic() ? "" : "address";
        Object object = nativeToJavaParams;
        boolean item$iv$iv = false;
        if (!object.isEmpty()) {
            object = nativeArgs2;
            item$iv$iv = false;
            if (object.length() > 0) {
                nativeArgs2 = nativeArgs2 + ", ";
            }
            object = callArgs2;
            item$iv$iv = false;
            if (object.length() > 0) {
                callArgs2 = callArgs2 + ", ";
            }
            nativeArgs2 = nativeArgs2 + CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)generateFunction.1.INSTANCE, (int)31, null);
            callArgs2 = callArgs2 + CollectionsKt.joinToString$default((Iterable)nativeToJavaParams, null, null, null, (int)0, null, (Function1)((Function1)new Function1<Pair<? extends IdlFunctionParameter, ? extends JavaType>, CharSequence>(this, $this$generateFunction, func){
                final /* synthetic */ JniJavaGenerator this$0;
                final /* synthetic */ IdlInterface $this_generateFunction;
                final /* synthetic */ IdlFunction $func;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final CharSequence invoke(@NotNull Pair<IdlFunctionParameter, JavaType> $dstr$nat$java) {
                    void nat;
                    Intrinsics.checkNotNullParameter($dstr$nat$java, (String)"<name for destructuring parameter 0>");
                    IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)$dstr$nat$java.component1();
                    JavaType java = (JavaType)$dstr$nat$java.component2();
                    return java.unbox(nat.getName(), JniJavaGenerator.access$isNullable(this.this$0, (IdlFunctionParameter)nat, this.$this_generateFunction, this.$func));
                }
                {
                    this.this$0 = jniJavaGenerator;
                    this.$this_generateFunction = idlInterface;
                    this.$func = idlFunction;
                    super(1);
                }
            }), (int)31, null);
        }
        String nullCheck = func.isStatic() ? "" : '\n' + CodeGeneratorKt.indent(16) + "checkNotNull();";
        boolean it = false;
        Map paramDocs = new LinkedHashMap();
        Iterable $this$forEach$iv = nativeToJavaParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void nat;
            Pair $dstr$nat$java = (Pair)element$iv;
            boolean bl = false;
            IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)$dstr$nat$java.component1();
            JavaType java = (JavaType)$dstr$nat$java.component2();
            paramDocs.put(nat.getName(), this.makeTypeDoc(java, nat.getDecorators()));
        }
        String returnDoc = returnType.getIdlType().isVoid() ? "" : this.makeTypeDoc(returnType, func.getDecorators());
        this.generateJavadoc(paramDocs, returnDoc, w);
        w.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n            public" + staticMod + ' ' + returnType.getJavaType() + ' ' + func.getName() + '(' + javaArgs2 + ") {" + nullCheck + "\n                " + returnType.boxedReturn('_' + func.getName() + '(' + callArgs2 + ')') + ";\n            }\n            private static native " + returnType.getInternalType() + " _" + func.getName() + '(' + nativeArgs2 + ");\n        ")), 4)).append("\n\n");
    }

    private final void generateGet(IdlAttribute attrib, Writer w) {
        JavaType javaType = this.JavaType(attrib.getType());
        String methodName = "get" + this.firstCharToUpper(attrib.getName());
        String staticMod = attrib.isStatic() ? " static" : "";
        String arrayModPriv = attrib.getType().isArray() ? ", int index" : "";
        String arrayModPub = attrib.getType().isArray() ? "int index" : "";
        String arrayCallMod = attrib.getType().isArray() ? ", index" : "";
        String addressSig = attrib.isStatic() ? "" : "long address";
        String addressCall = attrib.isStatic() ? "" : "address";
        String nullCheck = attrib.isStatic() ? "" : '\n' + CodeGeneratorKt.indent(16) + "checkNotNull();";
        boolean bl = false;
        Map paramDocs = new LinkedHashMap();
        if (attrib.getType().isArray()) {
            paramDocs.put("index", "Array index");
        }
        this.generateJavadoc(paramDocs, this.makeTypeDoc(javaType, attrib.getDecorators()), w);
        w.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n            public" + staticMod + ' ' + javaType.getJavaType() + ' ' + methodName + '(' + arrayModPub + ") {" + nullCheck + "\n                " + javaType.boxedReturn('_' + methodName + '(' + addressCall + arrayCallMod + ')') + ";\n            }\n            private static native " + javaType.getInternalType() + " _" + methodName + '(' + addressSig + arrayModPriv + ");\n        ")), 4)).append("\n\n");
    }

    private final void generateSet(IdlInterface $this$generateSet, IdlAttribute attrib, Writer w) {
        boolean bl;
        CharSequence charSequence;
        String nativeSig;
        JavaType javaType = this.JavaType(attrib.getType());
        String methodName = "set" + this.firstCharToUpper(attrib.getName());
        String staticMod = attrib.isStatic() ? " static" : "";
        String arrayModPub = attrib.getType().isArray() ? "int index, " : "";
        String arrayCallMod = attrib.getType().isArray() ? ", index" : "";
        String addressCall = attrib.isStatic() ? "" : "address";
        String nullCheck = attrib.isStatic() ? "" : '\n' + CodeGeneratorKt.indent(16) + "checkNotNull();";
        String string = nativeSig = attrib.isStatic() ? "" : "long address";
        if (attrib.getType().isArray()) {
            charSequence = nativeSig;
            bl = false;
            if (charSequence.length() > 0) {
                nativeSig = nativeSig + ", ";
            }
            nativeSig = nativeSig + "int index";
        }
        charSequence = nativeSig;
        bl = false;
        if (charSequence.length() > 0) {
            nativeSig = nativeSig + ", ";
        }
        nativeSig = nativeSig + javaType.getInternalType() + " value";
        bl = false;
        Map paramDocs = new LinkedHashMap();
        if (attrib.getType().isArray()) {
            paramDocs.put("index", "Array index");
        }
        paramDocs.put("value", this.makeTypeDoc(javaType, attrib.getDecorators()));
        this.generateJavadoc(paramDocs, "", w);
        w.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n            public" + staticMod + " void " + methodName + '(' + arrayModPub + javaType.getJavaType() + " value) {" + nullCheck + "\n                _" + methodName + '(' + addressCall + arrayCallMod + ", " + javaType.unbox("value", this.isNullable(attrib, $this$generateSet)) + ");\n            }\n            private static native void _" + methodName + '(' + nativeSig + ");\n        ")), 4)).append("\n\n");
    }

    private final String makeTypeDoc(JavaType javaType, List<IdlDecorator> decorators) {
        String string;
        if (javaType.isIdlEnum()) {
            string = " [enum]";
        } else {
            Collection collection = decorators;
            boolean bl = false;
            string = !collection.isEmpty() ? "" + ' ' + decorators : "";
        }
        String decoString = string;
        String typeString = javaType.getIdlType().isComplexType() ? "WebIDL type: {@link " + javaType.getIdlType().getTypeName() + '}' : "WebIDL type: " + javaType.getIdlType().getTypeName();
        return typeString + decoString;
    }

    static /* synthetic */ String makeTypeDoc$default(JniJavaGenerator jniJavaGenerator, JavaType javaType, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return jniJavaGenerator.makeTypeDoc(javaType, list);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateJavadoc(Map<String, String> paramDocs, String returnDoc, Writer w) {
        block10: {
            boolean bl;
            Map<String, String> map;
            block9: {
                map = paramDocs;
                bl = false;
                if (!map.isEmpty()) break block9;
                map = returnDoc;
                bl = false;
                if (!(map.length() > 0)) break block10;
            }
            w.append("    /**\n");
            map = paramDocs;
            bl = false;
            if (!map.isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = paramDocs.keySet();
                boolean $i$f$map = false;
                Object object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Integer n = it.length();
                    collection.add(n);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                object = $this$map$iv.iterator();
                if (!object.hasNext()) {
                    throw (Throwable)new NoSuchElementException();
                }
                int it = ((Number)object.next()).intValue();
                boolean bl3 = false;
                int n = it;
                while (object.hasNext()) {
                    int it2 = ((Number)object.next()).intValue();
                    $i$a$-maxOf-JniJavaGenerator$generateJavadoc$maxNameLen$2 = false;
                    int n2 = it2;
                    if (n >= n2) continue;
                    n = n2;
                }
                int maxNameLen = n;
                Map<String, String> $this$forEach$iv = paramDocs;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv;
                n = 0;
                Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    void name;
                    StringCompanionObject element$iv;
                    StringCompanionObject $dstr$name$doc = element$iv = iterator.next();
                    boolean bl4 = false;
                    StringCompanionObject stringCompanionObject = $dstr$name$doc;
                    boolean bl5 = false;
                    String string = stringCompanionObject.getKey();
                    stringCompanionObject = $dstr$name$doc;
                    bl5 = false;
                    String doc = stringCompanionObject.getValue();
                    stringCompanionObject = StringCompanionObject.INSTANCE;
                    Locale locale = Locale.ENGLISH;
                    String string2 = "     * @param %-" + maxNameLen + "s %s\n";
                    Object[] objectArray = new Object[]{name, doc};
                    boolean bl6 = false;
                    String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                    w.append(string3);
                }
            }
            CharSequence charSequence = returnDoc;
            boolean bl7 = false;
            if (charSequence.length() > 0) {
                w.append("     * @return " + returnDoc + '\n');
            }
            w.append("     */\n");
        }
    }

    private final void generate(IdlEnum $this$generate, JavaClass javaClass) {
        String string = javaClass.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.path");
        javaClass.generateSource(this.createOutFileWriter(string), (Function1<? super Writer, Unit>)((Function1)new Function1<Writer, Unit>($this$generate){
            final /* synthetic */ IdlEnum $this_generate;

            public final void invoke(@NotNull Writer $this$generateSource) {
                String enumVal;
                Intrinsics.checkNotNullParameter((Object)$this$generateSource, (String)"$receiver");
                Iterable $this$forEach$iv = this.$this_generate.getUnprefixedValues();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    enumVal = (String)element$iv;
                    boolean bl = false;
                    $this$generateSource.write("    public static final int " + enumVal + " = _get" + enumVal + "();\n");
                }
                $this$generateSource.write("\n");
                $this$forEach$iv = this.$this_generate.getUnprefixedValues();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    enumVal = (String)element$iv;
                    boolean bl = false;
                    $this$generateSource.write("    private static native int _get" + enumVal + "();\n");
                }
            }
            {
                this.$this_generate = idlEnum;
                super(1);
            }
        }));
    }

    private final JavaType JavaType(IdlType idlType) {
        JavaClass javaClass = this.typeMap.get(idlType.getTypeName());
        return new JavaType(idlType, javaClass != null ? javaClass.isEnum() : false);
    }

    public JniJavaGenerator() {
        boolean bl = false;
        this.externallyAllocatableClasses = new LinkedHashSet();
        this.generateSimpleStackAllocators = true;
        this.generateInterfaceStackAllocators = true;
        bl = false;
        this.nullableAttributes = new LinkedHashSet();
        bl = false;
        this.nullableParameters = new LinkedHashSet();
        this.onClassLoad = "";
        bl = false;
        this.typeMap = new LinkedHashMap();
        this.setOutputDirectory("./generated/java");
    }

    static {
        Companion = new Companion(null);
        idlPrimitiveTypeMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"boolean", (Object)"boolean"), TuplesKt.to((Object)"float", (Object)"float"), TuplesKt.to((Object)"double", (Object)"double"), TuplesKt.to((Object)"byte", (Object)"byte"), TuplesKt.to((Object)"DOMString", (Object)"String"), TuplesKt.to((Object)"octet", (Object)"byte"), TuplesKt.to((Object)"short", (Object)"short"), TuplesKt.to((Object)"long", (Object)"int"), TuplesKt.to((Object)"long long", (Object)"long"), TuplesKt.to((Object)"unsigned short", (Object)"short"), TuplesKt.to((Object)"unsigned long", (Object)"int"), TuplesKt.to((Object)"unsigned long long", (Object)"long"), TuplesKt.to((Object)"void", (Object)"void")});
    }

    public static final /* synthetic */ void access$generateDestructor(JniJavaGenerator $this, Writer w) {
        $this.generateDestructor(w);
    }

    public static final /* synthetic */ JavaType access$JavaType(JniJavaGenerator $this, IdlType idlType) {
        return $this.JavaType(idlType);
    }

    public static final /* synthetic */ String access$makeTypeDoc(JniJavaGenerator $this, JavaType javaType, List decorators) {
        return $this.makeTypeDoc(javaType, decorators);
    }

    public static final /* synthetic */ void access$generateJavadoc(JniJavaGenerator $this, Map paramDocs, String returnDoc, Writer w) {
        $this.generateJavadoc(paramDocs, returnDoc, w);
    }

    public static final /* synthetic */ void access$generateSizeOf(JniJavaGenerator $this, Writer w) {
        $this.generateSizeOf(w);
    }

    public static final /* synthetic */ void access$generatePlacedConstructor(JniJavaGenerator $this, IdlInterface $this$access_u24generatePlacedConstructor, IdlFunction ctorFunc, Writer w) {
        $this.generatePlacedConstructor($this$access_u24generatePlacedConstructor, ctorFunc, w);
    }

    public static final /* synthetic */ void access$generateConstructor(JniJavaGenerator $this, IdlInterface $this$access_u24generateConstructor, IdlFunction ctorFunc, Writer w) {
        $this.generateConstructor($this$access_u24generateConstructor, ctorFunc, w);
    }

    public static final /* synthetic */ void access$generateGet(JniJavaGenerator $this, IdlAttribute attrib, Writer w) {
        $this.generateGet(attrib, w);
    }

    public static final /* synthetic */ void access$generateSet(JniJavaGenerator $this, IdlInterface $this$access_u24generateSet, IdlAttribute attrib, Writer w) {
        $this.generateSet($this$access_u24generateSet, attrib, w);
    }

    public static final /* synthetic */ void access$generateFunction(JniJavaGenerator $this, IdlInterface $this$access_u24generateFunction, IdlFunction func, Writer w) {
        $this.generateFunction($this$access_u24generateFunction, func, w);
    }

    public static final /* synthetic */ boolean access$isNullable(JniJavaGenerator $this, IdlFunctionParameter $this$access_u24isNullable, IdlInterface idlIf, IdlFunction idlFunc) {
        return $this.isNullable($this$access_u24isNullable, idlIf, idlFunc);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lde/fabmax/webidl/generator/jni/java/JniJavaGenerator$Companion;", "", "()V", "NATIVE_OBJECT_NAME", "", "idlPrimitiveTypeMap", "", "getIdlPrimitiveTypeMap", "()Ljava/util/Map;", "webidl-util"})
    public static final class Companion {
        @NotNull
        public final Map<String, String> getIdlPrimitiveTypeMap() {
            return idlPrimitiveTypeMap;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

