/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.webidl.generator.jni.nat;

import de.fabmax.webidl.generator.CodeGeneratorKt;
import de.fabmax.webidl.generator.jni.nat.CallbackGenerator;
import de.fabmax.webidl.generator.jni.nat.JavaToNativeTypeMappingKt;
import de.fabmax.webidl.generator.jni.nat.JavaTypeSignature;
import de.fabmax.webidl.generator.jni.nat.NativeType;
import de.fabmax.webidl.model.IdlFunction;
import de.fabmax.webidl.model.IdlFunctionParameter;
import de.fabmax.webidl.model.IdlInterface;
import de.fabmax.webidl.model.IdlModel;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\f\u001a\u00020\b*\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lde/fabmax/webidl/generator/jni/nat/CallbackGenerator;", "", "model", "Lde/fabmax/webidl/model/IdlModel;", "(Lde/fabmax/webidl/model/IdlModel;)V", "getModel", "()Lde/fabmax/webidl/model/IdlModel;", "generateCallbackClasses", "", "w", "Ljava/io/Writer;", "generateJniThreadManager", "generateCallbackClass", "Lde/fabmax/webidl/model/IdlInterface;", "generateCallbackMethods", "", "generateGetMethodIds", "generateMethodIdMembers", "webidl-util"})
public final class CallbackGenerator {
    @NotNull
    private final IdlModel model;

    public final void generateJniThreadManager(@NotNull Writer w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        w.append("static JavaVM * javaVm = NULL;\n\nclass JniThreadEnv {\n    public:\n        JniThreadEnv() : shouldDetach(false), env(NULL) { }\n        JniThreadEnv(JNIEnv *env) : shouldDetach(false), env(env) { }\n        ~JniThreadEnv() {\n            if (shouldDetach) {\n                javaVm->DetachCurrentThread();\n            }\n        }\n        JNIEnv* getEnv() {\n            if (env == NULL && javaVm != NULL) {\n                javaVm->AttachCurrentThreadAsDaemon((void**) &env, NULL);\n                shouldDetach = true;\n            }\n            return env;\n        }\n        \n    private:\n        bool shouldDetach;\n        JNIEnv *env;\n};\n\nstatic thread_local JniThreadEnv jniThreadEnv;\n\nclass JniThreadManager {\n    public:\n        static bool init(JNIEnv *env) {\n            if (env->GetJavaVM(&javaVm) != 0) {\n                return false;\n            }\n            jniThreadEnv = JniThreadEnv(env);\n            return true;\n        }\n};\n\nclass JavaNativeRef {\n    public:\n        JavaNativeRef(JNIEnv *env, jobject javaRef) {\n            javaGlobalRef = env->NewGlobalRef(javaRef);\n        }\n        \n        ~JavaNativeRef() {\n            jniThreadEnv.getEnv()->DeleteGlobalRef(javaGlobalRef);\n        }\n        \n        jobject javaGlobalRef;\n};").append("\n\n");
    }

    /*
     * WARNING - void declaration
     */
    public final void generateCallbackClasses(@NotNull Writer w) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Iterable $this$filter$iv = this.model.getInterfaces();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IdlInterface it = (IdlInterface)element$iv$iv;
            boolean bl = false;
            if (!it.hasDecorator("JSImplementation")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdlInterface it = (IdlInterface)element$iv;
            boolean bl = false;
            this.generateCallbackClass(it, w);
        }
    }

    private final void generateCallbackClass(IdlInterface $this$generateCallbackClass, Writer w) {
        Object v0;
        String superClassName;
        block2: {
            superClassName = $this$generateCallbackClass.getDecoratorValue("JSImplementation", "");
            Iterable iterable = this.model.getInterfaces();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                IdlInterface it = (IdlInterface)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)superClassName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        IdlInterface idlInterface = v0;
        if (idlInterface == null) {
            throw (Throwable)new IllegalStateException("Callback class " + $this$generateCallbackClass.getName() + " has an invalid / unknown super class \"" + superClassName + '\"');
        }
        IdlInterface superClass = idlInterface;
        superClassName = superClass.getDecoratorValue("Prefix", "") + superClassName;
        w.append(StringsKt.trimIndent((String)("\n            class " + $this$generateCallbackClass.getName() + " : " + superClassName + " {\n                public:\n                    " + $this$generateCallbackClass.getName() + "(JNIEnv* env, jobject javaLocalRef) {\n                        javaGlobalRef = env->NewGlobalRef(javaLocalRef);\n                        jclass javaClass = env->GetObjectClass(javaLocalRef);\n                        " + this.generateGetMethodIds($this$generateCallbackClass) + "\n                    }\n                    \n                    ~" + $this$generateCallbackClass.getName() + "() {\n                        jniThreadEnv.getEnv()->DeleteGlobalRef(javaGlobalRef);\n                    }\n                    " + this.generateCallbackMethods($this$generateCallbackClass) + "\n                private:\n                    jobject javaGlobalRef;\n                    " + this.generateMethodIdMembers($this$generateCallbackClass) + "\n            };\n        "))).append("\n\n");
    }

    /*
     * WARNING - void declaration
     */
    private final String generateCallbackMethods(IdlInterface $this$generateCallbackMethods) {
        void $this$filterTo$iv$iv;
        StringBuilder out = new StringBuilder();
        Iterable $this$filter$iv = $this$generateCallbackMethods.getFunctions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IdlFunction it = (IdlFunction)element$iv$iv;
            boolean bl2 = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)$this$generateCallbackMethods.getName()) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Collection<NativeType> collection;
            CharSequence $this$mapTo$iv$iv;
            void $this$map$iv;
            IdlFunction cbFunc = (IdlFunction)element$iv;
            boolean bl = false;
            String env = "_env";
            NativeType returnType = JavaToNativeTypeMappingKt.getNativeType(cbFunc, this.model);
            Iterable bl2 = cbFunc.getParameters();
            Iterable iterable2 = cbFunc.getParameters();
            boolean $i$f$map = false;
            void var14_18 = $this$map$iv;
            Object destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                IdlFunctionParameter idlFunctionParameter = (IdlFunctionParameter)item$iv$iv;
                collection = destination$iv$iv22;
                boolean bl3 = false;
                NativeType nativeType = JavaToNativeTypeMappingKt.getNativeType((IdlFunctionParameter)it, this.model);
                collection.add(nativeType);
            }
            collection = (List)destination$iv$iv22;
            List paramsToTypes = CollectionsKt.zip((Iterable)iterable2, (Iterable)collection);
            String params2 = CollectionsKt.joinToString$default((Iterable)paramsToTypes, (CharSequence)", ", null, null, (int)0, null, (Function1)generateCallbackMethods.2.params.1.INSTANCE, (int)30, null);
            String callParams2 = CollectionsKt.joinToString$default((Iterable)paramsToTypes, (CharSequence)", ", null, null, (int)0, null, (Function1)generateCallbackMethods.2.callParams.1.INSTANCE, (int)30, null);
            $this$mapTo$iv$iv = callParams2;
            boolean destination$iv$iv22 = false;
            if ($this$mapTo$iv$iv.length() > 0) {
                callParams2 = ", " + callParams2;
            }
            switch (cbFunc.getReturnType().getTypeName()) {
                case "boolean": {
                    string = "CallBooleanMethod";
                    break;
                }
                case "float": {
                    string = "CallFloatMethod";
                    break;
                }
                case "double": {
                    string = "CallDoubleMethod";
                    break;
                }
                case "byte": {
                    string = "CallByteMethod";
                    break;
                }
                case "DOMString": {
                    string = "CallObjectMethod";
                    break;
                }
                case "octet": {
                    string = "CallByteMethod";
                    break;
                }
                case "short": {
                    string = "CallShortMethod";
                    break;
                }
                case "long": {
                    string = "CallIntMethod";
                    break;
                }
                case "long long": {
                    string = "CallLongMethod";
                    break;
                }
                case "unsigned short": {
                    string = "CallShortMethod";
                    break;
                }
                case "unsigned long": {
                    string = "CallIntMethod";
                    break;
                }
                case "unsigned long long": {
                    string = "CallLongMethod";
                    break;
                }
                case "void": {
                    string = "CallVoidMethod";
                    break;
                }
                default: {
                    string = "CallLongMethod";
                }
            }
            String callTypedMethod = string;
            String call = env + "->" + callTypedMethod + "(javaGlobalRef, " + cbFunc.getName() + "MethodId" + callParams2 + ')';
            if (!cbFunc.getReturnType().isVoid()) {
                call = "return " + returnType.castJniToNative(call);
            }
            out.append('\n').append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)("\n                virtual " + returnType.nativeType() + ' ' + cbFunc.getName() + '(' + params2 + ") {\n                    JNIEnv* " + env + " = jniThreadEnv.getEnv();\n                    " + call + ";\n                }\n            ")), 20)).append('\n');
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateGetMethodIds(IdlInterface $this$generateGetMethodIds) {
        IdlFunction it;
        void $this$filterTo$iv$iv;
        StringBuilder out = new StringBuilder();
        Iterable $this$filter$iv = $this$generateGetMethodIds.getFunctions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdlFunction)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)$this$generateGetMethodIds.getName()) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cbFuncs = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = cbFuncs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cbFunc;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (IdlFunction)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i > 0) {
                out.append(CodeGeneratorKt.indent(24));
            }
            out.append(cbFunc.getName() + "MethodId = env->GetMethodID(javaClass, \"_" + cbFunc.getName() + "\", \"" + JavaTypeSignature.INSTANCE.getJavaFunctionSignature((IdlFunction)cbFunc, this.model) + "\");");
            if (i >= CollectionsKt.getLastIndex((List)cbFuncs)) continue;
            out.append('\n');
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateMethodIdMembers(IdlInterface $this$generateMethodIdMembers) {
        IdlFunction it;
        void $this$filterTo$iv$iv;
        StringBuilder out = new StringBuilder();
        Iterable $this$filter$iv = $this$generateMethodIdMembers.getFunctions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdlFunction)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)$this$generateMethodIdMembers.getName()) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cbFuncs = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = cbFuncs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cbFunc;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (IdlFunction)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i > 0) {
                out.append(CodeGeneratorKt.indent(20));
            }
            out.append("jmethodID " + cbFunc.getName() + "MethodId;");
            if (i >= CollectionsKt.getLastIndex((List)cbFuncs)) continue;
            out.append('\n');
        }
        String string = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
        return string;
    }

    @NotNull
    public final IdlModel getModel() {
        return this.model;
    }

    public CallbackGenerator(@NotNull IdlModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
    }
}

