/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.webidl.generator.jni.nat;

import de.fabmax.webidl.generator.CodeGenerator;
import de.fabmax.webidl.generator.CodeGeneratorKt;
import de.fabmax.webidl.generator.jni.nat.CallbackGenerator;
import de.fabmax.webidl.generator.jni.nat.JavaToNativeTypeMappingKt;
import de.fabmax.webidl.generator.jni.nat.JavaTypeSignature;
import de.fabmax.webidl.generator.jni.nat.NativeType;
import de.fabmax.webidl.model.IdlAttribute;
import de.fabmax.webidl.model.IdlDecoratedElement;
import de.fabmax.webidl.model.IdlElement;
import de.fabmax.webidl.model.IdlEnum;
import de.fabmax.webidl.model.IdlFunction;
import de.fabmax.webidl.model.IdlFunctionParameter;
import de.fabmax.webidl.model.IdlInterface;
import de.fabmax.webidl.model.IdlModel;
import java.io.Closeable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J*\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u0005H\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\"\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010#\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010&\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010'\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010(\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010)\u001a\u00020\u0010*\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010*\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010+\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010,\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010-\u001a\u00020\u0005*\u00020\u00132\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010.\u001a\u00020%H\u0002J&\u0010/\u001a\u00020\u0010*\u00020\u00162\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001001\u00a2\u0006\u0002\b3H\u0082\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00065"}, d2={"Lde/fabmax/webidl/generator/jni/nat/JniNativeGenerator;", "Lde/fabmax/webidl/generator/CodeGenerator;", "()V", "externallyAllocatableClasses", "", "", "getExternallyAllocatableClasses", "()Ljava/util/Set;", "model", "Lde/fabmax/webidl/model/IdlModel;", "packagePrefix", "getPackagePrefix", "()Ljava/lang/String;", "setPackagePrefix", "(Ljava/lang/String;)V", "generate", "", "generateFuncArgs", "func", "Lde/fabmax/webidl/model/IdlFunction;", "generateJniSupportBindings", "w", "Ljava/io/Writer;", "nativeFunName", "idlIf", "Lde/fabmax/webidl/model/IdlInterface;", "attrib", "Lde/fabmax/webidl/model/IdlAttribute;", "funPrefix", "srcPkg", "className", "functionName", "nameSuffix", "Lde/fabmax/webidl/model/IdlEnum;", "generateCallbackInterface", "generateCtor", "isOverloaded", "", "generateDtor", "generateFunction", "generateGet", "generateGlueCpp", "generatePlacedCtor", "generateSet", "generateSizeOf", "getFunctionSuffix", "isCtor", "nativeFunc", "block", "Lkotlin/Function1;", "Lde/fabmax/webidl/generator/jni/nat/JniNativeGenerator$NativeFuncRenderer;", "Lkotlin/ExtensionFunctionType;", "NativeFuncRenderer", "webidl-util"})
public final class JniNativeGenerator
extends CodeGenerator {
    @NotNull
    private String packagePrefix = "";
    @NotNull
    private final Set<String> externallyAllocatableClasses;
    private IdlModel model;

    @NotNull
    public final String getPackagePrefix() {
        return this.packagePrefix;
    }

    public final void setPackagePrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.packagePrefix = string;
    }

    @NotNull
    public final Set<String> getExternallyAllocatableClasses() {
        return this.externallyAllocatableClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(@NotNull IdlModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        Closeable closeable = this.createOutFileWriter("glue.h");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Writer it = (Writer)closeable;
            boolean bl3 = false;
            this.generateGlueCpp(model, it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void generateGlueCpp(IdlModel $this$generateGlueCpp, Writer w) {
        w.append(StringsKt.trimIndent((String)("\n            /*\n             * JNI glue code. You should not edit this file.\n             * Generated from WebIDL model '" + $this$generateGlueCpp.getName() + "' by webidl-util.\n             */\n            #include <jni.h>\n        "))).append("\n\n");
        CallbackGenerator callbackGenerator = new CallbackGenerator($this$generateGlueCpp);
        callbackGenerator.generateJniThreadManager(w);
        callbackGenerator.generateCallbackClasses(w);
        w.append("extern \"C\" {\n");
        this.generateJniSupportBindings(w);
        Iterable $this$forEach$iv = $this$generateGlueCpp.collectPackages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdlDecoratedElement it;
            String pkg = (String)element$iv;
            boolean bl = false;
            String string = pkg;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pkg");
            Iterable $this$forEach$iv2 = $this$generateGlueCpp.getInterfacesByPackage(string);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (IdlInterface)element$iv2;
                boolean bl2 = false;
                if (it.hasDecorator("JSImplementation")) {
                    this.generateCallbackInterface((IdlInterface)it, w);
                    continue;
                }
                this.generate((IdlInterface)it, w);
            }
            $this$forEach$iv2 = $this$generateGlueCpp.getEnumsByPackage(pkg);
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (IdlEnum)element$iv2;
                boolean bl3 = false;
                this.generate((IdlEnum)it, w);
            }
        }
        w.write("\n} // /extern \"C\"\n");
    }

    private final void generateJniSupportBindings(Writer w) {
        w.append('\n').append(StringsKt.trimIndent((String)("\n            // JniThreadManager\n            JNIEXPORT jboolean JNICALL " + JniNativeGenerator.nativeFunName$default(this, "", "JniThreadManager", "init", null, 8, null) + "(JNIEnv* env, jclass) {\n                return (jboolean) JniThreadManager::init(env);\n            }\n            JNIEXPORT void JNICALL " + JniNativeGenerator.nativeFunName$default(this, "", "JniThreadManager", "delete_native_instance", null, 8, null) + "(JNIEnv*, jclass, jlong address) {\n                delete (JniThreadManager*) address;\n            }\n            // JavaNativeRef\n            JNIEXPORT jlong JNICALL " + JniNativeGenerator.nativeFunName$default(this, "", "JavaNativeRef", "new_instance", null, 8, null) + "(JNIEnv* env, jclass, jobject javaRef) {\n                return (jlong) new JavaNativeRef(env, javaRef);\n            }\n            JNIEXPORT void JNICALL " + JniNativeGenerator.nativeFunName$default(this, "", "JavaNativeRef", "delete_instance", null, 8, null) + "(JNIEnv*, jclass, jlong address) {\n                delete (JavaNativeRef*) address;\n            }\n            JNIEXPORT jobject JNICALL " + JniNativeGenerator.nativeFunName$default(this, "", "JavaNativeRef", "get_java_ref", null, 8, null) + "(JNIEnv*, jclass, jlong address) {\n                return ((JavaNativeRef*) address)->javaGlobalRef;\n            }\n        "))).append('\n');
    }

    /*
     * WARNING - void declaration
     */
    private final void generate(IdlEnum $this$generate, Writer w) {
        w.write("\n// " + $this$generate.getName() + '\n');
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)$this$generate.getValues(), (Iterable)$this$generate.getUnprefixedValues());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void prefixedVal;
            Pair $dstr$prefixedVal$valName = (Pair)element$iv;
            boolean bl = false;
            String string = (String)$dstr$prefixedVal$valName.component1();
            String valName = (String)$dstr$prefixedVal$valName.component2();
            w.append(StringsKt.trimIndent((String)("\n                JNIEXPORT jint JNICALL " + JniNativeGenerator.nativeFunName$default(this, $this$generate.getSourcePackage(), $this$generate.getName(), "get" + valName, null, 8, null) + "(JNIEnv*, jclass) {\n                    return " + (String)prefixedVal + ";\n                }\n            "))).append('\n');
        }
    }

    private final void generateCallbackInterface(IdlInterface $this$generateCallbackInterface, Writer w) {
        w.write("\n// " + $this$generateCallbackInterface.getName() + '\n');
        IdlModel idlModel = this.model;
        if (idlModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
        }
        NativeType natType = JavaToNativeTypeMappingKt.getNativeType($this$generateCallbackInterface, idlModel);
        w.append(StringsKt.trimIndent((String)("\n            JNIEXPORT jlong JNICALL " + JniNativeGenerator.nativeFunName$default(this, $this$generateCallbackInterface.getSourcePackage(), $this$generateCallbackInterface.getName(), $this$generateCallbackInterface.getName(), null, 8, null) + "(JNIEnv* env, jobject obj) {\n                return (jlong) new " + $this$generateCallbackInterface.getName() + "(env, obj);\n            }\n            JNIEXPORT void JNICALL " + JniNativeGenerator.nativeFunName$default(this, $this$generateCallbackInterface.getSourcePackage(), $this$generateCallbackInterface.getName(), "delete_native_instance", null, 8, null) + "(JNIEnv*, jclass, jlong address) {\n                delete " + natType.castJniToNative("address") + ";\n            }\n        "))).append("\n");
    }

    /*
     * WARNING - void declaration
     */
    private final void generate(IdlInterface $this$generate, Writer w) {
        Object it;
        w.write("\n// " + $this$generate.getName() + '\n');
        if (this.externallyAllocatableClasses.contains($this$generate.getName())) {
            void $this$filterTo$iv$iv;
            this.generateSizeOf($this$generate, w);
            Iterable $this$filter$iv = $this$generate.getFunctions();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IdlFunction)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((IdlElement)it).getName(), (Object)$this$generate.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List ctors = (List)destination$iv$iv;
            boolean isOverloaded = ctors.size() > 1;
            Iterable $this$forEach$iv = ctors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdlFunction ctor = (IdlFunction)element$iv;
                boolean bl = false;
                this.generatePlacedCtor($this$generate, ctor, isOverloaded, w);
            }
        }
        Iterable $this$forEach$iv = $this$generate.getFunctions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean isOverloaded;
            void $this$filterTo$iv$iv;
            IdlFunction func = (IdlFunction)element$iv;
            boolean bl = false;
            Iterable $this$filter$iv = $this$generate.getFunctions();
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IdlFunction it2 = (IdlFunction)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)func.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            boolean bl3 = false;
            boolean bl4 = isOverloaded = collection.size() > 1;
            if (Intrinsics.areEqual((Object)func.getName(), (Object)$this$generate.getName())) {
                this.generateCtor($this$generate, func, isOverloaded, w);
                continue;
            }
            this.generateFunction($this$generate, func, isOverloaded, w);
        }
        if (!$this$generate.hasDecorator("NoDelete")) {
            this.generateDtor($this$generate, w);
        }
        $this$forEach$iv = $this$generate.getAttributes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdlAttribute it3 = (IdlAttribute)element$iv;
            boolean bl = false;
            this.generateGet($this$generate, it3, w);
            if (it3.isReadonly()) continue;
            this.generateSet($this$generate, it3, w);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFunction(IdlInterface $this$generateFunction, IdlFunction func, boolean isOverloaded, Writer w) {
        void $this$nativeFunc$iv;
        String callTarget;
        String string;
        boolean bl;
        NativeFuncRenderer nativeFuncRenderer;
        String funcArgs;
        NativeType natReturnType;
        String ifPrefix;
        NativeFuncRenderer $this$nativeFunc;
        NativeFuncRenderer renderer$iv;
        block10: {
            void $this$any$iv;
            Writer writer = w;
            JniNativeGenerator this_$iv = this;
            boolean $i$f$nativeFunc = false;
            $this$nativeFunc = renderer$iv = new NativeFuncRenderer();
            boolean bl2 = false;
            ifPrefix = $this$generateFunction.getDecoratorValue("Prefix", "");
            IdlModel idlModel = this.model;
            if (idlModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            }
            natReturnType = JavaToNativeTypeMappingKt.getNativeType(func, idlModel);
            String suffix = JniNativeGenerator.getFunctionSuffix$default(this, func, isOverloaded, false, 2, null);
            funcArgs = CollectionsKt.joinToString$default((Iterable)func.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<IdlFunctionParameter, CharSequence>(this, $this$generateFunction, func, isOverloaded){
                final /* synthetic */ JniNativeGenerator this$0;
                final /* synthetic */ IdlInterface $this_generateFunction$inlined;
                final /* synthetic */ IdlFunction $func$inlined;
                final /* synthetic */ boolean $isOverloaded$inlined;
                {
                    this.this$0 = jniNativeGenerator;
                    this.$this_generateFunction$inlined = idlInterface;
                    this.$func$inlined = idlFunction;
                    this.$isOverloaded$inlined = bl;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull IdlFunctionParameter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return JavaToNativeTypeMappingKt.getNativeType(it, JniNativeGenerator.access$getModel$p(this.this$0)).castJniToNative(it.getName());
                }
            }), (int)30, null);
            $this$nativeFunc.setReturnType(natReturnType.jniType());
            $this$nativeFunc.setFunctionName(this.nativeFunName($this$generateFunction.getSourcePackage(), $this$generateFunction.getName(), func.getName(), suffix));
            $this$nativeFunc.setReceivingAddress(!func.isStatic());
            Iterable iterable = func.getParameters();
            nativeFuncRenderer = $this$nativeFunc;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IdlFunctionParameter it = (IdlFunctionParameter)element$iv;
                    boolean bl3 = false;
                    if (!it.getType().isString()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean bl4 = bl;
        nativeFuncRenderer.setUsingEnv(bl4 || func.getReturnType().isString());
        $this$nativeFunc.setExtraArgs(this.generateFuncArgs(func));
        if (natReturnType.isValue()) {
            NativeFuncRenderer nativeFuncRenderer2 = $this$nativeFunc;
            nativeFuncRenderer2.setBody(nativeFuncRenderer2.getBody() + "static thread_local " + natReturnType.getJniTypeName() + " _cache;\n");
        }
        if (!func.isStatic()) {
            NativeFuncRenderer nativeFuncRenderer3 = $this$nativeFunc;
            nativeFuncRenderer3.setBody(nativeFuncRenderer3.getBody() + ifPrefix + $this$generateFunction.getName() + "* self = (" + ifPrefix + $this$generateFunction.getName() + "*) _address;\n");
            string = "self->";
        } else {
            string = callTarget = ifPrefix + $this$generateFunction.getName() + "::";
        }
        if (natReturnType.getIdlType().isVoid()) {
            NativeFuncRenderer nativeFuncRenderer4 = $this$nativeFunc;
            nativeFuncRenderer4.setBody(nativeFuncRenderer4.getBody() + callTarget + func.getName() + '(' + funcArgs + ");\n");
        } else {
            String returnVal = callTarget + func.getName() + '(' + funcArgs + ')';
            if (natReturnType.isValue()) {
                NativeFuncRenderer nativeFuncRenderer5 = $this$nativeFunc;
                nativeFuncRenderer5.setBody(nativeFuncRenderer5.getBody() + "_cache = " + returnVal + ";\n");
                returnVal = "_cache";
            }
            NativeFuncRenderer nativeFuncRenderer6 = $this$nativeFunc;
            nativeFuncRenderer6.setBody(nativeFuncRenderer6.getBody() + "return " + natReturnType.castNativeToJni(returnVal) + ";\n");
        }
        renderer$iv.renderTo((Writer)$this$nativeFunc$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void generatePlacedCtor(IdlInterface $this$generatePlacedCtor, IdlFunction func, boolean isOverloaded, Writer w) {
        void $this$nativeFunc$iv;
        boolean bl;
        NativeFuncRenderer nativeFuncRenderer;
        String ctorArgs;
        NativeType natType;
        NativeFuncRenderer $this$nativeFunc;
        NativeFuncRenderer renderer$iv;
        block4: {
            void $this$any$iv;
            Writer writer = w;
            JniNativeGenerator this_$iv = this;
            boolean $i$f$nativeFunc = false;
            $this$nativeFunc = renderer$iv = new NativeFuncRenderer();
            boolean bl2 = false;
            IdlModel idlModel = this.model;
            if (idlModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            }
            natType = JavaToNativeTypeMappingKt.getNativeType($this$generatePlacedCtor, idlModel);
            String suffix = StringsKt.replace$default((String)this.getFunctionSuffix(func, isOverloaded, true), (String)"__", (String)"__J", (boolean)false, (int)4, null);
            ctorArgs = CollectionsKt.joinToString$default((Iterable)func.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<IdlFunctionParameter, CharSequence>(this, $this$generatePlacedCtor, func, isOverloaded){
                final /* synthetic */ JniNativeGenerator this$0;
                final /* synthetic */ IdlInterface $this_generatePlacedCtor$inlined;
                final /* synthetic */ IdlFunction $func$inlined;
                final /* synthetic */ boolean $isOverloaded$inlined;
                {
                    this.this$0 = jniNativeGenerator;
                    this.$this_generatePlacedCtor$inlined = idlInterface;
                    this.$func$inlined = idlFunction;
                    this.$isOverloaded$inlined = bl;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull IdlFunctionParameter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return JavaToNativeTypeMappingKt.getNativeType(it, JniNativeGenerator.access$getModel$p(this.this$0)).castJniToNative(it.getName());
                }
            }), (int)30, null);
            $this$nativeFunc.setReturnType("jlong");
            $this$nativeFunc.setFunctionName(this.nativeFunName($this$generatePlacedCtor.getSourcePackage(), $this$generatePlacedCtor.getName(), "_placement_new_" + func.getName(), suffix));
            Iterable iterable = func.getParameters();
            nativeFuncRenderer = $this$nativeFunc;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IdlFunctionParameter it = (IdlFunctionParameter)element$iv;
                    boolean bl3 = false;
                    if (!it.getType().isString()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean bl4 = bl;
        nativeFuncRenderer.setUsingEnv(bl4);
        $this$nativeFunc.setReceivingAddress(false);
        $this$nativeFunc.setExtraArgs(", jlong _placement_address" + this.generateFuncArgs(func));
        $this$nativeFunc.setBody("return (jlong) new((void*)_placement_address) " + natType.getJniTypeName() + '(' + ctorArgs + ");");
        renderer$iv.renderTo((Writer)$this$nativeFunc$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCtor(IdlInterface $this$generateCtor, IdlFunction func, boolean isOverloaded, Writer w) {
        void $this$nativeFunc$iv;
        boolean bl;
        NativeFuncRenderer nativeFuncRenderer;
        String ctorArgs;
        NativeType natType;
        NativeFuncRenderer $this$nativeFunc;
        NativeFuncRenderer renderer$iv;
        block4: {
            void $this$any$iv;
            Writer writer = w;
            JniNativeGenerator this_$iv = this;
            boolean $i$f$nativeFunc = false;
            $this$nativeFunc = renderer$iv = new NativeFuncRenderer();
            boolean bl2 = false;
            IdlModel idlModel = this.model;
            if (idlModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            }
            natType = JavaToNativeTypeMappingKt.getNativeType($this$generateCtor, idlModel);
            String suffix = this.getFunctionSuffix(func, isOverloaded, true);
            ctorArgs = CollectionsKt.joinToString$default((Iterable)func.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<IdlFunctionParameter, CharSequence>(this, $this$generateCtor, func, isOverloaded){
                final /* synthetic */ JniNativeGenerator this$0;
                final /* synthetic */ IdlInterface $this_generateCtor$inlined;
                final /* synthetic */ IdlFunction $func$inlined;
                final /* synthetic */ boolean $isOverloaded$inlined;
                {
                    this.this$0 = jniNativeGenerator;
                    this.$this_generateCtor$inlined = idlInterface;
                    this.$func$inlined = idlFunction;
                    this.$isOverloaded$inlined = bl;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull IdlFunctionParameter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return JavaToNativeTypeMappingKt.getNativeType(it, JniNativeGenerator.access$getModel$p(this.this$0)).castJniToNative(it.getName());
                }
            }), (int)30, null);
            $this$nativeFunc.setReturnType("jlong");
            $this$nativeFunc.setFunctionName(this.nativeFunName($this$generateCtor.getSourcePackage(), $this$generateCtor.getName(), func.getName(), suffix));
            Iterable iterable = func.getParameters();
            nativeFuncRenderer = $this$nativeFunc;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IdlFunctionParameter it = (IdlFunctionParameter)element$iv;
                    boolean bl3 = false;
                    if (!it.getType().isString()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean bl4 = bl;
        nativeFuncRenderer.setUsingEnv(bl4);
        $this$nativeFunc.setReceivingAddress(false);
        $this$nativeFunc.setExtraArgs(this.generateFuncArgs(func));
        $this$nativeFunc.setBody("return (jlong) new " + natType.getJniTypeName() + '(' + ctorArgs + ");");
        renderer$iv.renderTo((Writer)$this$nativeFunc$iv);
    }

    private final String generateFuncArgs(IdlFunction func) {
        String args2 = CollectionsKt.joinToString$default((Iterable)func.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<IdlFunctionParameter, CharSequence>(this){
            final /* synthetic */ JniNativeGenerator this$0;

            @NotNull
            public final CharSequence invoke(@NotNull IdlFunctionParameter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return JavaToNativeTypeMappingKt.getNativeType(it, JniNativeGenerator.access$getModel$p(this.this$0)).jniType() + ' ' + it.getName();
            }
            {
                this.this$0 = jniNativeGenerator;
                super(1);
            }
        }), (int)30, null);
        CharSequence charSequence = args2;
        boolean bl = false;
        if (charSequence.length() > 0) {
            args2 = ", " + args2;
        }
        return args2;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateDtor(IdlInterface $this$generateDtor, Writer w) {
        void $this$nativeFunc$iv;
        NativeFuncRenderer renderer$iv;
        IdlModel idlModel = this.model;
        if (idlModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
        }
        NativeType natType = JavaToNativeTypeMappingKt.getNativeType($this$generateDtor, idlModel);
        Writer writer = w;
        JniNativeGenerator this_$iv = this;
        boolean $i$f$nativeFunc = false;
        NativeFuncRenderer $this$nativeFunc = renderer$iv = new NativeFuncRenderer();
        boolean bl = false;
        $this$nativeFunc.setReturnType("void");
        $this$nativeFunc.setFunctionName(JniNativeGenerator.nativeFunName$default(this, $this$generateDtor.getSourcePackage(), $this$generateDtor.getName(), "delete_native_instance", null, 8, null));
        $this$nativeFunc.setBody("delete " + natType.castJniToNative("_address") + ';');
        renderer$iv.renderTo((Writer)$this$nativeFunc$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateGet(IdlInterface $this$generateGet, IdlAttribute attrib, Writer w) {
        void $this$nativeFunc$iv;
        NativeFuncRenderer renderer$iv;
        Writer writer = w;
        JniNativeGenerator this_$iv = this;
        boolean $i$f$nativeFunc = false;
        NativeFuncRenderer $this$nativeFunc = renderer$iv = new NativeFuncRenderer();
        boolean bl = false;
        String ifPrefix = $this$generateGet.getDecoratorValue("Prefix", "");
        IdlModel idlModel = this.model;
        if (idlModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
        }
        NativeType natType = JavaToNativeTypeMappingKt.getNativeType(attrib, idlModel);
        String returnValue = attrib.isStatic() ? ifPrefix + $this$generateGet.getName() + "::" + attrib.getName() : "_self->" + attrib.getName();
        String arrayValueMod = attrib.getType().isArray() ? "[_index]" : "";
        $this$nativeFunc.setReturnType(natType.jniType());
        $this$nativeFunc.setFunctionName(this.nativeFunName($this$generateGet, attrib, "get"));
        $this$nativeFunc.setUsingEnv(attrib.getType().isString());
        $this$nativeFunc.setReceivingAddress(!attrib.isStatic());
        $this$nativeFunc.setReceivingArrayIndex(attrib.getType().isArray());
        $this$nativeFunc.setBody(attrib.isStatic() ? "" : ifPrefix + $this$generateGet.getName() + "* _self = (" + ifPrefix + $this$generateGet.getName() + "*) _address;\n");
        NativeFuncRenderer nativeFuncRenderer = $this$nativeFunc;
        nativeFuncRenderer.setBody(nativeFuncRenderer.getBody() + "return " + natType.castNativeToJni(returnValue + arrayValueMod) + ";\n");
        renderer$iv.renderTo((Writer)$this$nativeFunc$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSet(IdlInterface $this$generateSet, IdlAttribute attrib, Writer w) {
        void $this$nativeFunc$iv;
        NativeFuncRenderer renderer$iv;
        Writer writer = w;
        JniNativeGenerator this_$iv = this;
        boolean $i$f$nativeFunc = false;
        NativeFuncRenderer $this$nativeFunc = renderer$iv = new NativeFuncRenderer();
        boolean bl = false;
        String ifPrefix = $this$generateSet.getDecoratorValue("Prefix", "");
        IdlModel idlModel = this.model;
        if (idlModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
        }
        NativeType natType = JavaToNativeTypeMappingKt.getNativeType(attrib, idlModel);
        String valueReceiver = attrib.isStatic() ? ifPrefix + $this$generateSet.getName() + "::" + attrib.getName() : "_self->" + attrib.getName();
        String arrayValueMod = attrib.getType().isArray() ? "[_index]" : "";
        $this$nativeFunc.setReturnType("void");
        $this$nativeFunc.setFunctionName(this.nativeFunName($this$generateSet, attrib, "set"));
        $this$nativeFunc.setUsingEnv(attrib.getType().isString());
        $this$nativeFunc.setReceivingAddress(!attrib.isStatic());
        $this$nativeFunc.setReceivingArrayIndex(attrib.getType().isArray());
        $this$nativeFunc.setExtraArgs(", " + natType.jniType() + " value");
        $this$nativeFunc.setBody(attrib.isStatic() ? "" : ifPrefix + $this$generateSet.getName() + "* _self = (" + ifPrefix + $this$generateSet.getName() + "*) _address;\n");
        NativeFuncRenderer nativeFuncRenderer = $this$nativeFunc;
        nativeFuncRenderer.setBody(nativeFuncRenderer.getBody() + valueReceiver + arrayValueMod + " = " + natType.castJniToNative("value") + ";\n");
        renderer$iv.renderTo((Writer)$this$nativeFunc$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSizeOf(IdlInterface $this$generateSizeOf, Writer w) {
        void $this$nativeFunc$iv;
        NativeFuncRenderer renderer$iv;
        Writer writer = w;
        JniNativeGenerator this_$iv = this;
        boolean $i$f$nativeFunc = false;
        NativeFuncRenderer $this$nativeFunc = renderer$iv = new NativeFuncRenderer();
        boolean bl = false;
        $this$nativeFunc.setReturnType("jint");
        $this$nativeFunc.setFunctionName(JniNativeGenerator.nativeFunName$default(this, $this$generateSizeOf.getSourcePackage(), $this$generateSizeOf.getName(), "_sizeOf", null, 8, null));
        $this$nativeFunc.setReceivingAddress(false);
        $this$nativeFunc.setBody("return sizeof(" + $this$generateSizeOf.getDecoratorValue("Prefix", "") + $this$generateSizeOf.getName() + ");");
        renderer$iv.renderTo((Writer)$this$nativeFunc$iv);
    }

    private final String nativeFunName(IdlInterface idlIf, IdlAttribute attrib, String funPrefix) {
        return JniNativeGenerator.nativeFunName$default(this, idlIf.getSourcePackage(), idlIf.getName(), funPrefix + this.firstCharToUpper(attrib.getName()), null, 8, null);
    }

    private final String nativeFunName(String srcPkg, String className, String functionName, String nameSuffix) {
        String name = this.packagePrefix;
        CharSequence charSequence = name;
        boolean bl = false;
        if (charSequence.length() > 0) {
            name = name + ".";
        }
        name = name + srcPkg;
        charSequence = name;
        bl = false;
        if (charSequence.length() > 0 && !StringsKt.endsWith$default((String)name, (String)".", (boolean)false, (int)2, null)) {
            name = name + ".";
        }
        name = name + className + "._" + functionName;
        name = StringsKt.replace$default((String)name, (String)"_", (String)"_1", (boolean)false, (int)4, null);
        name = StringsKt.replace$default((String)name, (String)".", (String)"_", (boolean)false, (int)4, null);
        return "Java_" + name + nameSuffix;
    }

    static /* synthetic */ String nativeFunName$default(JniNativeGenerator jniNativeGenerator, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "";
        }
        return jniNativeGenerator.nativeFunName(string, string2, string3, string4);
    }

    private final String getFunctionSuffix(IdlFunction $this$getFunctionSuffix, boolean isOverloaded, boolean isCtor) {
        String string;
        if (!isOverloaded) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("__");
            boolean bl = !$this$getFunctionSuffix.isStatic() && !isCtor;
            IdlModel idlModel = this.model;
            if (idlModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            }
            string = stringBuilder.append(JavaTypeSignature.INSTANCE.getFunctionTypeSuffix($this$getFunctionSuffix, bl, idlModel)).toString();
        }
        return string;
    }

    static /* synthetic */ String getFunctionSuffix$default(JniNativeGenerator jniNativeGenerator, IdlFunction idlFunction, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return jniNativeGenerator.getFunctionSuffix(idlFunction, bl, bl2);
    }

    private final void nativeFunc(Writer $this$nativeFunc, Function1<? super NativeFuncRenderer, Unit> block) {
        int $i$f$nativeFunc = 0;
        NativeFuncRenderer renderer = new NativeFuncRenderer();
        block.invoke((Object)renderer);
        renderer.renderTo($this$nativeFunc);
    }

    public JniNativeGenerator() {
        boolean bl = false;
        this.externallyAllocatableClasses = new LinkedHashSet();
        this.setOutputDirectory("./generated/native");
    }

    public static final /* synthetic */ IdlModel access$getModel$p(JniNativeGenerator $this) {
        IdlModel idlModel = $this.model;
        if (idlModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
        }
        return idlModel;
    }

    public static final /* synthetic */ void access$setModel$p(JniNativeGenerator $this, IdlModel idlModel) {
        $this.model = idlModel;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u001a\u0010\u001c\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\b\u00a8\u0006$"}, d2={"Lde/fabmax/webidl/generator/jni/nat/JniNativeGenerator$NativeFuncRenderer;", "", "()V", "body", "", "getBody", "()Ljava/lang/String;", "setBody", "(Ljava/lang/String;)V", "extraArgs", "getExtraArgs", "setExtraArgs", "functionName", "getFunctionName", "setFunctionName", "isReceivingAddress", "", "()Z", "setReceivingAddress", "(Z)V", "isReceivingArrayIndex", "setReceivingArrayIndex", "isStaticJava", "setStaticJava", "isUsingEnv", "setUsingEnv", "isUsingJavaRef", "setUsingJavaRef", "returnType", "getReturnType", "setReturnType", "renderTo", "", "w", "Ljava/io/Writer;", "Companion", "webidl-util"})
    public static final class NativeFuncRenderer {
        @NotNull
        private String returnType = "void";
        @NotNull
        private String functionName = "";
        private boolean isUsingEnv;
        private boolean isStaticJava = true;
        private boolean isUsingJavaRef;
        private boolean isReceivingAddress = true;
        private boolean isReceivingArrayIndex;
        @NotNull
        private String extraArgs = "";
        @NotNull
        private String body = "";
        @NotNull
        public static final String ENV = "_env";
        @NotNull
        public static final String JAVA_REF = "_javaRef";
        @NotNull
        public static final String ADDRESS = "_address";
        @NotNull
        public static final String ARRAY_INDEX = "_index";
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getReturnType() {
            return this.returnType;
        }

        public final void setReturnType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.returnType = string;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.functionName = string;
        }

        public final boolean isUsingEnv() {
            return this.isUsingEnv;
        }

        public final void setUsingEnv(boolean bl) {
            this.isUsingEnv = bl;
        }

        public final boolean isStaticJava() {
            return this.isStaticJava;
        }

        public final void setStaticJava(boolean bl) {
            this.isStaticJava = bl;
        }

        public final boolean isUsingJavaRef() {
            return this.isUsingJavaRef;
        }

        public final void setUsingJavaRef(boolean bl) {
            this.isUsingJavaRef = bl;
        }

        public final boolean isReceivingAddress() {
            return this.isReceivingAddress;
        }

        public final void setReceivingAddress(boolean bl) {
            this.isReceivingAddress = bl;
        }

        public final boolean isReceivingArrayIndex() {
            return this.isReceivingArrayIndex;
        }

        public final void setReceivingArrayIndex(boolean bl) {
            this.isReceivingArrayIndex = bl;
        }

        @NotNull
        public final String getExtraArgs() {
            return this.extraArgs;
        }

        public final void setExtraArgs(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.extraArgs = string;
        }

        @NotNull
        public final String getBody() {
            return this.body;
        }

        public final void setBody(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.body = string;
        }

        public final void renderTo(@NotNull Writer w) {
            Intrinsics.checkNotNullParameter((Object)w, (String)"w");
            String envArg = this.isUsingEnv ? "JNIEnv* _env" : "JNIEnv*";
            String javaRef = this.isStaticJava ? "jclass" : "jobject";
            String javaRefArg = this.isUsingJavaRef ? javaRef + " _javaRef" : javaRef;
            String addrArg = this.isReceivingAddress ? ", jlong _address" : "";
            String arrayIndexArg = this.isReceivingArrayIndex ? ", jint _index" : "";
            w.append("JNIEXPORT " + this.returnType + " JNICALL " + this.functionName + '(' + envArg + ", " + javaRefArg + addrArg + arrayIndexArg + this.extraArgs + ") {\n");
            w.append(CodeGeneratorKt.prependIndent(StringsKt.trimIndent((String)this.body), 4));
            w.append("\n}\n");
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fabmax/webidl/generator/jni/nat/JniNativeGenerator$NativeFuncRenderer$Companion;", "", "()V", "ADDRESS", "", "ARRAY_INDEX", "ENV", "JAVA_REF", "webidl-util"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

