/*
 * Decompiled with CFR 0.152.
 */
package de.fabmax.webidl.model;

import de.fabmax.webidl.model.IdlEnum;
import de.fabmax.webidl.model.IdlModel;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0005J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lde/fabmax/webidl/model/IdlType;", "", "typeName", "", "isArray", "", "(Ljava/lang/String;Z)V", "isAny", "()Z", "isAnyOrVoidPtr", "isComplexType", "isPrimitive", "isString", "isVoid", "isVoidPtr", "getTypeName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "isEnum", "model", "Lde/fabmax/webidl/model/IdlModel;", "isValid", "toString", "Companion", "webidl-util"})
public final class IdlType {
    private final boolean isVoid;
    private final boolean isString;
    private final boolean isVoidPtr;
    private final boolean isAny;
    private final boolean isAnyOrVoidPtr;
    private final boolean isPrimitive;
    private final boolean isComplexType;
    @NotNull
    private final String typeName;
    private final boolean isArray;
    private static final Set<String> basicTypes;
    private static final Regex interfaceNameRegex;
    @NotNull
    public static final Companion Companion;

    public final boolean isVoid() {
        return this.isVoid;
    }

    public final boolean isString() {
        return this.isString;
    }

    public final boolean isVoidPtr() {
        return this.isVoidPtr;
    }

    public final boolean isAny() {
        return this.isAny;
    }

    public final boolean isAnyOrVoidPtr() {
        return this.isAnyOrVoidPtr;
    }

    public final boolean isPrimitive() {
        return this.isPrimitive;
    }

    public final boolean isComplexType() {
        return this.isComplexType;
    }

    public final boolean isEnum(@NotNull IdlModel model) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Iterable $this$any$iv = model.getEnums();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IdlEnum it = (IdlEnum)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.typeName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isValid() {
        return Companion.isValidTypeName(this.typeName);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(this.typeName);
        if (this.isArray) {
            sb.append("[]");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final String getTypeName() {
        return this.typeName;
    }

    public final boolean isArray() {
        return this.isArray;
    }

    public IdlType(@NotNull String typeName, boolean isArray) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        this.typeName = typeName;
        this.isArray = isArray;
        this.isVoid = Intrinsics.areEqual((Object)this.typeName, (Object)"void");
        this.isString = Intrinsics.areEqual((Object)this.typeName, (Object)"DOMString");
        this.isVoidPtr = Intrinsics.areEqual((Object)this.typeName, (Object)"VoidPtr");
        this.isAny = Intrinsics.areEqual((Object)this.typeName, (Object)"any");
        this.isAnyOrVoidPtr = this.isVoidPtr || this.isAny;
        this.isPrimitive = basicTypes.contains(this.typeName) && !this.isAnyOrVoidPtr;
        this.isComplexType = !this.isPrimitive && !this.isAnyOrVoidPtr;
    }

    static {
        Companion = new Companion(null);
        basicTypes = SetsKt.setOf((Object[])new String[]{"boolean", "float", "double", "byte", "DOMString", "octet", "short", "long", "long long", "unsigned short", "unsigned long", "unsigned long long", "void", "any", "VoidPtr"});
        interfaceNameRegex = new Regex("[a-zA-Z_]\\w*");
    }

    @NotNull
    public final String component1() {
        return this.typeName;
    }

    public final boolean component2() {
        return this.isArray;
    }

    @NotNull
    public final IdlType copy(@NotNull String typeName, boolean isArray) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return new IdlType(typeName, isArray);
    }

    public static /* synthetic */ IdlType copy$default(IdlType idlType, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = idlType.typeName;
        }
        if ((n & 2) != 0) {
            bl = idlType.isArray;
        }
        return idlType.copy(string, bl);
    }

    public int hashCode() {
        String string = this.typeName;
        int n = (string != null ? string.hashCode() : 0) * 31;
        int n2 = this.isArray ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof IdlType)) break block3;
                IdlType idlType = (IdlType)object;
                if (!Intrinsics.areEqual((Object)this.typeName, (Object)idlType.typeName) || this.isArray != idlType.isArray) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/fabmax/webidl/model/IdlType$Companion;", "", "()V", "basicTypes", "", "", "interfaceNameRegex", "Lkotlin/text/Regex;", "isValidTypeName", "", "typeName", "startsWithType", "line", "webidl-util"})
    public static final class Companion {
        public final boolean isValidTypeName(@NotNull String typeName) {
            String string;
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            if (StringsKt.endsWith$default((String)typeName, (String)"[]", (boolean)false, (int)2, null)) {
                String string2 = typeName;
                int n = 0;
                int n2 = typeName.length() - 2;
                boolean bl = false;
                String string3 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string2 = string3;
                n = 0;
                String string4 = string2;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            } else {
                string = typeName;
            }
            String nonArrayType = string;
            return basicTypes.contains(nonArrayType) || interfaceNameRegex.matches((CharSequence)nonArrayType);
        }

        public final boolean startsWithType(@NotNull String line) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                Iterable $this$any$iv = basicTypes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)line, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            MatchResult matchResult = Regex.find$default((Regex)interfaceNameRegex, (CharSequence)line, (int)0, (int)2, null);
            return matchResult != null && (matchResult = matchResult.getRange()) != null && 0 == matchResult.getStart();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

