/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;
import java.util.List;

public class TypeListItem
extends BaseItem
implements Comparable<TypeListItem> {
    public final List<TypeIdItem> items;

    public TypeListItem(List<TypeIdItem> items) {
        this.items = items;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeListItem other = (TypeListItem)obj;
        if (this.items == null) {
            return other.items == null;
        }
        return this.items.equals(other.items);
    }

    @Override
    public int place(int offset) {
        return offset + 4 + this.items.size() * 2;
    }

    @Override
    public void write(DataOut out) {
        out.uint("size", this.items.size());
        for (TypeIdItem idItem : this.items) {
            out.ushort("type_idx", idItem.index);
        }
    }

    @Override
    public int compareTo(TypeListItem o) {
        int min = Math.min(this.items.size(), o.items.size());
        for (int i = 0; i < min; ++i) {
            int x = this.items.get(i).compareTo(o.items.get(i));
            if (x == 0) continue;
            return x;
        }
        return Integer.compare(this.items.size(), o.items.size());
    }
}

