/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.ev.EncodedValue;
import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.AnnotationSetItem;
import com.googlecode.d2j.dex.writer.item.AnnotationSetRefListItem;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.CodeItem;
import com.googlecode.d2j.dex.writer.item.ConstPool;
import com.googlecode.d2j.dex.writer.item.FieldIdItem;
import com.googlecode.d2j.dex.writer.item.MethodIdItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ClassDataItem
extends BaseItem {
    public final List<EncodedField> staticFields = new ArrayList<EncodedField>(5);
    public final List<EncodedField> instanceFields = new ArrayList<EncodedField>(5);
    public final List<EncodedMethod> directMethods = new ArrayList<EncodedMethod>(5);
    public final List<EncodedMethod> virtualMethods = new ArrayList<EncodedMethod>(5);

    @Override
    public int place(int offset) {
        offset += ClassDataItem.lengthOfUleb128(this.staticFields.size());
        offset += ClassDataItem.lengthOfUleb128(this.instanceFields.size());
        offset += ClassDataItem.lengthOfUleb128(this.directMethods.size());
        offset += ClassDataItem.lengthOfUleb128(this.virtualMethods.size());
        offset = this.placeField(offset, this.staticFields);
        offset = this.placeField(offset, this.instanceFields);
        offset = this.placeMethod(offset, this.directMethods);
        offset = this.placeMethod(offset, this.virtualMethods);
        return offset;
    }

    private int placeMethod(int offset, List<EncodedMethod> methods) {
        if (methods.isEmpty()) {
            return offset;
        }
        int lastIdx = 0;
        for (EncodedMethod f : methods) {
            offset += ClassDataItem.lengthOfUleb128(f.method.index - lastIdx);
            offset += ClassDataItem.lengthOfUleb128(f.accessFlags);
            offset += ClassDataItem.lengthOfUleb128(f.code == null ? 0 : f.code.offset);
            lastIdx = f.method.index;
        }
        return offset;
    }

    private int placeField(int offset, List<EncodedField> fields) {
        if (fields.isEmpty()) {
            return offset;
        }
        int lastIdx = 0;
        for (EncodedField f : fields) {
            offset += ClassDataItem.lengthOfUleb128(f.field.index - lastIdx);
            offset += ClassDataItem.lengthOfUleb128(f.accessFlags);
            lastIdx = f.field.index;
        }
        return offset;
    }

    @Override
    public void write(DataOut out) {
        out.uleb128("static_fields_size", this.staticFields.size());
        out.uleb128("instance_fields_size", this.instanceFields.size());
        out.uleb128("ditect_methods_size", this.directMethods.size());
        out.uleb128("virtual_methods_size", this.virtualMethods.size());
        this.writeField(out, this.staticFields);
        this.writeField(out, this.instanceFields);
        this.writeMethod(out, this.directMethods);
        this.writeMethod(out, this.virtualMethods);
    }

    private void writeMethod(DataOut out, List<EncodedMethod> methods) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        int lastIdx = 0;
        for (EncodedMethod f : methods) {
            out.uleb128("method_idx_diff", f.method.index - lastIdx);
            out.uleb128("access_flags", f.accessFlags);
            out.uleb128("code_off", f.code == null ? 0 : f.code.offset);
            lastIdx = f.method.index;
        }
    }

    private void writeField(DataOut out, List<EncodedField> fields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        int lastIdx = 0;
        for (EncodedField f : fields) {
            out.uleb128("field_idx_diff", f.field.index - lastIdx);
            out.uleb128("access_flags", f.accessFlags);
            lastIdx = f.field.index;
        }
    }

    public int getMemberSize() {
        return this.instanceFields.size() + this.staticFields.size() + this.directMethods.size() + this.virtualMethods.size();
    }

    public void prepare(ConstPool cp) {
        Comparator<EncodedField> fc = Comparator.comparing(arg0 -> arg0.field);
        Comparator<EncodedMethod> mc = Comparator.comparing(arg0 -> arg0.method);
        this.instanceFields.sort(fc);
        this.staticFields.sort(fc);
        this.directMethods.sort(mc);
        this.virtualMethods.sort(mc);
    }

    public static class EncodedMethod {
        public int accessFlags;
        public MethodIdItem method;
        public CodeItem code;
        public AnnotationSetItem annotationSetItem;
        public AnnotationSetRefListItem parameterAnnotation;
    }

    public static class EncodedField {
        public int accessFlags;
        public FieldIdItem field;
        public EncodedValue staticValue;
        public AnnotationSetItem annotationSetItem;
    }
}

