/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.camel.idscp2;

import com.github.jsonldjava.shaded.com.google.common.collect.MapMaker;
import de.fhg.aisec.ids.camel.idscp2.Utils;
import de.fhg.aisec.ids.idscp2.app_layer.AppLayerConnection;
import de.fraunhofer.iais.eis.ContractAgreement;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.camel.Exchange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\rJ\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\tJ\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\tJ\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/UsageControlMaps;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "connectionContracts", "", "Lde/fhg/aisec/ids/idscp2/app_layer/AppLayerConnection;", "Ljava/net/URI;", "contractMap", "Lde/fraunhofer/iais/eis/ContractAgreement;", "exchangeConnectionMap", "Lorg/apache/camel/Exchange;", "protectedBodies", "addContractAgreement", "", "contractAgreement", "getExchangeContract", "exchange", "isProtected", "", "protectBody", "contractUri", "setConnectionContract", "connection", "setExchangeConnection", "unprotectBody", "camel-idscp2"})
public final class UsageControlMaps {
    @NotNull
    public static final UsageControlMaps INSTANCE = new UsageControlMaps();
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    @NotNull
    private static final Map<URI, ContractAgreement> contractMap;
    @NotNull
    private static final Map<Exchange, AppLayerConnection> exchangeConnectionMap;
    @NotNull
    private static final Map<AppLayerConnection, URI> connectionContracts;
    @NotNull
    private static final Map<Exchange, Object> protectedBodies;

    private UsageControlMaps() {
    }

    @Nullable
    public final ContractAgreement getExchangeContract(@NotNull Exchange exchange) {
        ContractAgreement contractAgreement;
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        AppLayerConnection appLayerConnection = exchangeConnectionMap.get(exchange);
        if (appLayerConnection == null) {
            contractAgreement = null;
        } else {
            AppLayerConnection appLayerConnection2 = appLayerConnection;
            boolean bl = false;
            boolean bl2 = false;
            AppLayerConnection connection = appLayerConnection2;
            boolean bl3 = false;
            URI uRI = connectionContracts.get(connection);
            if (uRI == null) {
                contractAgreement = null;
            } else {
                URI uRI2 = uRI;
                boolean bl4 = false;
                boolean bl5 = false;
                URI uri = uRI2;
                boolean bl6 = false;
                ContractAgreement contractAgreement2 = contractMap.get(uri);
                if (contractAgreement2 == null) {
                    throw new RuntimeException("Contract " + uri + " is not available!");
                }
                contractAgreement = contractAgreement2;
            }
        }
        return contractAgreement;
    }

    public final void protectBody(@NotNull Exchange exchange, @NotNull URI contractUri) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)contractUri, (String)"contractUri");
        Map<Exchange, Object> map = protectedBodies;
        Object object = exchange.getMessage().getBody();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"exchange.message.body");
        boolean bl = false;
        map.put(exchange, object);
        exchange.getMessage().setBody((Object)("### Usage control protected body, contract " + contractUri + " ###"));
    }

    public final boolean isProtected(@NotNull Exchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        return protectedBodies.containsKey(exchange);
    }

    public final void unprotectBody(@NotNull Exchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        exchange.getMessage().setBody(protectedBodies.get(exchange));
        UsageControlMaps usageControlMaps = this;
        Map<Exchange, Object> map = protectedBodies;
        boolean bl = false;
        map.remove(exchange);
    }

    public final void addContractAgreement(@NotNull ContractAgreement contractAgreement) {
        Intrinsics.checkNotNullParameter((Object)contractAgreement, (String)"contractAgreement");
        Map<URI, ContractAgreement> map = contractMap;
        URI uRI = contractAgreement.getId();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"contractAgreement.id");
        boolean bl = false;
        map.put(uRI, contractAgreement);
    }

    public final void setConnectionContract(@NotNull AppLayerConnection connection, @Nullable URI contractUri) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (contractUri != null) {
            Map<AppLayerConnection, URI> map = connectionContracts;
            boolean bl = false;
            map.put(connection, contractUri);
            if (LOG.isDebugEnabled()) {
                LOG.debug("UC: Assigned contract " + contractUri + " to connection " + connection);
            }
        } else {
            UsageControlMaps usageControlMaps = this;
            Map<AppLayerConnection, URI> map = connectionContracts;
            boolean bl = false;
            map.remove(connection);
            if (LOG.isDebugEnabled()) {
                LOG.debug("UC: Assigned no contract to connection " + connection);
            }
        }
    }

    public final void setExchangeConnection(@NotNull Exchange exchange, @NotNull AppLayerConnection connection) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Map<Exchange, AppLayerConnection> map = exchangeConnectionMap;
        boolean bl = false;
        map.put(exchange, connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("UC: Assigned exchange " + exchange + " to connection " + connection);
        }
    }

    static {
        ConcurrentMap concurrentMap = new MapMaker().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"MapMaker().makeMap()");
        contractMap = concurrentMap;
        concurrentMap = new MapMaker().weakKeys().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"MapMaker().weakKeys().makeMap()");
        exchangeConnectionMap = concurrentMap;
        concurrentMap = new MapMaker().weakKeys().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"MapMaker().weakKeys().makeMap()");
        connectionContracts = concurrentMap;
        concurrentMap = new MapMaker().weakKeys().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"MapMaker().weakKeys().makeMap()");
        protectedBodies = concurrentMap;
    }
}

