/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.camel.idscp2.client;

import de.fhg.aisec.ids.camel.idscp2.RefCountingHashMap;
import de.fhg.aisec.ids.camel.idscp2.UsageControlMaps;
import de.fhg.aisec.ids.camel.idscp2.Utils;
import de.fhg.aisec.ids.camel.idscp2.client.Idscp2ClientComponent;
import de.fhg.aisec.ids.camel.idscp2.client.Idscp2ClientConsumer;
import de.fhg.aisec.ids.camel.idscp2.client.Idscp2ClientEndpoint;
import de.fhg.aisec.ids.camel.idscp2.client.Idscp2ClientProducer;
import de.fhg.aisec.ids.idscp2.app_layer.AppLayerConnection;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.AisecDapsDriver;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.AisecDapsDriverConfig;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.NativeTLSDriver;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureChannelDriver;
import de.fraunhofer.iais.eis.Message;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@UriEndpoint(scheme="idscp2client", syntax="idscp2client://host:port", title="IDSCP2 Client Socket", label="ids")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 T2\u00020\u0001:\u0001TB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020MH\u0016J\f\u0010O\u001a\b\u0012\u0004\u0012\u0002070PJ\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u0002070PH\u0002J\u0014\u0010R\u001a\u00020M2\f\u0010S\u001a\b\u0012\u0004\u0012\u0002070PR\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\"\u0010\u0018\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001f\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0012\"\u0004\b'\u0010\u0014R\u001e\u0010(\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010-\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u001e\u00100\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010*\"\u0004\b2\u0010,R\u000e\u00103\u001a\u000204X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020406X\u0082.\u00a2\u0006\u0002\n\u0000R&\u00108\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b9\u0010:\u001a\u0004\b;\u0010\"\"\u0004\b<\u0010$R\u001e\u0010=\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0012\"\u0004\b?\u0010\u0014R \u0010@\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\"\"\u0004\bB\u0010$R\u001e\u0010C\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u000b\"\u0004\bE\u0010\r\u00a8\u0006U"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/client/Idscp2ClientEndpoint;", "Lorg/apache/camel/support/DefaultEndpoint;", "uri", "", "remaining", "component", "Lde/fhg/aisec/ids/camel/idscp2/client/Idscp2ClientComponent;", "(Ljava/lang/String;Ljava/lang/String;Lde/fhg/aisec/ids/camel/idscp2/client/Idscp2ClientComponent;)V", "awaitResponse", "", "getAwaitResponse", "()Z", "setAwaitResponse", "(Z)V", "clientConfiguration", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;", "connectionShareId", "getConnectionShareId", "()Ljava/lang/String;", "setConnectionShareId", "(Ljava/lang/String;)V", "dapsKeyAlias", "getDapsKeyAlias", "setDapsKeyAlias", "dapsRatTimeoutDelay", "", "getDapsRatTimeoutDelay", "()Ljava/lang/Long;", "setDapsRatTimeoutDelay", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "dapsSslContextParameters", "Lorg/apache/camel/support/jsse/SSLContextParameters;", "getDapsSslContextParameters", "()Lorg/apache/camel/support/jsse/SSLContextParameters;", "setDapsSslContextParameters", "(Lorg/apache/camel/support/jsse/SSLContextParameters;)V", "expectedRatSuites", "getExpectedRatSuites", "setExpectedRatSuites", "maxRetries", "getMaxRetries", "()J", "setMaxRetries", "(J)V", "responseTimeout", "getResponseTimeout", "setResponseTimeout", "retryDelayMs", "getRetryDelayMs", "setRetryDelayMs", "secureChannelConfig", "Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTlsConfiguration;", "secureChannelDriver", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelDriver;", "Lde/fhg/aisec/ids/idscp2/app_layer/AppLayerConnection;", "sslContextParameters", "getSslContextParameters$annotations", "()V", "getSslContextParameters", "setSslContextParameters", "supportedRatSuites", "getSupportedRatSuites", "setSupportedRatSuites", "transportSslContextParameters", "getTransportSslContextParameters", "setTransportSslContextParameters", "useIdsMessages", "getUseIdsMessages", "setUseIdsMessages", "createConsumer", "Lorg/apache/camel/Consumer;", "processor", "Lorg/apache/camel/Processor;", "createProducer", "Lorg/apache/camel/Producer;", "doStart", "", "doStop", "makeConnection", "Ljava/util/concurrent/CompletableFuture;", "makeConnectionInternal", "releaseConnection", "connectionFuture", "Companion", "camel-idscp2"})
public final class Idscp2ClientEndpoint
extends DefaultEndpoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String remaining;
    private SecureChannelDriver<AppLayerConnection, NativeTlsConfiguration> secureChannelDriver;
    private Idscp2Configuration clientConfiguration;
    private NativeTlsConfiguration secureChannelConfig;
    @UriParam(description="The transport encryption SSL context for the IDSCP2 endpoint", label="security")
    @Nullable
    private SSLContextParameters transportSslContextParameters;
    @UriParam(description="The DAPS authentication SSL context for the IDSCP2 endpoint", label="security")
    @Nullable
    private SSLContextParameters dapsSslContextParameters;
    @UriParam(description="The SSL context for the IDSCP2 endpoint (deprecated)", label="security")
    @Nullable
    private SSLContextParameters sslContextParameters;
    @UriParam(description="The alias of the DAPS key in the keystore provided by sslContextParameters", label="security")
    @Nullable
    private String dapsKeyAlias;
    @UriParam(defaultValue="600000", description="The validity time of remote attestation and DAT in milliseconds", label="security")
    @Nullable
    private Long dapsRatTimeoutDelay;
    @UriParam(description="Used to make N endpoints share the same connection, e.g. for using a consumer to receive responses to the requests of another producer", label="client")
    @Nullable
    private String connectionShareId;
    @UriParam(description="Makes the client producer block and wait for a reply message from the server", label="client,producer")
    private boolean awaitResponse;
    @UriParam(defaultValue="false", description="Enable IdsMessage headers (Required for Usage Control)", label="common")
    private boolean useIdsMessages;
    @UriParam(defaultValue="Dummy", description="Locally supported Remote Attestation Suite IDs, separated by \"|\"", label="common")
    @NotNull
    private String supportedRatSuites;
    @UriParam(defaultValue="Dummy", description="Expected Remote Attestation Suite IDs, separated by \"|\", each communication peer must support at least one", label="common")
    @NotNull
    private String expectedRatSuites;
    @UriParam(defaultValue="3", description="Max attempts to connect to the IDSCP2 server", label="client")
    private long maxRetries;
    @UriParam(defaultValue="5000", description="Delay after an failed connection attempt to the server, in milliseconds", label="client")
    private long retryDelayMs;
    @UriParam(defaultValue="5000", description="Timeout when waiting for a response, in milliseconds", label="client")
    private long responseTimeout;
    private static final Logger LOG = LoggerFactory.getLogger(Idscp2ClientEndpoint.class);
    private static final Pattern URI_REGEX = Pattern.compile("(.*?)(?::(\\d+))?/?$");
    @NotNull
    private static final RefCountingHashMap<String, CompletableFuture<AppLayerConnection>> sharedConnections = new RefCountingHashMap(Companion.sharedConnections.1.INSTANCE);

    public Idscp2ClientEndpoint(@Nullable String uri, @NotNull String remaining, @Nullable Idscp2ClientComponent component) {
        Intrinsics.checkNotNullParameter((Object)remaining, (String)"remaining");
        super(uri, (Component)component);
        this.remaining = remaining;
        this.supportedRatSuites = "Dummy";
        this.expectedRatSuites = "Dummy";
        this.maxRetries = 3L;
        this.retryDelayMs = 5000L;
        this.responseTimeout = 5000L;
    }

    @Nullable
    public final SSLContextParameters getTransportSslContextParameters() {
        return this.transportSslContextParameters;
    }

    public final void setTransportSslContextParameters(@Nullable SSLContextParameters sSLContextParameters) {
        this.transportSslContextParameters = sSLContextParameters;
    }

    @Nullable
    public final SSLContextParameters getDapsSslContextParameters() {
        return this.dapsSslContextParameters;
    }

    public final void setDapsSslContextParameters(@Nullable SSLContextParameters sSLContextParameters) {
        this.dapsSslContextParameters = sSLContextParameters;
    }

    @Nullable
    public final SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public final void setSslContextParameters(@Nullable SSLContextParameters sSLContextParameters) {
        this.sslContextParameters = sSLContextParameters;
    }

    @Deprecated(message="Depreacted in favor of transportSslContextParameters and dapsSslContextParameters")
    public static /* synthetic */ void getSslContextParameters$annotations() {
    }

    @Nullable
    public final String getDapsKeyAlias() {
        return this.dapsKeyAlias;
    }

    public final void setDapsKeyAlias(@Nullable String string) {
        this.dapsKeyAlias = string;
    }

    @Nullable
    public final Long getDapsRatTimeoutDelay() {
        return this.dapsRatTimeoutDelay;
    }

    public final void setDapsRatTimeoutDelay(@Nullable Long l) {
        this.dapsRatTimeoutDelay = l;
    }

    @Nullable
    public final String getConnectionShareId() {
        return this.connectionShareId;
    }

    public final void setConnectionShareId(@Nullable String string) {
        this.connectionShareId = string;
    }

    public final boolean getAwaitResponse() {
        return this.awaitResponse;
    }

    public final void setAwaitResponse(boolean bl) {
        this.awaitResponse = bl;
    }

    public final boolean getUseIdsMessages() {
        return this.useIdsMessages;
    }

    public final void setUseIdsMessages(boolean bl) {
        this.useIdsMessages = bl;
    }

    @NotNull
    public final String getSupportedRatSuites() {
        return this.supportedRatSuites;
    }

    public final void setSupportedRatSuites(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.supportedRatSuites = string;
    }

    @NotNull
    public final String getExpectedRatSuites() {
        return this.expectedRatSuites;
    }

    public final void setExpectedRatSuites(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.expectedRatSuites = string;
    }

    public final long getMaxRetries() {
        return this.maxRetries;
    }

    public final void setMaxRetries(long l) {
        this.maxRetries = l;
    }

    public final long getRetryDelayMs() {
        return this.retryDelayMs;
    }

    public final void setRetryDelayMs(long l) {
        this.retryDelayMs = l;
    }

    public final long getResponseTimeout() {
        return this.responseTimeout;
    }

    public final void setResponseTimeout(long l) {
        this.responseTimeout = l;
    }

    private final CompletableFuture<AppLayerConnection> makeConnectionInternal() {
        Idscp2Configuration idscp2Configuration = this.secureChannelDriver;
        if (idscp2Configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secureChannelDriver");
            throw null;
        }
        Idscp2Configuration idscp2Configuration2 = idscp2Configuration;
        idscp2Configuration = this.clientConfiguration;
        if (idscp2Configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientConfiguration");
            throw null;
        }
        Idscp2Configuration idscp2Configuration3 = idscp2Configuration;
        idscp2Configuration = this.secureChannelConfig;
        if (idscp2Configuration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secureChannelConfig");
            throw null;
        }
        CompletionStage completionStage = idscp2Configuration2.connect((Function2)makeConnectionInternal.1.INSTANCE, idscp2Configuration3, (Object)idscp2Configuration).thenApply(arg_0 -> Idscp2ClientEndpoint.makeConnectionInternal$lambda-2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"secureChannelDriver.connect(::AppLayerConnection, clientConfiguration, secureChannelConfig)\n            .thenApply { c ->\n                if (useIdsMessages) {\n                    c.addIdsMessageListener { connection, header, _ ->\n                        header?.let { UsageControlMaps.setConnectionContract(connection, it.transferContract) }\n                    }\n                }\n                c\n            }");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<AppLayerConnection> makeConnection() {
        String string = this.connectionShareId;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            return sharedConnections.computeIfAbsent(it, (Function1<String, CompletableFuture<AppLayerConnection>>)((Function1)new Function1<String, CompletableFuture<AppLayerConnection>>(this){
                final /* synthetic */ Idscp2ClientEndpoint this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CompletableFuture<AppLayerConnection> invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Idscp2ClientEndpoint.access$makeConnectionInternal(this.this$0);
                }
            }));
        }
        Object var1_7 = null;
        return this.makeConnectionInternal();
    }

    public final void releaseConnection(@NotNull CompletableFuture<AppLayerConnection> connectionFuture) {
        Unit unit;
        Unit unit2;
        Intrinsics.checkNotNullParameter(connectionFuture, (String)"connectionFuture");
        String string = this.connectionShareId;
        if (string == null) {
            unit2 = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            sharedConnections.release(it);
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            Idscp2ClientEndpoint.Companion.releaseConnectionInternal(connectionFuture);
        }
    }

    @NotNull
    public Producer createProducer() {
        return (Producer)new Idscp2ClientProducer(this);
    }

    @NotNull
    public Consumer createConsumer(@NotNull Processor processor) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        return (Consumer)new Idscp2ClientConsumer(this, processor);
    }

    public void doStart() {
        boolean bl;
        Object object;
        boolean bl2;
        String string;
        Object object2;
        SSLContextParameters it;
        boolean bl3;
        boolean bl4;
        SSLContextParameters sSLContextParameters;
        long l;
        int n;
        LOG.debug("Starting IDSCP2 client endpoint " + this.getEndpointUri());
        Matcher remainingMatcher = URI_REGEX.matcher(this.remaining);
        boolean bl5 = remainingMatcher.matches();
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl5) {
            boolean bl8 = false;
            String string2 = this.remaining + " is not a valid URI remainder, must be \"host:port\".";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        MatchResult matchResult = remainingMatcher.toMatchResult();
        String host = matchResult.group(1);
        String bl8 = matchResult.group(2);
        if (bl8 == null) {
            n = 29292;
        } else {
            int n2;
            String string3 = bl8;
            boolean bl9 = false;
            n = n2 = Integer.parseInt(string3);
        }
        int port = n;
        char[] cArray = new char[]{'|'};
        Object $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.supportedRatSuites, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$toTypedArray$iv = new char[1];
        $this$toTypedArray$iv[0] = 124;
        $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.expectedRatSuites, (char[])$this$toTypedArray$iv, (boolean)false, (int)0, (int)6, null);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        AttestationConfig.Builder builder = new AttestationConfig.Builder().setSupportedRatSuite(stringArray).setExpectedRatSuite(stringArray2);
        $this$toTypedArray$iv = this.dapsRatTimeoutDelay;
        if ($this$toTypedArray$iv == null) {
            String $i$f$toTypedArray2 = "3600000";
            boolean bl10 = false;
            l = Long.parseLong($i$f$toTypedArray2);
        } else {
            l = (Long)$this$toTypedArray$iv;
        }
        AttestationConfig localAttestationConfig = builder.setRatTimeoutDelay(l).build();
        String $i$f$toTypedArray2 = this.dapsKeyAlias;
        AisecDapsDriverConfig.Builder dapsDriverConfigBuilder = new AisecDapsDriverConfig.Builder().setDapsUrl((String)Utils.INSTANCE.getDapsUrlProducer().invoke()).setKeyAlias($i$f$toTypedArray2 == null ? "1" : $i$f$toTypedArray2);
        NativeTlsConfiguration.Builder builder2 = new NativeTlsConfiguration.Builder();
        Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
        NativeTlsConfiguration.Builder secureChannelConfigBuilder = builder2.setHost(host).setServerPort(port);
        SSLContextParameters sSLContextParameters2 = this.transportSslContextParameters;
        SSLContextParameters sSLContextParameters3 = sSLContextParameters = sSLContextParameters2 == null ? this.sslContextParameters : sSLContextParameters2;
        if (sSLContextParameters != null) {
            Object object3;
            char[] cArray2;
            KeyStoreParameters keyStoreParameters;
            Object object4;
            char[] cArray3;
            String string4;
            KeyStoreParameters keyStoreParameters2;
            char[] cArray4;
            char[] cArray5;
            sSLContextParameters2 = sSLContextParameters;
            bl4 = false;
            bl3 = false;
            it = sSLContextParameters2;
            boolean bl11 = false;
            object2 = it.getKeyManagers();
            if (object2 == null) {
                cArray5 = null;
            } else {
                String string5 = object2.getKeyPassword();
                if (string5 == null) {
                    cArray5 = null;
                } else {
                    string = string5;
                    bl2 = false;
                    char[] cArray6 = string.toCharArray();
                    cArray5 = cArray6;
                    Intrinsics.checkNotNullExpressionValue((Object)cArray6, (String)"(this as java.lang.String).toCharArray()");
                }
            }
            object = cArray5;
            if (object == null) {
                object2 = "password";
                boolean bl12 = false;
                char[] cArray7 = ((String)object2).toCharArray();
                cArray4 = cArray7;
                Intrinsics.checkNotNullExpressionValue((Object)cArray7, (String)"(this as java.lang.String).toCharArray()");
            } else {
                cArray4 = object;
            }
            NativeTlsConfiguration.Builder builder3 = secureChannelConfigBuilder.setKeyPassword(cArray4);
            object2 = it.getKeyManagers();
            object = Paths.get(object2 == null ? "DUMMY-FILENAME.p12" : ((keyStoreParameters2 = object2.getKeyStore()) == null ? "DUMMY-FILENAME.p12" : ((string = keyStoreParameters2.getResource()) == null ? "DUMMY-FILENAME.p12" : string)), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(it.keyManagers?.keyStore?.resource ?: \"DUMMY-FILENAME.p12\")");
            NativeTlsConfiguration.Builder builder4 = builder3.setKeyStorePath((Path)object);
            object = it.getKeyManagers();
            NativeTlsConfiguration.Builder builder5 = builder4.setKeyStoreKeyType(object == null ? "RSA" : ((object2 = object.getKeyStore()) == null ? "RSA" : ((string4 = object2.getType()) == null ? "RSA" : string4)));
            object2 = it.getKeyManagers();
            if (object2 == null) {
                cArray3 = null;
            } else {
                KeyStoreParameters keyStoreParameters3 = object2.getKeyStore();
                if (keyStoreParameters3 == null) {
                    cArray3 = null;
                } else {
                    string = keyStoreParameters3.getPassword();
                    if (string == null) {
                        cArray3 = null;
                    } else {
                        String string6 = string;
                        bl = false;
                        char[] cArray8 = string6.toCharArray();
                        cArray3 = cArray8;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray8, (String)"(this as java.lang.String).toCharArray()");
                    }
                }
            }
            object = cArray3;
            if (object == null) {
                object2 = "password";
                boolean bl13 = false;
                char[] cArray9 = ((String)object2).toCharArray();
                object4 = cArray9;
                Intrinsics.checkNotNullExpressionValue((Object)cArray9, (String)"(this as java.lang.String).toCharArray()");
            } else {
                object4 = object;
            }
            NativeTlsConfiguration.Builder builder6 = builder5.setKeyStorePassword(object4);
            object2 = it.getTrustManagers();
            object = Paths.get(object2 == null ? "DUMMY-FILENAME.p12" : ((keyStoreParameters = object2.getKeyStore()) == null ? "DUMMY-FILENAME.p12" : ((string = keyStoreParameters.getResource()) == null ? "DUMMY-FILENAME.p12" : string)), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(it.trustManagers?.keyStore?.resource ?: \"DUMMY-FILENAME.p12\")");
            NativeTlsConfiguration.Builder builder7 = builder6.setTrustStorePath((Path)object);
            object2 = it.getTrustManagers();
            if (object2 == null) {
                cArray2 = null;
            } else {
                KeyStoreParameters keyStoreParameters4 = object2.getKeyStore();
                if (keyStoreParameters4 == null) {
                    cArray2 = null;
                } else {
                    string = keyStoreParameters4.getPassword();
                    if (string == null) {
                        cArray2 = null;
                    } else {
                        String string7 = string;
                        bl = false;
                        char[] cArray10 = string7.toCharArray();
                        cArray2 = cArray10;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray10, (String)"(this as java.lang.String).toCharArray()");
                    }
                }
            }
            object = cArray2;
            if (object == null) {
                object2 = "password";
                boolean bl14 = false;
                char[] cArray11 = ((String)object2).toCharArray();
                object3 = cArray11;
                Intrinsics.checkNotNullExpressionValue((Object)cArray11, (String)"(this as java.lang.String).toCharArray()");
            } else {
                object3 = object;
            }
            object = it.getCertAlias();
            builder7.setTrustStorePassword(object3).setCertificateAlias((String)(object == null ? "1.0.1" : (Object)object));
        }
        sSLContextParameters2 = this.dapsSslContextParameters;
        SSLContextParameters sSLContextParameters4 = sSLContextParameters = sSLContextParameters2 == null ? this.sslContextParameters : sSLContextParameters2;
        if (sSLContextParameters != null) {
            Object object5;
            char[] cArray12;
            KeyStoreParameters keyStoreParameters;
            Object object6;
            char[] cArray13;
            KeyStoreParameters keyStoreParameters5;
            char[] cArray14;
            char[] cArray15;
            sSLContextParameters2 = sSLContextParameters;
            bl4 = false;
            bl3 = false;
            it = sSLContextParameters2;
            boolean bl15 = false;
            object2 = it.getKeyManagers();
            if (object2 == null) {
                cArray15 = null;
            } else {
                String string8 = object2.getKeyPassword();
                if (string8 == null) {
                    cArray15 = null;
                } else {
                    string = string8;
                    bl2 = false;
                    char[] cArray16 = string.toCharArray();
                    cArray15 = cArray16;
                    Intrinsics.checkNotNullExpressionValue((Object)cArray16, (String)"(this as java.lang.String).toCharArray()");
                }
            }
            object = cArray15;
            if (object == null) {
                object2 = "password";
                boolean bl16 = false;
                char[] cArray17 = ((String)object2).toCharArray();
                cArray14 = cArray17;
                Intrinsics.checkNotNullExpressionValue((Object)cArray17, (String)"(this as java.lang.String).toCharArray()");
            } else {
                cArray14 = object;
            }
            AisecDapsDriverConfig.Builder builder8 = dapsDriverConfigBuilder.setKeyPassword(cArray14);
            object2 = it.getKeyManagers();
            object = Paths.get(object2 == null ? "DUMMY-FILENAME.p12" : ((keyStoreParameters5 = object2.getKeyStore()) == null ? "DUMMY-FILENAME.p12" : ((string = keyStoreParameters5.getResource()) == null ? "DUMMY-FILENAME.p12" : string)), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(it.keyManagers?.keyStore?.resource ?: \"DUMMY-FILENAME.p12\")");
            AisecDapsDriverConfig.Builder builder9 = builder8.setKeyStorePath((Path)object);
            object2 = it.getKeyManagers();
            if (object2 == null) {
                cArray13 = null;
            } else {
                KeyStoreParameters keyStoreParameters6 = object2.getKeyStore();
                if (keyStoreParameters6 == null) {
                    cArray13 = null;
                } else {
                    string = keyStoreParameters6.getPassword();
                    if (string == null) {
                        cArray13 = null;
                    } else {
                        String string9 = string;
                        bl = false;
                        char[] cArray18 = string9.toCharArray();
                        cArray13 = cArray18;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray18, (String)"(this as java.lang.String).toCharArray()");
                    }
                }
            }
            object = cArray13;
            if (object == null) {
                object2 = "password";
                boolean bl17 = false;
                char[] cArray19 = ((String)object2).toCharArray();
                object6 = cArray19;
                Intrinsics.checkNotNullExpressionValue((Object)cArray19, (String)"(this as java.lang.String).toCharArray()");
            } else {
                object6 = object;
            }
            AisecDapsDriverConfig.Builder builder10 = builder9.setKeyStorePassword(object6);
            object2 = it.getTrustManagers();
            object = Paths.get(object2 == null ? "DUMMY-FILENAME.p12" : ((keyStoreParameters = object2.getKeyStore()) == null ? "DUMMY-FILENAME.p12" : ((string = keyStoreParameters.getResource()) == null ? "DUMMY-FILENAME.p12" : string)), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(it.trustManagers?.keyStore?.resource ?: \"DUMMY-FILENAME.p12\")");
            AisecDapsDriverConfig.Builder builder11 = builder10.setTrustStorePath((Path)object);
            object2 = it.getTrustManagers();
            if (object2 == null) {
                cArray12 = null;
            } else {
                KeyStoreParameters keyStoreParameters7 = object2.getKeyStore();
                if (keyStoreParameters7 == null) {
                    cArray12 = null;
                } else {
                    string = keyStoreParameters7.getPassword();
                    if (string == null) {
                        cArray12 = null;
                    } else {
                        String string10 = string;
                        bl = false;
                        char[] cArray20 = string10.toCharArray();
                        cArray12 = cArray20;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray20, (String)"(this as java.lang.String).toCharArray()");
                    }
                }
            }
            object = cArray12;
            if (object == null) {
                object2 = "password";
                boolean bl18 = false;
                char[] cArray21 = ((String)object2).toCharArray();
                object5 = cArray21;
                Intrinsics.checkNotNullExpressionValue((Object)cArray21, (String)"(this as java.lang.String).toCharArray()");
            } else {
                object5 = object;
            }
            builder11.setTrustStorePassword(object5);
        }
        this.clientConfiguration = new Idscp2Configuration.Builder().setAttestationConfig(localAttestationConfig).setDapsDriver((DapsDriver)new AisecDapsDriver(dapsDriverConfigBuilder.build())).build();
        this.secureChannelDriver = (SecureChannelDriver)new NativeTLSDriver();
        this.secureChannelConfig = secureChannelConfigBuilder.build();
    }

    public void doStop() {
        LOG.debug("Stopping IDSCP2 client endpoint " + this.getEndpointUri());
    }

    private static final void makeConnectionInternal$lambda-2$lambda-1(AppLayerConnection connection, Message header, byte[] $noName_2) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Message message = header;
        if (message != null) {
            Message message2 = message;
            boolean bl = false;
            boolean bl2 = false;
            Message it = message2;
            boolean bl3 = false;
            UsageControlMaps.INSTANCE.setConnectionContract(connection, it.getTransferContract());
        }
    }

    private static final AppLayerConnection makeConnectionInternal$lambda-2(Idscp2ClientEndpoint this$0, AppLayerConnection c) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.getUseIdsMessages()) {
            c.addIdsMessageListener(Idscp2ClientEndpoint::makeConnectionInternal$lambda-2$lambda-1);
        }
        return c;
    }

    public static final /* synthetic */ CompletableFuture access$makeConnectionInternal(Idscp2ClientEndpoint $this) {
        return $this.makeConnectionInternal();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/client/Idscp2ClientEndpoint$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "URI_REGEX", "Ljava/util/regex/Pattern;", "sharedConnections", "Lde/fhg/aisec/ids/camel/idscp2/RefCountingHashMap;", "", "Ljava/util/concurrent/CompletableFuture;", "Lde/fhg/aisec/ids/idscp2/app_layer/AppLayerConnection;", "releaseConnectionInternal", "", "connectionFuture", "camel-idscp2"})
    public static final class Companion {
        private Companion() {
        }

        private final void releaseConnectionInternal(CompletableFuture<AppLayerConnection> connectionFuture) {
            if (connectionFuture.isDone()) {
                if (!connectionFuture.isCompletedExceptionally()) {
                    connectionFuture.get().close();
                }
            } else {
                connectionFuture.cancel(true);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

