/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.camel.idscp2.processors;

import de.fhg.aisec.ids.camel.idscp2.ProviderDB;
import de.fhg.aisec.ids.camel.idscp2.Utils;
import de.fraunhofer.iais.eis.Artifact;
import de.fraunhofer.iais.eis.ArtifactBuilder;
import de.fraunhofer.iais.eis.ArtifactRequestMessage;
import de.fraunhofer.iais.eis.ArtifactResponseMessageBuilder;
import de.fraunhofer.iais.eis.RejectionMessageBuilder;
import de.fraunhofer.iais.eis.RejectionReason;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/processors/ArtifactRequestProcessor;", "Lorg/apache/camel/Processor;", "()V", "createRejectionMessage", "", "exchange", "Lorg/apache/camel/Exchange;", "artifactRequestMessage", "Lde/fraunhofer/iais/eis/ArtifactRequestMessage;", "rejectionReason", "Lde/fraunhofer/iais/eis/RejectionReason;", "process", "Companion", "camel-idscp2"})
public final class ArtifactRequestProcessor
implements Processor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactRequestProcessor.class);

    public void process(@NotNull Exchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        if (LOG.isDebugEnabled()) {
            LOG.debug("[IN] " + this.getClass().getSimpleName());
        }
        ArtifactRequestMessage artifactRequestMessage = (ArtifactRequestMessage)exchange.getMessage().getHeader("idscp2-header", ArtifactRequestMessage.class);
        URI requestedArtifact = artifactRequestMessage.getRequestedArtifact();
        URI usedContract = ProviderDB.INSTANCE.getArtifactUrisMapped2ContractAgreements().get(requestedArtifact);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Contract for requested Artifact found {}", (Object)usedContract);
        }
        if (!ProviderDB.INSTANCE.getAvailableArtifactURIs().containsKey(requestedArtifact)) {
            Intrinsics.checkNotNullExpressionValue((Object)artifactRequestMessage, (String)"artifactRequestMessage");
            this.createRejectionMessage(exchange, artifactRequestMessage, RejectionReason.NOT_FOUND);
        } else {
            Map map = ProviderDB.INSTANCE.getContractAgreements();
            boolean bl = false;
            Map map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (!map2.containsKey(usedContract)) {
                Intrinsics.checkNotNullExpressionValue((Object)artifactRequestMessage, (String)"artifactRequestMessage");
                this.createRejectionMessage(exchange, artifactRequestMessage, RejectionReason.NOT_AUTHORIZED);
            } else {
                map = new ArtifactResponseMessageBuilder();
                bl = false;
                boolean bl2 = false;
                Map $this$process_u24lambda_u2d1 = map;
                boolean bl3 = false;
                $this$process_u24lambda_u2d1._correlationMessage_(artifactRequestMessage.getId());
                $this$process_u24lambda_u2d1._transferContract_(usedContract);
                Map map3 = $this$process_u24lambda_u2d1;
                boolean bl4 = false;
                boolean bl5 = false;
                Map it = map3;
                boolean bl6 = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Serialisation header: {}", (Object)Utils.INSTANCE.getSERIALIZER().serialize((Object)it.build()));
                }
                exchange.getMessage().setHeader("idscp2-header", (Object)it);
                XMLGregorianCalendar artifactDate = Utils.INSTANCE.createGregorianCalendarTimestamp(System.currentTimeMillis());
                Artifact artifact = new ArtifactBuilder()._byteSize_(BigInteger.valueOf(50000L))._checkSum_("ABCDEFG-CHECKSUM")._creationDate_(artifactDate)._duration_(new BigDecimal(5000))._fileName_("testArtifactFilename.dat").build();
                String string = Utils.INSTANCE.getSERIALIZER().serialize((Object)artifact);
                boolean bl7 = false;
                boolean bl8 = false;
                String it2 = string;
                boolean bl9 = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Serialisation body: {}", (Object)it2);
                }
                exchange.getMessage().setBody((Object)it2);
            }
        }
    }

    private final void createRejectionMessage(Exchange exchange, ArtifactRequestMessage artifactRequestMessage, RejectionReason rejectionReason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing RejectionMessage for requested artifact: {}", (Object)rejectionReason);
        }
        RejectionMessageBuilder rejectionMessageBuilder = new RejectionMessageBuilder()._correlationMessage_(artifactRequestMessage.getCorrelationMessage())._rejectionReason_(rejectionReason);
        boolean bl = false;
        boolean bl2 = false;
        RejectionMessageBuilder it = rejectionMessageBuilder;
        boolean bl3 = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serialisation header: {}", (Object)Utils.INSTANCE.getSERIALIZER().serialize((Object)it.build()));
        }
        exchange.getMessage().setHeader("idscp2-header", (Object)it);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/processors/ArtifactRequestProcessor$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "camel-idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

