/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.camel.idscp2.processors;

import de.fhg.aisec.ids.camel.idscp2.ProviderDB;
import de.fhg.aisec.ids.camel.idscp2.UsageControlMaps;
import de.fhg.aisec.ids.camel.idscp2.Utils;
import de.fraunhofer.iais.eis.ContractAgreement;
import de.fraunhofer.iais.eis.ContractAgreementMessage;
import de.fraunhofer.iais.eis.Permission;
import java.net.URI;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/processors/ContractAgreementReceiverProcessor;", "Lorg/apache/camel/Processor;", "()V", "process", "", "exchange", "Lorg/apache/camel/Exchange;", "Companion", "camel-idscp2"})
public final class ContractAgreementReceiverProcessor
implements Processor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(ContractAgreementReceiverProcessor.class);

    public void process(@NotNull Exchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        if (LOG.isDebugEnabled()) {
            LOG.debug("[IN] " + this.getClass().getSimpleName());
        }
        ContractAgreementMessage contractAgreementMessage = (ContractAgreementMessage)exchange.getMessage().getHeader("idscp2-header", ContractAgreementMessage.class);
        ContractAgreement contractAgreement = (ContractAgreement)Utils.INSTANCE.getSERIALIZER().deserialize((String)exchange.getMessage().getBody(String.class), ContractAgreement.class);
        Intrinsics.checkNotNullExpressionValue((Object)contractAgreement, (String)"contractAgreement");
        UsageControlMaps.INSTANCE.addContractAgreement(contractAgreement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Provider is saving contract " + contractAgreement.getId());
        }
        Map map = ProviderDB.INSTANCE.getContractAgreements();
        URI uRI = contractAgreement.getId();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"contractAgreement.id");
        Object object = contractAgreement;
        boolean bl = false;
        map.put(uRI, object);
        for (Permission permission : contractAgreement.getPermission()) {
            object = ProviderDB.INSTANCE.getArtifactUrisMapped2ContractAgreements();
            URI uRI2 = permission.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"permission.target");
            URI uRI3 = contractAgreement.getId();
            Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"contractAgreement.id");
            boolean bl2 = false;
            object.put(uRI2, uRI3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saved Agreement {}", (Object)contractAgreement.getId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received ContractAgreementMessage {}", (Object)Utils.INSTANCE.getSERIALIZER().serialize((Object)contractAgreementMessage));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/processors/ContractAgreementReceiverProcessor$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "camel-idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

