/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.camel.idscp2.processors;

import de.fhg.aisec.ids.camel.idscp2.UsageControlMaps;
import de.fhg.aisec.ids.camel.idscp2.Utils;
import de.fraunhofer.iais.eis.ContractAgreement;
import de.fraunhofer.iais.eis.ContractAgreementBuilder;
import de.fraunhofer.iais.eis.ContractAgreementMessageBuilder;
import de.fraunhofer.iais.eis.ContractOffer;
import de.fraunhofer.iais.eis.ContractOfferMessage;
import de.fraunhofer.iais.eis.ContractRejectionMessageBuilder;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/processors/ContractOfferProcessor;", "Lorg/apache/camel/Processor;", "()V", "createContractRejectionMessage", "", "exchange", "Lorg/apache/camel/Exchange;", "correlationId", "Ljava/net/URI;", "process", "Companion", "camel-idscp2"})
public final class ContractOfferProcessor
implements Processor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = LoggerFactory.getLogger(ContractOfferProcessor.class);

    public void process(@NotNull Exchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        if (LOG.isDebugEnabled()) {
            LOG.debug("[IN] " + this.getClass().getSimpleName());
        }
        ContractOfferMessage contractOfferMessage = (ContractOfferMessage)exchange.getMessage().getHeader("idscp2-header", ContractOfferMessage.class);
        ContractOffer contractOfferReceived = (ContractOffer)Utils.INSTANCE.getSERIALIZER().deserialize((String)exchange.getMessage().getBody(String.class), ContractOffer.class);
        boolean contractOfferIsAccepted = true;
        ContractAgreementMessageBuilder contractAgreementMessageBuilder = new ContractAgreementMessageBuilder();
        boolean bl = false;
        boolean bl2 = false;
        ContractAgreementMessageBuilder $this$process_u24lambda_u2d1 = contractAgreementMessageBuilder;
        boolean bl3 = false;
        $this$process_u24lambda_u2d1._correlationMessage_(contractOfferMessage.getId());
        ContractAgreementMessageBuilder contractAgreementMessageBuilder2 = $this$process_u24lambda_u2d1;
        boolean bl4 = false;
        boolean bl5 = false;
        ContractAgreementMessageBuilder it = contractAgreementMessageBuilder2;
        boolean bl6 = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serialization Header: {}", (Object)Utils.INSTANCE.getSERIALIZER().serialize((Object)it.build()));
        }
        exchange.getMessage().setHeader("idscp2-header", (Object)it);
        ContractAgreement contractAgreement = new ContractAgreementBuilder()._consumer_(contractOfferReceived.getConsumer())._provider_(contractOfferReceived.getProvider())._contractAnnex_(contractOfferReceived.getContractAnnex())._contractDate_(contractOfferReceived.getContractDate())._contractDocument_(contractOfferReceived.getContractDocument())._contractEnd_(contractOfferReceived.getContractEnd())._contractStart_(contractOfferReceived.getContractStart())._obligation_(contractOfferReceived.getObligation())._prohibition_(contractOfferReceived.getProhibition())._permission_(contractOfferReceived.getPermission()).build();
        Intrinsics.checkNotNullExpressionValue((Object)contractAgreement, (String)"contractAgreement");
        UsageControlMaps.INSTANCE.addContractAgreement(contractAgreement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Consumer saved contract " + contractAgreement.getId());
        }
        String string = Utils.INSTANCE.getSERIALIZER().serialize((Object)contractAgreement);
        bl2 = false;
        boolean bl7 = false;
        String it2 = string;
        boolean bl8 = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContractAgreement ID: {}", (Object)contractAgreement.getId());
            LOG.debug("Serialization body: {}", (Object)it2);
        }
        exchange.getMessage().setBody((Object)it2);
    }

    private final void createContractRejectionMessage(Exchange exchange, URI correlationId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructing ContractRejectionMessage");
        }
        ContractRejectionMessageBuilder contractRejectionMessageBuilder = new ContractRejectionMessageBuilder()._correlationMessage_(correlationId);
        boolean bl = false;
        boolean bl2 = false;
        ContractRejectionMessageBuilder it = contractRejectionMessageBuilder;
        boolean bl3 = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serialization Header: {}", (Object)Utils.INSTANCE.getSERIALIZER().serialize((Object)it.build()));
        }
        exchange.getMessage().setHeader("idscp2-header", (Object)it);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/processors/ContractOfferProcessor$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "camel-idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

