/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.camel.idscp2.server;

import de.fhg.aisec.ids.camel.idscp2.Utils;
import de.fhg.aisec.ids.camel.idscp2.server.CamelIdscp2Server;
import de.fhg.aisec.ids.camel.idscp2.server.Idscp2ServerComponent;
import de.fhg.aisec.ids.camel.idscp2.server.Idscp2ServerConsumer;
import de.fhg.aisec.ids.camel.idscp2.server.Idscp2ServerProducer;
import de.fhg.aisec.ids.idscp2.app_layer.AppLayerConnection;
import de.fhg.aisec.ids.idscp2.app_layer.listeners.GenericMessageListener;
import de.fhg.aisec.ids.idscp2.app_layer.listeners.IdsMessageListener;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.AisecDapsDriver;
import de.fhg.aisec.ids.idscp2.default_drivers.daps.aisec_daps.AisecDapsDriverConfig;
import de.fhg.aisec.ids.idscp2.default_drivers.secure_channel.tlsv1_3.NativeTlsConfiguration;
import de.fhg.aisec.ids.idscp2.idscp_core.api.Idscp2EndpointListener;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.AttestationConfig;
import de.fhg.aisec.ids.idscp2.idscp_core.api.configuration.Idscp2Configuration;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2Connection;
import de.fhg.aisec.ids.idscp2.idscp_core.api.idscp_connection.Idscp2ConnectionListener;
import de.fhg.aisec.ids.idscp2.idscp_core.drivers.DapsDriver;
import de.fraunhofer.iais.eis.Message;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="idscp2server", syntax="idscp2server://host:port", title="IDSCP2 Server Socket", label="ids")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0007\u0018\u0000 N2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001NB!\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\fJ\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020<H\u0016J\b\u0010E\u001a\u00020<H\u0016J\u0010\u0010F\u001a\u00020<2\u0006\u0010G\u001a\u00020\u0003H\u0016J\u000e\u0010H\u001a\u00020<2\u0006\u0010=\u001a\u00020\fJ\u001a\u0010I\u001a\u00020<2\b\u0010J\u001a\u0004\u0018\u00010K2\b\u0010L\u001a\u0004\u0018\u00010MR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010'\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b(\u0010)\u001a\u0004\b*\u0010\u001b\"\u0004\b+\u0010\u001dR\u001e\u0010,\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u000f\"\u0004\b.\u0010\u0011R\u001e\u0010/\u001a\u0002008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R \u00105\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u001b\"\u0004\b7\u0010\u001dR\u001e\u00108\u001a\u0002008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00102\"\u0004\b:\u00104\u00a8\u0006O"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/server/Idscp2ServerEndpoint;", "Lorg/apache/camel/support/DefaultEndpoint;", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/Idscp2EndpointListener;", "Lde/fhg/aisec/ids/idscp2/app_layer/AppLayerConnection;", "uri", "", "remaining", "component", "Lde/fhg/aisec/ids/camel/idscp2/server/Idscp2ServerComponent;", "(Ljava/lang/String;Ljava/lang/String;Lde/fhg/aisec/ids/camel/idscp2/server/Idscp2ServerComponent;)V", "consumers", "", "Lde/fhg/aisec/ids/camel/idscp2/server/Idscp2ServerConsumer;", "dapsKeyAlias", "getDapsKeyAlias", "()Ljava/lang/String;", "setDapsKeyAlias", "(Ljava/lang/String;)V", "dapsRatTimeoutDelay", "", "getDapsRatTimeoutDelay", "()J", "setDapsRatTimeoutDelay", "(J)V", "dapsSslContextParameters", "Lorg/apache/camel/support/jsse/SSLContextParameters;", "getDapsSslContextParameters", "()Lorg/apache/camel/support/jsse/SSLContextParameters;", "setDapsSslContextParameters", "(Lorg/apache/camel/support/jsse/SSLContextParameters;)V", "expectedRatSuites", "getExpectedRatSuites", "setExpectedRatSuites", "secureChannelConfig", "Lde/fhg/aisec/ids/idscp2/default_drivers/secure_channel/tlsv1_3/NativeTlsConfiguration;", "server", "Lde/fhg/aisec/ids/camel/idscp2/server/CamelIdscp2Server;", "serverConfiguration", "Lde/fhg/aisec/ids/idscp2/idscp_core/api/configuration/Idscp2Configuration;", "sslContextParameters", "getSslContextParameters$annotations", "()V", "getSslContextParameters", "setSslContextParameters", "supportedRatSuites", "getSupportedRatSuites", "setSupportedRatSuites", "tlsClientHostnameVerification", "", "getTlsClientHostnameVerification", "()Z", "setTlsClientHostnameVerification", "(Z)V", "transportSslContextParameters", "getTransportSslContextParameters", "setTransportSslContextParameters", "useIdsMessages", "getUseIdsMessages", "setUseIdsMessages", "addConsumer", "", "consumer", "createConsumer", "Lorg/apache/camel/Consumer;", "processor", "Lorg/apache/camel/Processor;", "createProducer", "Lorg/apache/camel/Producer;", "doStart", "doStop", "onConnection", "connection", "removeConsumer", "sendMessage", "header", "", "body", "", "Companion", "camel-idscp2"})
public final class Idscp2ServerEndpoint
extends DefaultEndpoint
implements Idscp2EndpointListener<AppLayerConnection> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String remaining;
    private Idscp2Configuration serverConfiguration;
    private NativeTlsConfiguration secureChannelConfig;
    @Nullable
    private CamelIdscp2Server server;
    @NotNull
    private final Set<Idscp2ServerConsumer> consumers;
    @UriParam(description="The transport encryption SSL context for the IDSCP2 endpoint", label="security")
    @Nullable
    private SSLContextParameters transportSslContextParameters;
    @UriParam(description="The DAPS authentication SSL context for the IDSCP2 endpoint", label="security")
    @Nullable
    private SSLContextParameters dapsSslContextParameters;
    @UriParam(description="The SSL context for the IDSCP2 endpoint (deprecated)", label="security")
    @Nullable
    private SSLContextParameters sslContextParameters;
    @UriParam(description="Whether to verify the hostname of the client.", label="security")
    private boolean tlsClientHostnameVerification;
    @UriParam(defaultValue="1", description="The alias of the DAPS key in the keystore provided by sslContextParameters", label="security")
    @NotNull
    private String dapsKeyAlias;
    @UriParam(defaultValue="600000", description="The validity time of remote attestation and DAT in milliseconds", label="security")
    private long dapsRatTimeoutDelay;
    @UriParam(defaultValue="false", description="Enable IdsMessage headers (Required for Usage Control)", label="common")
    private boolean useIdsMessages;
    @UriParam(defaultValue="Dummy", description="Locally supported Remote Attestation Suite IDs, separated by \"|\"", label="common")
    @NotNull
    private String supportedRatSuites;
    @UriParam(defaultValue="Dummy", description="Expected Remote Attestation Suite IDs, separated by \"|\", each communication peer must support at least one", label="common")
    @NotNull
    private String expectedRatSuites;
    private static final Logger LOG = LoggerFactory.getLogger(Idscp2ServerEndpoint.class);
    private static final Pattern URI_REGEX = Pattern.compile("(.*?)(?::(\\d+))?/?$");

    public Idscp2ServerEndpoint(@Nullable String uri, @NotNull String remaining, @Nullable Idscp2ServerComponent component) {
        Intrinsics.checkNotNullParameter((Object)remaining, (String)"remaining");
        super(uri, (Component)component);
        this.remaining = remaining;
        this.consumers = new HashSet();
        this.tlsClientHostnameVerification = true;
        this.dapsKeyAlias = "1";
        String string = "3600000";
        boolean bl = false;
        this.dapsRatTimeoutDelay = Long.parseLong(string);
        this.supportedRatSuites = "Dummy";
        this.expectedRatSuites = "Dummy";
    }

    @Nullable
    public final SSLContextParameters getTransportSslContextParameters() {
        return this.transportSslContextParameters;
    }

    public final void setTransportSslContextParameters(@Nullable SSLContextParameters sSLContextParameters) {
        this.transportSslContextParameters = sSLContextParameters;
    }

    @Nullable
    public final SSLContextParameters getDapsSslContextParameters() {
        return this.dapsSslContextParameters;
    }

    public final void setDapsSslContextParameters(@Nullable SSLContextParameters sSLContextParameters) {
        this.dapsSslContextParameters = sSLContextParameters;
    }

    @Nullable
    public final SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public final void setSslContextParameters(@Nullable SSLContextParameters sSLContextParameters) {
        this.sslContextParameters = sSLContextParameters;
    }

    @Deprecated(message="Depreacted in favor of transportSslContextParameters and dapsSslContextParameters")
    public static /* synthetic */ void getSslContextParameters$annotations() {
    }

    public final boolean getTlsClientHostnameVerification() {
        return this.tlsClientHostnameVerification;
    }

    public final void setTlsClientHostnameVerification(boolean bl) {
        this.tlsClientHostnameVerification = bl;
    }

    @NotNull
    public final String getDapsKeyAlias() {
        return this.dapsKeyAlias;
    }

    public final void setDapsKeyAlias(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dapsKeyAlias = string;
    }

    public final long getDapsRatTimeoutDelay() {
        return this.dapsRatTimeoutDelay;
    }

    public final void setDapsRatTimeoutDelay(long l) {
        this.dapsRatTimeoutDelay = l;
    }

    public final boolean getUseIdsMessages() {
        return this.useIdsMessages;
    }

    public final void setUseIdsMessages(boolean bl) {
        this.useIdsMessages = bl;
    }

    @NotNull
    public final String getSupportedRatSuites() {
        return this.supportedRatSuites;
    }

    public final void setSupportedRatSuites(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.supportedRatSuites = string;
    }

    @NotNull
    public final String getExpectedRatSuites() {
        return this.expectedRatSuites;
    }

    public final void setExpectedRatSuites(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.expectedRatSuites = string;
    }

    public final synchronized void addConsumer(@NotNull Idscp2ServerConsumer consumer) {
        block4: {
            Collection<AppLayerConnection> collection;
            block3: {
                Collection<AppLayerConnection> collection2;
                Intrinsics.checkNotNullParameter((Object)((Object)consumer), (String)"consumer");
                this.consumers.add(consumer);
                if (!this.useIdsMessages) break block3;
                CamelIdscp2Server camelIdscp2Server = this.server;
                if (camelIdscp2Server == null || (collection2 = camelIdscp2Server.getAllConnections()) == null) break block4;
                Iterable $this$forEach$iv = collection2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AppLayerConnection it = (AppLayerConnection)element$iv;
                    boolean bl = false;
                    it.addIdsMessageListener((IdsMessageListener)consumer);
                }
                break block4;
            }
            CamelIdscp2Server camelIdscp2Server = this.server;
            if (camelIdscp2Server != null && (collection = camelIdscp2Server.getAllConnections()) != null) {
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AppLayerConnection it = (AppLayerConnection)element$iv;
                    boolean bl = false;
                    it.addGenericMessageListener((GenericMessageListener)consumer);
                }
            }
        }
    }

    public final synchronized void removeConsumer(@NotNull Idscp2ServerConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)((Object)consumer), (String)"consumer");
        if (this.useIdsMessages) {
            Collection<AppLayerConnection> collection;
            CamelIdscp2Server camelIdscp2Server = this.server;
            if (camelIdscp2Server != null && (collection = camelIdscp2Server.getAllConnections()) != null) {
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AppLayerConnection it = (AppLayerConnection)element$iv;
                    boolean bl = false;
                    it.removeIdsMessageListener((IdsMessageListener)consumer);
                }
            }
        } else {
            Collection<AppLayerConnection> collection;
            CamelIdscp2Server camelIdscp2Server = this.server;
            if (camelIdscp2Server != null && (collection = camelIdscp2Server.getAllConnections()) != null) {
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AppLayerConnection it = (AppLayerConnection)element$iv;
                    boolean bl = false;
                    it.removeGenericMessageListener((GenericMessageListener)consumer);
                }
            }
        }
        this.consumers.remove((Object)consumer);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void sendMessage(@Nullable Object header, @Nullable byte[] body) {
        CamelIdscp2Server camelIdscp2Server = this.server;
        if (camelIdscp2Server != null) {
            CamelIdscp2Server camelIdscp2Server2 = camelIdscp2Server;
            boolean bl = false;
            boolean bl2 = false;
            CamelIdscp2Server server = camelIdscp2Server2;
            boolean bl3 = false;
            Iterable $this$forEach$iv = server.getAllConnections();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                AppLayerConnection connection = (AppLayerConnection)element$iv;
                boolean bl4 = false;
                if (this.getUseIdsMessages()) {
                    Message message;
                    AppLayerConnection appLayerConnection = connection;
                    object = header;
                    if (object == null) {
                        message = null;
                    } else {
                        void it;
                        Object object2 = object;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        Object object3 = object2;
                        AppLayerConnection appLayerConnection2 = appLayerConnection;
                        boolean bl7 = false;
                        Message message2 = Utils.INSTANCE.finalizeMessage(it, (Idscp2Connection)connection);
                        appLayerConnection = appLayerConnection2;
                        message = message2;
                    }
                    AppLayerConnection.sendIdsMessage$default((AppLayerConnection)appLayerConnection, message, (byte[])body, (long)0L, (int)4, null);
                    continue;
                }
                object = header;
                connection.sendGenericMessage(object == null ? null : object.toString(), body);
            }
        }
    }

    @NotNull
    public synchronized Producer createProducer() {
        return (Producer)new Idscp2ServerProducer(this);
    }

    @NotNull
    public synchronized Consumer createConsumer(@NotNull Processor processor) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        return (Consumer)new Idscp2ServerConsumer(this, processor);
    }

    public synchronized void onConnection(@NotNull AppLayerConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (LOG.isDebugEnabled()) {
            LOG.debug("New IDSCP2 connection on " + this.getEndpointUri() + ", register consumer listeners");
        }
        if (this.useIdsMessages) {
            Iterable $this$forEach$iv = this.consumers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Idscp2ServerConsumer it = (Idscp2ServerConsumer)((Object)element$iv);
                boolean bl = false;
                connection.addIdsMessageListener((IdsMessageListener)it);
            }
        } else {
            Iterable $this$forEach$iv = this.consumers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Idscp2ServerConsumer it = (Idscp2ServerConsumer)((Object)element$iv);
                boolean bl = false;
                connection.addGenericMessageListener((GenericMessageListener)it);
            }
        }
        connection.addConnectionListener(new Idscp2ConnectionListener(this, connection){
            final /* synthetic */ Idscp2ServerEndpoint this$0;
            final /* synthetic */ AppLayerConnection $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                Idscp2ServerEndpoint.access$getLOG$cp().error("Error in Idscp2ServerEndpoint-managed connection", t);
            }

            /*
             * WARNING - void declaration
             */
            public void onClose() {
                if (this.this$0.getUseIdsMessages()) {
                    void $this$forEach$iv;
                    Iterable iterable = Idscp2ServerEndpoint.access$getConsumers$p(this.this$0);
                    AppLayerConnection appLayerConnection = this.$connection;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Idscp2ServerConsumer it = (Idscp2ServerConsumer)((Object)element$iv);
                        boolean bl = false;
                        appLayerConnection.removeIdsMessageListener((IdsMessageListener)it);
                    }
                } else {
                    Iterable $this$forEach$iv = Idscp2ServerEndpoint.access$getConsumers$p(this.this$0);
                    AppLayerConnection appLayerConnection = this.$connection;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Idscp2ServerConsumer it = (Idscp2ServerConsumer)((Object)element$iv);
                        boolean bl = false;
                        appLayerConnection.removeGenericMessageListener((GenericMessageListener)it);
                    }
                }
            }
        });
    }

    public synchronized void doStart() {
        boolean bl;
        Object object;
        boolean bl2;
        String string;
        Object object2;
        SSLContextParameters it;
        boolean bl3;
        boolean bl4;
        SSLContextParameters sSLContextParameters;
        Object object3;
        int n;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting IDSCP2 server endpoint " + this.getEndpointUri());
        }
        Matcher remainingMatcher = URI_REGEX.matcher(this.remaining);
        boolean bl5 = remainingMatcher.matches();
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl5) {
            boolean bl8 = false;
            String string2 = this.remaining + " is not a valid URI remainder, must be \"host:port\".";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        MatchResult matchResult = remainingMatcher.toMatchResult();
        String host = matchResult.group(1);
        String bl8 = matchResult.group(2);
        if (bl8 == null) {
            n = 29292;
        } else {
            int n2;
            String string3 = bl8;
            boolean bl9 = false;
            n = n2 = Integer.parseInt(string3);
        }
        int port = n;
        char[] cArray = new char[]{'|'};
        Object $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.supportedRatSuites, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$toTypedArray$iv = new char[1];
        $this$toTypedArray$iv[0] = 124;
        $this$toTypedArray$iv = StringsKt.split$default((CharSequence)this.expectedRatSuites, (char[])$this$toTypedArray$iv, (boolean)false, (int)0, (int)6, null);
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        AttestationConfig localAttestationConfig = new AttestationConfig.Builder().setSupportedRatSuite(stringArray).setExpectedRatSuite(stringArray2).setRatTimeoutDelay(this.dapsRatTimeoutDelay).build();
        AisecDapsDriverConfig.Builder dapsDriverConfigBuilder = new AisecDapsDriverConfig.Builder().setDapsUrl((String)Utils.INSTANCE.getDapsUrlProducer().invoke()).setKeyAlias(this.dapsKeyAlias);
        NativeTlsConfiguration.Builder builder = new NativeTlsConfiguration.Builder();
        Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
        NativeTlsConfiguration.Builder secureChannelConfigBuilder = builder.setHost(host).setServerPort(port);
        if (!this.tlsClientHostnameVerification) {
            secureChannelConfigBuilder.unsafeDisableHostnameVerification();
        }
        Object object4 = object3 = (sSLContextParameters = this.transportSslContextParameters) == null ? this.sslContextParameters : sSLContextParameters;
        if (object3 != null) {
            Object object5;
            char[] cArray2;
            KeyStoreParameters keyStoreParameters;
            Object object6;
            char[] cArray3;
            String string4;
            KeyStoreParameters keyStoreParameters2;
            char[] cArray4;
            char[] cArray5;
            sSLContextParameters = object3;
            bl4 = false;
            bl3 = false;
            it = sSLContextParameters;
            boolean bl10 = false;
            object2 = it.getKeyManagers();
            if (object2 == null) {
                cArray5 = null;
            } else {
                String string5 = object2.getKeyPassword();
                if (string5 == null) {
                    cArray5 = null;
                } else {
                    string = string5;
                    bl2 = false;
                    char[] cArray6 = string.toCharArray();
                    cArray5 = cArray6;
                    Intrinsics.checkNotNullExpressionValue((Object)cArray6, (String)"(this as java.lang.String).toCharArray()");
                }
            }
            object = cArray5;
            if (object == null) {
                object2 = "password";
                boolean bl11 = false;
                char[] cArray7 = ((String)object2).toCharArray();
                cArray4 = cArray7;
                Intrinsics.checkNotNullExpressionValue((Object)cArray7, (String)"(this as java.lang.String).toCharArray()");
            } else {
                cArray4 = object;
            }
            NativeTlsConfiguration.Builder builder2 = secureChannelConfigBuilder.setKeyPassword(cArray4);
            object2 = it.getKeyManagers();
            object = Paths.get(object2 == null ? "DUMMY-FILENAME.p12" : ((keyStoreParameters2 = object2.getKeyStore()) == null ? "DUMMY-FILENAME.p12" : ((string = keyStoreParameters2.getResource()) == null ? "DUMMY-FILENAME.p12" : string)), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(it.keyManagers?.keyStore?.resource ?: \"DUMMY-FILENAME.p12\")");
            NativeTlsConfiguration.Builder builder3 = builder2.setKeyStorePath((Path)object);
            object = it.getKeyManagers();
            NativeTlsConfiguration.Builder builder4 = builder3.setKeyStoreKeyType(object == null ? "RSA" : ((object2 = object.getKeyStore()) == null ? "RSA" : ((string4 = object2.getType()) == null ? "RSA" : string4)));
            object2 = it.getKeyManagers();
            if (object2 == null) {
                cArray3 = null;
            } else {
                KeyStoreParameters keyStoreParameters3 = object2.getKeyStore();
                if (keyStoreParameters3 == null) {
                    cArray3 = null;
                } else {
                    string = keyStoreParameters3.getPassword();
                    if (string == null) {
                        cArray3 = null;
                    } else {
                        String string6 = string;
                        bl = false;
                        char[] cArray8 = string6.toCharArray();
                        cArray3 = cArray8;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray8, (String)"(this as java.lang.String).toCharArray()");
                    }
                }
            }
            object = cArray3;
            if (object == null) {
                object2 = "password";
                boolean bl12 = false;
                char[] cArray9 = ((String)object2).toCharArray();
                object6 = cArray9;
                Intrinsics.checkNotNullExpressionValue((Object)cArray9, (String)"(this as java.lang.String).toCharArray()");
            } else {
                object6 = object;
            }
            NativeTlsConfiguration.Builder builder5 = builder4.setKeyStorePassword(object6);
            object2 = it.getTrustManagers();
            object = Paths.get(object2 == null ? "DUMMY-FILENAME.p12" : ((keyStoreParameters = object2.getKeyStore()) == null ? "DUMMY-FILENAME.p12" : ((string = keyStoreParameters.getResource()) == null ? "DUMMY-FILENAME.p12" : string)), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(it.trustManagers?.keyStore?.resource ?: \"DUMMY-FILENAME.p12\")");
            NativeTlsConfiguration.Builder builder6 = builder5.setTrustStorePath((Path)object);
            object2 = it.getTrustManagers();
            if (object2 == null) {
                cArray2 = null;
            } else {
                KeyStoreParameters keyStoreParameters4 = object2.getKeyStore();
                if (keyStoreParameters4 == null) {
                    cArray2 = null;
                } else {
                    string = keyStoreParameters4.getPassword();
                    if (string == null) {
                        cArray2 = null;
                    } else {
                        String string7 = string;
                        bl = false;
                        char[] cArray10 = string7.toCharArray();
                        cArray2 = cArray10;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray10, (String)"(this as java.lang.String).toCharArray()");
                    }
                }
            }
            object = cArray2;
            if (object == null) {
                object2 = "password";
                boolean bl13 = false;
                char[] cArray11 = ((String)object2).toCharArray();
                object5 = cArray11;
                Intrinsics.checkNotNullExpressionValue((Object)cArray11, (String)"(this as java.lang.String).toCharArray()");
            } else {
                object5 = object;
            }
            object = it.getCertAlias();
            builder6.setTrustStorePassword(object5).setCertificateAlias((String)(object == null ? "1.0.1" : (Object)object));
        }
        sSLContextParameters = this.dapsSslContextParameters;
        Object object7 = object3 = sSLContextParameters == null ? this.sslContextParameters : sSLContextParameters;
        if (object3 != null) {
            Object object8;
            char[] cArray12;
            KeyStoreParameters keyStoreParameters;
            Object object9;
            char[] cArray13;
            KeyStoreParameters keyStoreParameters5;
            char[] cArray14;
            char[] cArray15;
            sSLContextParameters = object3;
            bl4 = false;
            bl3 = false;
            it = sSLContextParameters;
            boolean bl14 = false;
            object2 = it.getKeyManagers();
            if (object2 == null) {
                cArray15 = null;
            } else {
                String string8 = object2.getKeyPassword();
                if (string8 == null) {
                    cArray15 = null;
                } else {
                    string = string8;
                    bl2 = false;
                    char[] cArray16 = string.toCharArray();
                    cArray15 = cArray16;
                    Intrinsics.checkNotNullExpressionValue((Object)cArray16, (String)"(this as java.lang.String).toCharArray()");
                }
            }
            object = cArray15;
            if (object == null) {
                object2 = "password";
                boolean bl15 = false;
                char[] cArray17 = ((String)object2).toCharArray();
                cArray14 = cArray17;
                Intrinsics.checkNotNullExpressionValue((Object)cArray17, (String)"(this as java.lang.String).toCharArray()");
            } else {
                cArray14 = object;
            }
            AisecDapsDriverConfig.Builder builder7 = dapsDriverConfigBuilder.setKeyPassword(cArray14);
            object2 = it.getKeyManagers();
            object = Paths.get(object2 == null ? "DUMMY-FILENAME.p12" : ((keyStoreParameters5 = object2.getKeyStore()) == null ? "DUMMY-FILENAME.p12" : ((string = keyStoreParameters5.getResource()) == null ? "DUMMY-FILENAME.p12" : string)), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(it.keyManagers?.keyStore?.resource ?: \"DUMMY-FILENAME.p12\")");
            AisecDapsDriverConfig.Builder builder8 = builder7.setKeyStorePath((Path)object);
            object2 = it.getKeyManagers();
            if (object2 == null) {
                cArray13 = null;
            } else {
                KeyStoreParameters keyStoreParameters6 = object2.getKeyStore();
                if (keyStoreParameters6 == null) {
                    cArray13 = null;
                } else {
                    string = keyStoreParameters6.getPassword();
                    if (string == null) {
                        cArray13 = null;
                    } else {
                        String string9 = string;
                        bl = false;
                        char[] cArray18 = string9.toCharArray();
                        cArray13 = cArray18;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray18, (String)"(this as java.lang.String).toCharArray()");
                    }
                }
            }
            object = cArray13;
            if (object == null) {
                object2 = "password";
                boolean bl16 = false;
                char[] cArray19 = ((String)object2).toCharArray();
                object9 = cArray19;
                Intrinsics.checkNotNullExpressionValue((Object)cArray19, (String)"(this as java.lang.String).toCharArray()");
            } else {
                object9 = object;
            }
            AisecDapsDriverConfig.Builder builder9 = builder8.setKeyStorePassword(object9);
            object2 = it.getTrustManagers();
            object = Paths.get(object2 == null ? "DUMMY-FILENAME.p12" : ((keyStoreParameters = object2.getKeyStore()) == null ? "DUMMY-FILENAME.p12" : ((string = keyStoreParameters.getResource()) == null ? "DUMMY-FILENAME.p12" : string)), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(it.trustManagers?.keyStore?.resource ?: \"DUMMY-FILENAME.p12\")");
            AisecDapsDriverConfig.Builder builder10 = builder9.setTrustStorePath((Path)object);
            object2 = it.getTrustManagers();
            if (object2 == null) {
                cArray12 = null;
            } else {
                KeyStoreParameters keyStoreParameters7 = object2.getKeyStore();
                if (keyStoreParameters7 == null) {
                    cArray12 = null;
                } else {
                    string = keyStoreParameters7.getPassword();
                    if (string == null) {
                        cArray12 = null;
                    } else {
                        String string10 = string;
                        bl = false;
                        char[] cArray20 = string10.toCharArray();
                        cArray12 = cArray20;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray20, (String)"(this as java.lang.String).toCharArray()");
                    }
                }
            }
            object = cArray12;
            if (object == null) {
                object2 = "password";
                boolean bl17 = false;
                char[] cArray21 = ((String)object2).toCharArray();
                object8 = cArray21;
                Intrinsics.checkNotNullExpressionValue((Object)cArray21, (String)"(this as java.lang.String).toCharArray()");
            } else {
                object8 = object;
            }
            builder10.setTrustStorePassword(object8);
        }
        this.serverConfiguration = new Idscp2Configuration.Builder().setAttestationConfig(localAttestationConfig).setDapsDriver((DapsDriver)new AisecDapsDriver(dapsDriverConfigBuilder.build())).build();
        this.secureChannelConfig = secureChannelConfigBuilder.build();
        object3 = this.getComponent();
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type de.fhg.aisec.ids.camel.idscp2.server.Idscp2ServerComponent");
        }
        Idscp2ServerComponent idscp2ServerComponent = (Idscp2ServerComponent)((Object)object3);
        object3 = this.serverConfiguration;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverConfiguration");
            throw null;
        }
        SSLContextParameters sSLContextParameters2 = object3;
        object3 = this.secureChannelConfig;
        if (object3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"secureChannelConfig");
            throw null;
        }
        object3 = idscp2ServerComponent.getServer((Idscp2Configuration)sSLContextParameters2, (NativeTlsConfiguration)object3, this.useIdsMessages);
        boolean bl18 = false;
        bl4 = false;
        Object it2 = object3;
        boolean bl19 = false;
        this.server = it2;
        Object object10 = it2;
        object2 = ((CamelIdscp2Server)object10).getListeners();
        boolean bl20 = false;
        object2.add(this);
    }

    public synchronized void doStop() {
        CamelIdscp2Server camelIdscp2Server;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping IDSCP2 server endpoint " + this.getEndpointUri());
        }
        if ((camelIdscp2Server = this.server) != null) {
            CamelIdscp2Server camelIdscp2Server2 = camelIdscp2Server;
            boolean bl = false;
            boolean bl2 = false;
            CamelIdscp2Server it = camelIdscp2Server2;
            boolean bl3 = false;
            CamelIdscp2Server camelIdscp2Server3 = it;
            Collection collection = camelIdscp2Server3.getListeners();
            boolean bl4 = false;
            collection.remove((Object)this);
        }
        if (this.serverConfiguration != null) {
            camelIdscp2Server = this.getComponent();
            if (camelIdscp2Server == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fhg.aisec.ids.camel.idscp2.server.Idscp2ServerComponent");
            }
            Idscp2ServerComponent idscp2ServerComponent = (Idscp2ServerComponent)((Object)camelIdscp2Server);
            camelIdscp2Server = this.serverConfiguration;
            if (camelIdscp2Server == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serverConfiguration");
                throw null;
            }
            idscp2ServerComponent.freeServer((Idscp2Configuration)camelIdscp2Server);
        }
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Set access$getConsumers$p(Idscp2ServerEndpoint $this) {
        return $this.consumers;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fhg/aisec/ids/camel/idscp2/server/Idscp2ServerEndpoint$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "URI_REGEX", "Ljava/util/regex/Pattern;", "camel-idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

