/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.api.router;

import de.fhg.aisec.ids.api.router.CounterExample;
import java.util.ArrayList;
import java.util.List;

public class RouteVerificationProof {
    private String routeId;
    private long proofTimeNanos;
    private boolean isValid = true;
    private List<CounterExample> counterExamples = new ArrayList<CounterExample>();
    private String query = "";

    public RouteVerificationProof(String routeId) {
        if (routeId == null) {
            throw new NullPointerException("routeId must not be null");
        }
        this.routeId = routeId;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public long getProofTimeNanos() {
        return this.proofTimeNanos;
    }

    public void setProofTimeNanos(long proofTimeNanos) {
        this.proofTimeNanos = proofTimeNanos;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public List<CounterExample> getCounterExamples() {
        return this.counterExamples;
    }

    public void setCounterExamples(List<CounterExample> counterExamples) {
        this.counterExamples = counterExamples;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Proof for ").append(this.query).append("\n");
        sb.append("returns ").append(this.isValid).append("\n");
        sb.append("Example flows violating policy:\n");
        for (CounterExample ce : this.counterExamples) {
            sb.append("|-- ").append(ce.toString()).append("\n\n");
        }
        return sb.toString();
    }
}

