/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.client;

import de.fhg.aisec.ids.comm.CertificatePair;
import de.fhg.aisec.ids.comm.IdscpConfiguration;
import de.fhg.aisec.ids.messages.AttestationProtos;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClientConfiguration
implements IdscpConfiguration {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AttestationProtos.IdsAttestationType attestationType = AttestationProtos.IdsAttestationType.BASIC;
    private int attestationMask = 0;
    private @NonNull CertificatePair certificatePair = new CertificatePair();
    private @NonNull String rdfDescription = "";
    private @NonNull String dynamicAttributeToken = "";
    private @NonNull String endpoint = "";
    private @NonNull List<byte[]> sha256CertificateHashes = Collections.emptyList();
    protected @Nullable URI ttpUri;

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AttestationProtos.IdsAttestationType getAttestationType() {
        return this.attestationType;
    }

    @Override
    public int getAttestationMask() {
        return this.attestationMask;
    }

    @Override
    public @NonNull CertificatePair getCertificatePair() {
        return this.certificatePair;
    }

    public @NonNull String getDynamicAttributeToken() {
        return this.dynamicAttributeToken;
    }

    public @NonNull String getRDFDescription() {
        return this.rdfDescription;
    }

    @Override
    public @Nullable URI getTrustedThirdPartyURI() {
        return this.ttpUri;
    }

    public @NonNull String getEndpoint() {
        return this.endpoint;
    }

    public @NonNull List<byte[]> getSha256CertificateHashes() {
        return this.sha256CertificateHashes;
    }

    public static class Builder {
        private @NonNull ClientConfiguration config = new ClientConfiguration();

        public Builder attestationMask(int attestationMask) {
            this.config.attestationMask = attestationMask;
            return this;
        }

        public @NonNull Builder attestationType(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull AttestationProtos.IdsAttestationType attestationType) {
            this.config.attestationType = attestationType;
            return this;
        }

        public @NonNull Builder certificatePair(@NonNull CertificatePair certificatePair) {
            this.config.certificatePair = certificatePair;
            return this;
        }

        public @NonNull Builder ttpUrl(@NonNull URI ttpUri) {
            this.config.ttpUri = ttpUri;
            return this;
        }

        public @NonNull Builder rdfDescription(@NonNull String rdfDescription) {
            this.config.rdfDescription = rdfDescription;
            return this;
        }

        public @NonNull Builder dynamicAttributeToken(@NonNull String dynamicAttributeToken) {
            this.config.dynamicAttributeToken = dynamicAttributeToken;
            return this;
        }

        public @NonNull Builder endpoint(@NonNull String endpoint) {
            this.config.endpoint = endpoint;
            return this;
        }

        public @NonNull Builder setSha256CertificateHashes(@NonNull List<byte[]> hashes) {
            this.config.sha256CertificateHashes = hashes;
            return this;
        }

        public @NonNull ClientConfiguration build() {
            return this.config;
        }
    }
}

