/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.client;

import de.fhg.aisec.ids.api.conm.RatResult;
import de.fhg.aisec.ids.comm.client.ClientConfiguration;
import de.fhg.aisec.ids.comm.client.IdspClientSocket;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IdscpClient {
    private ClientConfiguration config = new ClientConfiguration();
    private RatResult attestationResult = null;
    private String metaData = null;

    @Deprecated
    public WebSocket connect(URI uri) throws InterruptedException, ExecutionException, KeyManagementException, NoSuchAlgorithmException {
        return this.connect(uri.getHost(), uri.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocket connect(@NonNull String host, int port) throws InterruptedException, ExecutionException, KeyManagementException, NoSuchAlgorithmException {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();
        if (!this.config.getSha256CertificateHashes().isEmpty()) {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new X509TrustManager[]{new X509TrustManager(){

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String str) throws CertificateException {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        byte[] digestBytes = digest.digest(certs[0].getEncoded());
                        if (IdscpClient.this.config.getSha256CertificateHashes().stream().noneMatch(hash -> Arrays.equals(digestBytes, hash))) {
                            throw new CertificateException("Did not find pinned SHA256 certificate hash: " + DatatypeConverter.printHexBinary((byte[])digestBytes));
                        }
                    }
                    catch (Exception x) {
                        throw new CertificateException("Error during hash calculation", x);
                    }
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String str) throws CertificateException {
                    throw new CertificateException("Must not be called by client implementation!");
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, null);
            JdkSslContext sslContext = new JdkSslContext(ctx, true, ClientAuth.NONE);
            builder.setSslContext((SslContext)sslContext);
        }
        AsyncHttpClient c = Dsl.asyncHttpClient((AsyncHttpClientConfig)builder.build());
        IdspClientSocket wsListener = new IdspClientSocket(this.config);
        WebSocket ws = (WebSocket)c.prepareGet("wss://" + host + ":" + port + "/" + this.config.getEndpoint()).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)wsListener).build()).get();
        wsListener.semaphore().lockInterruptibly();
        try {
            while (!wsListener.isTerminated()) {
                wsListener.idscpInProgressCondition().await();
            }
        }
        finally {
            this.attestationResult = wsListener.getAttestationResult();
            this.metaData = wsListener.getMetaResult();
            wsListener.semaphore().unlock();
        }
        return ws;
    }

    public @NonNull IdscpClient config(@NonNull ClientConfiguration config) {
        this.config = config;
        return this;
    }

    public @Nullable RatResult getAttestationResult() {
        return this.attestationResult;
    }

    public @Nullable String getMetaData() {
        return this.metaData;
    }
}

