/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.client;

import com.google.protobuf.InvalidProtocolBufferException;
import de.fhg.aisec.ids.api.conm.RatResult;
import de.fhg.aisec.ids.comm.DatVerifier;
import de.fhg.aisec.ids.comm.client.ClientConfiguration;
import de.fhg.aisec.ids.comm.ws.protocol.ClientProtocolMachine;
import de.fhg.aisec.ids.comm.ws.protocol.ProtocolState;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Event;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.FSM;
import de.fhg.aisec.ids.messages.Idscp;
import java.util.Random;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdspClientSocket
implements WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(IdspClientSocket.class);
    private FSM fsm;
    private final @NonNull ReentrantLock lock = new ReentrantLock();
    private final Condition idscpInProgress = this.lock.newCondition();
    private final Idscp.ConnectorMessage startMsg = Idscp.ConnectorMessage.newBuilder().setType(Idscp.ConnectorMessage.Type.RAT_START).setId(new Random().nextLong()).build();
    private ClientConfiguration config;
    private boolean isTerminated = false;
    private DatVerifier datVerifier = dat -> {
        if (LOG.isInfoEnabled()) {
            LOG.info("Received DAT token: {}", (Object)dat);
        }
    };

    public IdspClientSocket(ClientConfiguration config) {
        this.config = config;
    }

    public void setDatVerifier(DatVerifier datVerifier) {
        this.datVerifier = datVerifier;
    }

    public void onOpen(WebSocket websocket) {
        LOG.debug("Websocket opened");
        this.fsm = new ClientProtocolMachine(websocket, this.config, this.datVerifier);
        this.fsm.feedEvent(new Event(this.startMsg.getType(), this.startMsg.toString(), this.startMsg));
    }

    public void onClose(WebSocket websocket, int code, String status) {
        LOG.debug("websocket closed - reconnecting");
        this.fsm.reset();
    }

    public void onError(Throwable t) {
        LOG.debug("websocket on error", t);
        if (this.fsm != null) {
            this.fsm.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBinaryFrame(byte[] message, boolean finalFragment, int rsv) {
        LOG.debug("Client websocket received binary message {}", (Object)new String(message));
        try {
            this.lock.lockInterruptibly();
            try {
                Idscp.ConnectorMessage msg = Idscp.ConnectorMessage.parseFrom((byte[])message);
                LOG.debug("Received in state " + this.fsm.getState() + ": " + new String(message));
                this.fsm.feedEvent(new Event(msg.getType(), new String(message), msg));
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            if (this.fsm.getState().equals(ProtocolState.IDSCP_END.id())) {
                LOG.debug("Client is now terminating IDSCP");
                this.isTerminated = true;
                this.idscpInProgress.signalAll();
            }
        }
        catch (InterruptedException e) {
            LOG.warn(e.getMessage());
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
            this.isTerminated = true;
        }
    }

    public void onTextFrame(String message, boolean finalFragment, int rsv) {
        LOG.debug("Client websocket received text message {}", (Object)message);
        this.onBinaryFrame(message.getBytes(), finalFragment, rsv);
    }

    public @NonNull ReentrantLock semaphore() {
        return this.lock;
    }

    public @NonNull Condition idscpInProgressCondition() {
        return this.idscpInProgress;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public @NonNull RatResult getAttestationResult() {
        return this.fsm.getRatResult();
    }

    public @NonNull String getMetaResult() {
        return this.fsm.getMetaData();
    }
}

