/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.server;

import de.fhg.aisec.ids.comm.server.ServerConfiguration;
import de.fhg.aisec.ids.comm.server.ServerSocketServlet;
import de.fhg.aisec.ids.comm.server.SocketListener;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdscpServer {
    private static final Logger LOG = LoggerFactory.getLogger(IdscpServer.class);
    private ServerConfiguration config = new ServerConfiguration();
    private Server server;
    private SocketListener socketListener;

    public IdscpServer config(ServerConfiguration config) {
        this.config = config;
        return this;
    }

    public IdscpServer setSocketListener(SocketListener socketListener) {
        this.socketListener = socketListener;
        return this;
    }

    public IdscpServer start() {
        Server s = new Server();
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStore(this.config.getKeyStore());
        sslContextFactory.setKeyStorePassword(this.config.getKeyStorePassword());
        sslContextFactory.setCertAlias(this.config.getCertAlias());
        sslContextFactory.setKeyManagerPassword(this.config.getKeyManagerPassword());
        ServerConnector sslConnector = new ServerConnector(s, (SslContextFactory)sslContextFactory, new ConnectionFactory[]{new HttpConnectionFactory(https)});
        sslConnector.setPort(this.config.getPort());
        s.setConnectors(new Connector[]{sslConnector});
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        s.setHandler((Handler)context);
        ServletHolder holderEvents = new ServletHolder("ids", (Servlet)new ServerSocketServlet(this.config, this.socketListener));
        context.addServlet(holderEvents, "/");
        try {
            s.start();
            this.server = s;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public IdscpServer addServlet(String basePath) {
        if (this.server == null) {
            throw new IllegalArgumentException("Wrong order: must call start() before addServlet()");
        }
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        ServletHolder holderEvents = new ServletHolder("ids", (Servlet)new ServerSocketServlet(this.config, this.socketListener));
        context.addServlet(holderEvents, basePath);
        return this;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isRunning() {
        Server s = this.server;
        return s != null && s.isRunning();
    }
}

