/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.server;

import com.google.protobuf.InvalidProtocolBufferException;
import de.fhg.aisec.ids.api.conm.RatResult;
import de.fhg.aisec.ids.comm.DatVerifier;
import de.fhg.aisec.ids.comm.server.ServerConfiguration;
import de.fhg.aisec.ids.comm.server.SocketListener;
import de.fhg.aisec.ids.comm.ws.protocol.ProtocolState;
import de.fhg.aisec.ids.comm.ws.protocol.ServerProtocolMachine;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Event;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.FSM;
import de.fhg.aisec.ids.messages.Idscp;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class IdscpServerSocket {
    private static final Logger LOG = LoggerFactory.getLogger(IdscpServerSocket.class);
    private FSM fsm;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition isFinishedCond = this.lock.newCondition();
    private ServerConfiguration config;
    private SocketListener socketListener;
    private Session session;
    private DatVerifier datVerifier = dat -> {
        if (LOG.isInfoEnabled()) {
            LOG.info("Received DAT token: {}", (Object)dat);
        }
    };

    public IdscpServerSocket(ServerConfiguration config, SocketListener socketListener) {
        this.config = config;
        this.socketListener = socketListener;
    }

    public void setDatVerifier(DatVerifier datVerifier) {
        this.datVerifier = datVerifier;
    }

    @OnWebSocketConnect
    public void onOpen(Session session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Websocket opened {} from {} to {}", new Object[]{this, session.getRemoteAddress(), session.getLocalAddress()});
        }
        this.session = session;
        this.fsm = new ServerProtocolMachine(session, this.config, this.datVerifier);
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        LOG.debug("websocket closed");
        this.fsm.reset();
        this.socketListener.notifyClosed(this);
    }

    @OnWebSocketError
    public void onError(Throwable t) {
        LOG.debug("websocket on error", t);
        if (this.fsm != null) {
            this.fsm.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketFrame
    public void onMessage(Session session, Frame frame) {
        byte[] message = new byte[frame.getPayload().remaining()];
        frame.getPayload().get(message);
        LOG.debug("Received in state " + this.fsm.getState() + ": " + new String(message));
        try {
            block10: {
                this.lock.lockInterruptibly();
                if (!this.fsm.getState().equals(ProtocolState.IDSCP_END.id()) && !this.fsm.getState().equals(ProtocolState.IDSCP_ERROR.id())) break block10;
                LOG.debug("Passing through to web socket " + new String(message));
                if (this.socketListener != null) {
                    this.socketListener.onMessage(session, message);
                }
                return;
            }
            try {
                Idscp.ConnectorMessage msg = Idscp.ConnectorMessage.parseFrom((byte[])message);
                this.fsm.feedEvent(new Event(msg.getType(), new String(message), msg));
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error(e.getMessage() + ": " + new String(message), (Throwable)e);
                this.fsm.feedEvent(new Event(Idscp.ConnectorMessage.Type.ERROR, e.getMessage(), Idscp.ConnectorMessage.getDefaultInstance()));
            }
        }
        catch (InterruptedException e) {
            LOG.warn(e.getMessage());
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReentrantLock semaphore() {
        return this.lock;
    }

    public Condition isFinished() {
        return this.isFinishedCond;
    }

    public RatResult getAttestationResult() {
        return this.fsm.getRatResult();
    }

    public String getMetaData() {
        return this.fsm.getMetaData();
    }

    public Session getSession() {
        return this.session;
    }
}

