/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.server;

import de.fhg.aisec.ids.comm.CertificatePair;
import de.fhg.aisec.ids.comm.IdscpConfiguration;
import de.fhg.aisec.ids.messages.AttestationProtos;
import java.net.URI;
import java.security.KeyStore;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerConfiguration
implements IdscpConfiguration {
    public static final int DEFAULT_PORT = 8080;
    private int port = 8080;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AttestationProtos.IdsAttestationType attestationType = AttestationProtos.IdsAttestationType.BASIC;
    private int attestationMask;
    private @NonNull CertificatePair certificatePair = new CertificatePair();
    private @Nullable KeyStore keyStore = null;
    @NonNull String rdfDescription = "";
    @NonNull String dynamicAttributeToken = "";
    private @Nullable URI ttpUri = null;
    private @NonNull String keyStorePassword = "password";
    private @NonNull String keyManagerPassword = "password";
    private @NonNull String certAlias = "1";

    public int getPort() {
        return this.port;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AttestationProtos.IdsAttestationType getAttestationType() {
        return this.attestationType;
    }

    @Override
    public int getAttestationMask() {
        return this.attestationMask;
    }

    @Override
    public @NonNull CertificatePair getCertificatePair() {
        return this.certificatePair;
    }

    public @NonNull String getRDFDescription() {
        return this.rdfDescription;
    }

    public @NonNull String getDynamicAttributeToken() {
        return this.dynamicAttributeToken;
    }

    @Override
    public @Nullable URI getTrustedThirdPartyURI() {
        return this.ttpUri;
    }

    public @Nullable KeyStore getKeyStore() {
        return this.keyStore;
    }

    public @NonNull String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public @NonNull String getKeyManagerPassword() {
        return this.keyManagerPassword;
    }

    public @NonNull String getCertAlias() {
        return this.certAlias;
    }

    public static class Builder {
        private @NonNull ServerConfiguration config = new ServerConfiguration();

        public @NonNull Builder port(int port) {
            this.config.port = port;
            return this;
        }

        public @NonNull Builder attestationType(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull AttestationProtos.IdsAttestationType attestationType) {
            this.config.attestationType = attestationType;
            return this;
        }

        public @NonNull Builder attestationMask(int attestationMask) {
            this.config.attestationMask = attestationMask;
            return this;
        }

        public @NonNull Builder certificatePair(@NonNull CertificatePair certificatePair) {
            this.config.certificatePair = certificatePair;
            return this;
        }

        public @NonNull Builder rdfDescription(@NonNull String rdfDescription) {
            this.config.rdfDescription = rdfDescription;
            return this;
        }

        public @NonNull Builder dynamicAttributeToken(@NonNull String dynamicAttributeToken) {
            this.config.dynamicAttributeToken = dynamicAttributeToken;
            return this;
        }

        public @NonNull Builder ttpUrl(@Nullable URI ttpUri) {
            this.config.ttpUri = ttpUri;
            return this;
        }

        public @NonNull Builder setKeyStore(@NonNull KeyStore keyStore) {
            this.config.keyStore = keyStore;
            return this;
        }

        public @NonNull Builder setKeyStorePassword(@NonNull String keyStorePassword) {
            this.config.keyStorePassword = keyStorePassword;
            return this;
        }

        public @NonNull Builder setKeyPassword(@NonNull String keyPassword) {
            this.config.keyManagerPassword = keyPassword;
            return this;
        }

        public @NonNull Builder setCertAlias(@NonNull String certAlias) {
            this.config.certAlias = certAlias;
            return this;
        }

        public @NonNull ServerConfiguration build() {
            return this.config;
        }
    }
}

