/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.ws.protocol;

import com.google.protobuf.MessageLite;
import de.fhg.aisec.ids.api.tokenm.DatException;
import de.fhg.aisec.ids.comm.DatVerifier;
import de.fhg.aisec.ids.comm.client.ClientConfiguration;
import de.fhg.aisec.ids.comm.ws.protocol.ProtocolState;
import de.fhg.aisec.ids.comm.ws.protocol.error.ErrorHandler;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Event;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.FSM;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Transition;
import de.fhg.aisec.ids.comm.ws.protocol.metadata.MetadataConsumerHandler;
import de.fhg.aisec.ids.comm.ws.protocol.rat.RemoteAttestationClientHandler;
import de.fhg.aisec.ids.messages.Idscp;
import java.net.URI;
import java.util.Arrays;
import org.asynchttpclient.ws.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProtocolMachine
extends FSM {
    private static final Logger LOG = LoggerFactory.getLogger(ClientProtocolMachine.class);
    private WebSocket clientSocket;

    public ClientProtocolMachine(WebSocket ws, ClientConfiguration clientConfiguration, DatVerifier datVerifier) {
        this.clientSocket = ws;
        URI ttp = clientConfiguration.getTrustedThirdPartyURI();
        RemoteAttestationClientHandler ratConsumerHandler = new RemoteAttestationClientHandler(clientConfiguration, ttp, "/var/run/tpm2d/control.sock");
        ErrorHandler errorHandler = new ErrorHandler();
        MetadataConsumerHandler metaHandler = new MetadataConsumerHandler(clientConfiguration.getRDFDescription(), clientConfiguration.getDynamicAttributeToken());
        this.addState(ProtocolState.IDSCP_START);
        this.addState(ProtocolState.IDSCP_ERROR);
        this.addState(ProtocolState.IDSCP_END);
        this.addState(ProtocolState.IDSCP_RAT_AWAIT_REQUEST);
        this.addState(ProtocolState.IDSCP_RAT_AWAIT_RESPONSE);
        this.addState(ProtocolState.IDSCP_RAT_AWAIT_RESULT);
        this.addState(ProtocolState.IDSCP_RAT_AWAIT_LEAVE);
        this.addState(ProtocolState.IDSCP_META_REQUEST);
        this.addState(ProtocolState.IDSCP_META_RESPONSE);
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.RAT_START, ProtocolState.IDSCP_START, ProtocolState.IDSCP_RAT_AWAIT_REQUEST, e -> this.replyProto(ratConsumerHandler.enterRatRequest((Event)e))));
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.RAT_REQUEST, ProtocolState.IDSCP_RAT_AWAIT_REQUEST, ProtocolState.IDSCP_RAT_AWAIT_RESPONSE, e -> this.replyProto(ratConsumerHandler.sendTPM2Ddata((Event)e))));
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.RAT_RESPONSE, ProtocolState.IDSCP_RAT_AWAIT_RESPONSE, ProtocolState.IDSCP_RAT_AWAIT_RESULT, e -> this.replyProto(ratConsumerHandler.sendResult((Event)e))));
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.RAT_RESULT, ProtocolState.IDSCP_RAT_AWAIT_RESULT, ProtocolState.IDSCP_RAT_AWAIT_LEAVE, e -> {
            MessageLite message = ratConsumerHandler.leaveRatRequest((Event)e);
            this.handleRatResult(ratConsumerHandler.handleAttestationResult(e.getMessage().getAttestationResult()));
            return this.replyProto(message);
        }));
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.RAT_LEAVE, ProtocolState.IDSCP_RAT_AWAIT_LEAVE, ProtocolState.IDSCP_META_REQUEST, e -> this.replyProto(metaHandler.request((Event)e))));
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.META_RESPONSE, ProtocolState.IDSCP_META_REQUEST, ProtocolState.IDSCP_END, e -> {
            Idscp.MedadataExchange mex = e.getMessage().getMetadataExchange();
            this.setMetaData(mex.getRdfdescription());
            this.setDynamicAttributeToken(mex.getDynamicAttributeToken());
            try {
                datVerifier.verify(this.getDynamicAttributeToken());
                LOG.info("DAT successfully verified.");
                return true;
            }
            catch (DatException de) {
                LOG.warn("Error during DAT verification", (Throwable)de);
                return false;
            }
        }));
        ProtocolState[] errorStartStates = new ProtocolState[]{ProtocolState.IDSCP_START, ProtocolState.IDSCP_RAT_AWAIT_REQUEST, ProtocolState.IDSCP_RAT_AWAIT_RESPONSE, ProtocolState.IDSCP_RAT_AWAIT_RESULT, ProtocolState.IDSCP_RAT_AWAIT_LEAVE, ProtocolState.IDSCP_META_REQUEST, ProtocolState.IDSCP_META_RESPONSE};
        Arrays.stream(errorStartStates).forEach(state -> this.addTransition(this.makeConsumerErrorTransition((ProtocolState)state, errorHandler)));
        this.addSuccessChangeListener((f, e) -> LOG.debug(String.format("Consumer State change: %s -> %s", e.getKey(), f.getState())));
        this.setInitialState(ProtocolState.IDSCP_START);
    }

    protected Transition makeConsumerErrorTransition(ProtocolState state, ErrorHandler errorHandler) {
        return new Transition((Object)Idscp.ConnectorMessage.Type.ERROR, state, ProtocolState.IDSCP_END, e -> errorHandler.handleError((Event)e, state, true));
    }

    private boolean replyProto(MessageLite message) {
        return this.reply(message.toByteArray());
    }

    private boolean reply(byte[] text) {
        this.clientSocket.sendBinaryFrame(text);
        return true;
    }
}

