/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.ws.protocol;

import java.util.concurrent.atomic.AtomicInteger;

public final class ProtocolState {
    private String id;
    private String description;
    public final int ord;
    private static AtomicInteger upperBound = new AtomicInteger(0);
    public static final ProtocolState IDSCP_START = new ProtocolState("IDSCP:START", "Idscp: start of protocol.");
    public static final ProtocolState IDSCP_ERROR = new ProtocolState("IDSCP:ERROR", "Idscp: error in protocol.");
    public static final ProtocolState IDSCP_END = new ProtocolState("IDSCP:END", "Idscp: end of protocol.");
    public static final ProtocolState IDSCP_RAT_AWAIT_RESPONSE = new ProtocolState("IDSCP:RAT:AWAIT_RESPONSE", "Idscp/RemoteAttestation: awaiting response.");
    public static final ProtocolState IDSCP_RAT_AWAIT_REQUEST = new ProtocolState("IDSCP:RAT:AWAIT_REQUEST", "Idscp/RemoteAttestation: awaiting request.");
    public static final ProtocolState IDSCP_RAT_AWAIT_RESULT = new ProtocolState("IDSCP:RAT:AWAIT_RESULT", "Idscp/RemoteAttestation: awaiting result.");
    public static final ProtocolState IDSCP_RAT_AWAIT_LEAVE = new ProtocolState("IDSCP:RAT:AWAIT_LEAVE", "Idscp/RemoteAttestation: awaiting to leave.");
    public static final ProtocolState IDSCP_META_REQUEST = new ProtocolState("IDSCP:META:REQUEST", "Idscp/Metadataexchange: request.");
    public static final ProtocolState IDSCP_META_RESPONSE = new ProtocolState("IDSCP:META:RESPONSE", "Idscp/Metadataexchange: response.");

    private ProtocolState(String id, String description) {
        this.id = id;
        this.description = description;
        this.ord = upperBound.getAndIncrement();
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.description;
    }

    public static int size() {
        return upperBound.get();
    }

    public String toString() {
        return this.description() + " (id: " + this.id() + ")";
    }
}

