/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.ws.protocol;

import com.google.protobuf.MessageLite;
import de.fhg.aisec.ids.comm.DatVerifier;
import de.fhg.aisec.ids.comm.server.ServerConfiguration;
import de.fhg.aisec.ids.comm.ws.protocol.ProtocolState;
import de.fhg.aisec.ids.comm.ws.protocol.error.ErrorHandler;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Event;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.FSM;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Transition;
import de.fhg.aisec.ids.comm.ws.protocol.metadata.MetadataProviderHandler;
import de.fhg.aisec.ids.comm.ws.protocol.rat.RemoteAttestationServerHandler;
import de.fhg.aisec.ids.messages.Idscp;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerProtocolMachine
extends FSM {
    private static final Logger LOG = LoggerFactory.getLogger(ServerProtocolMachine.class);
    private Session serverSession;
    private Idscp.AttestationResult attestationResult;

    public ServerProtocolMachine(Session sess, ServerConfiguration serverConfiguration, DatVerifier datVerifier) {
        this.serverSession = sess;
        URI ttp = serverConfiguration.getTrustedThirdPartyURI();
        RemoteAttestationServerHandler ratProviderHandler = new RemoteAttestationServerHandler(serverConfiguration, ttp, "/var/run/tpm2d/control.sock");
        ErrorHandler errorHandler = new ErrorHandler();
        MetadataProviderHandler metaHandler = new MetadataProviderHandler(serverConfiguration.getRDFDescription(), serverConfiguration.getDynamicAttributeToken());
        this.addState(ProtocolState.IDSCP_START);
        this.addState(ProtocolState.IDSCP_ERROR);
        this.addState(ProtocolState.IDSCP_END);
        this.addState(ProtocolState.IDSCP_RAT_AWAIT_REQUEST);
        this.addState(ProtocolState.IDSCP_RAT_AWAIT_RESPONSE);
        this.addState(ProtocolState.IDSCP_RAT_AWAIT_RESULT);
        this.addState(ProtocolState.IDSCP_RAT_AWAIT_LEAVE);
        this.addState(ProtocolState.IDSCP_META_REQUEST);
        this.addState(ProtocolState.IDSCP_META_RESPONSE);
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.RAT_REQUEST, ProtocolState.IDSCP_START, ProtocolState.IDSCP_RAT_AWAIT_RESPONSE, e -> this.replyProto(ratProviderHandler.enterRatRequest((Event)e))));
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.RAT_RESPONSE, ProtocolState.IDSCP_RAT_AWAIT_RESPONSE, ProtocolState.IDSCP_RAT_AWAIT_RESULT, e -> this.replyProto(ratProviderHandler.sendTPM2Ddata((Event)e))));
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.RAT_RESULT, ProtocolState.IDSCP_RAT_AWAIT_RESULT, ProtocolState.IDSCP_RAT_AWAIT_LEAVE, e -> {
            this.attestationResult = e.getMessage().getAttestationResult();
            return this.replyProto(ratProviderHandler.sendResult((Event)e));
        }));
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.RAT_LEAVE, ProtocolState.IDSCP_RAT_AWAIT_LEAVE, ProtocolState.IDSCP_META_REQUEST, e -> {
            MessageLite message = ratProviderHandler.leaveRatRequest((Event)e);
            this.handleRatResult(ratProviderHandler.handleAttestationResult(this.attestationResult));
            return this.replyProto(message);
        }));
        this.addTransition(new Transition((Object)Idscp.ConnectorMessage.Type.META_REQUEST, ProtocolState.IDSCP_META_REQUEST, ProtocolState.IDSCP_END, e -> {
            Idscp.MedadataExchange mex = e.getMessage().getMetadataExchange();
            this.setMetaData(mex.getRdfdescription());
            this.setDynamicAttributeToken(mex.getDynamicAttributeToken());
            try {
                datVerifier.verify(this.getDynamicAttributeToken());
                LOG.info("DAT successfully verified.");
                return this.replyProto(metaHandler.response((Event)e));
            }
            catch (Exception de) {
                LOG.warn("Error during DAT verification", (Throwable)de);
                this.replyProto((MessageLite)Idscp.ConnectorMessage.newBuilder().setId(-1L).setType(Idscp.ConnectorMessage.Type.ERROR).setError(Idscp.Error.newBuilder().setErrorCode("").setErrorMessage("DAT verification failed: " + de.getMessage()).build()).build());
                return false;
            }
        }));
        ProtocolState[] errorStartStates = new ProtocolState[]{ProtocolState.IDSCP_START, ProtocolState.IDSCP_RAT_AWAIT_REQUEST, ProtocolState.IDSCP_RAT_AWAIT_RESPONSE, ProtocolState.IDSCP_RAT_AWAIT_RESULT, ProtocolState.IDSCP_RAT_AWAIT_LEAVE, ProtocolState.IDSCP_META_REQUEST, ProtocolState.IDSCP_META_RESPONSE};
        Arrays.stream(errorStartStates).forEach(state -> this.addTransition(this.makeProviderErrorTransition((ProtocolState)state, errorHandler)));
        this.addSuccessChangeListener((f, e) -> LOG.debug(String.format("Provider State change: %s -> %s", e.getKey(), f.getState())));
        this.setInitialState(ProtocolState.IDSCP_START);
    }

    private Transition makeProviderErrorTransition(ProtocolState state, ErrorHandler errorHandler) {
        return new Transition((Object)Idscp.ConnectorMessage.Type.ERROR, state, ProtocolState.IDSCP_END, e -> {
            errorHandler.handleError((Event)e, state, false);
            LOG.debug("Client sending abort");
            Idscp.ConnectorMessage abortMessage = Idscp.ConnectorMessage.newBuilder().setId(0L).setType(Idscp.ConnectorMessage.Type.ERROR).setError(Idscp.Error.newBuilder().setErrorCode("").setErrorMessage("Abort").build()).build();
            return this.reply(abortMessage.toByteArray());
        });
    }

    private boolean replyProto(MessageLite message) {
        return this.reply(message.toByteArray());
    }

    private boolean reply(byte[] text) {
        try {
            ByteBuffer bb = ByteBuffer.wrap(text);
            LOG.trace("Sending out ByteBuffer with {} bytes", (Object)bb.array().length);
            this.serverSession.getRemote().sendBytes(bb);
            this.serverSession.getRemote().flush();
            return true;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

