/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.ws.protocol.fsm;

import de.fhg.aisec.ids.api.conm.RatResult;
import de.fhg.aisec.ids.comm.ws.protocol.ProtocolState;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.ChangeListener;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Event;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.State;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Transition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;

public class FSM {
    protected String currentState = null;
    protected Map<String, State> states = new HashMap<String, State>();
    protected HashSet<ChangeListener> successChangeListeners = new HashSet();
    protected HashSet<ChangeListener> failChangeListeners = new HashSet();
    private String initialState = null;
    private RatResult ratResult;
    private String metaData;
    private String dynamicAttributeToken;

    public String getState() {
        return this.currentState;
    }

    public void addState(ProtocolState state) {
        this.addState(state.id(), null, null, null);
    }

    public void addState(String state, Runnable entryCode, Runnable exitCode, Runnable alwaysRunCode) {
        if (this.states.size() == 0) {
            this.initialState = state;
            this.currentState = state;
        }
        if (this.states.containsKey(state)) {
            throw new NoSuchElementException("Missing state: " + state);
        }
        this.states.put(state, new State(entryCode, exitCode, alwaysRunCode));
    }

    public void setInitialState(ProtocolState state) {
        if (!this.states.containsKey(state.id())) {
            throw new NoSuchElementException("Missing state: " + state.id());
        }
        this.initialState = state.id();
    }

    public void reset() {
        this.currentState = this.initialState;
    }

    private void setState(String state) {
        boolean runExtraCode;
        boolean bl = runExtraCode = !state.equals(this.currentState);
        if (runExtraCode && this.currentState != null) {
            this.states.get(this.currentState).runExitCode();
        }
        this.currentState = state;
        this.states.get(this.currentState).runAlwaysCode();
        if (runExtraCode) {
            this.states.get(this.currentState).runEntryCode();
        }
        if (this.states.get((Object)this.currentState).transitions.containsKey(null)) {
            this.feedEvent(null);
        }
    }

    public void addTransition(Transition trans) {
        State st = this.states.get(trans.startState);
        if (st == null) {
            throw new NoSuchElementException("Missing start state: " + trans.startState);
        }
        if (!this.states.containsKey(trans.endState)) {
            throw new NoSuchElementException("Missing end state: " + trans.endState);
        }
        st.addTransition(trans);
    }

    public void addSuccessChangeListener(ChangeListener cl) {
        this.successChangeListeners.add(cl);
    }

    public void addFailChangeListener(ChangeListener cl) {
        this.failChangeListeners.add(cl);
    }

    public void feedEvent(Event event) {
        Object evtKey = event.getKey();
        State state = this.states.get(this.currentState);
        Transition trans = state.transitions.get(evtKey);
        if (trans != null) {
            if (trans.doBeforeTransition(event)) {
                this.setState(trans.endState);
                this.successChangeListeners.forEach(l -> l.stateChanged(this, event));
            } else {
                this.failChangeListeners.forEach(l -> l.stateChanged(this, event));
            }
        }
    }

    public String toDot() {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph finite_state_machine {\n");
        sb.append("\trankdir=LR;\n");
        sb.append("\tnode [shape = ellipse];\n");
        for (Map.Entry<String, State> from : this.states.entrySet()) {
            for (Object t : from.getValue().transitions.keySet()) {
                String to = from.getValue().transitions.get((Object)t).endState;
                Object eventKey = from.getValue().transitions.get((Object)t).event;
                sb.append("    " + from.getKey().replace(':', '_') + " -> " + to.replace(':', '_') + " [ label=\"" + eventKey + "\" ];\n");
            }
        }
        sb.append("\t\t\t}");
        return sb.toString();
    }

    public void handleRatResult(RatResult attestationResult) {
        this.ratResult = attestationResult;
    }

    public RatResult getRatResult() {
        return this.ratResult;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setDynamicAttributeToken(String dynamicAttributeToken) {
        this.dynamicAttributeToken = dynamicAttributeToken;
    }

    public String getDynamicAttributeToken() {
        return this.dynamicAttributeToken;
    }
}

