/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.ws.protocol.fsm;

import de.fhg.aisec.ids.comm.ws.protocol.fsm.Transition;
import java.util.HashMap;
import java.util.Map;

class State {
    Map<Object, Transition> transitions = new HashMap<Object, Transition>();
    Runnable entryCode;
    Runnable exitCode;
    Runnable alwaysRunCode;

    State(Runnable entryCode, Runnable exitCode, Runnable alwaysRunCode) {
        this.entryCode = entryCode;
        this.exitCode = exitCode;
        this.alwaysRunCode = alwaysRunCode;
    }

    public void addTransition(Transition trans) {
        if (this.transitions.containsKey(trans.event)) {
            throw new IllegalArgumentException("Transition for event " + trans.event + " already exists.");
        }
        this.transitions.put(trans.event, trans);
    }

    public void runEntryCode() {
        if (this.entryCode != null) {
            this.entryCode.run();
        }
    }

    public void runExitCode() {
        if (this.exitCode != null) {
            this.exitCode.run();
        }
    }

    public void runAlwaysCode() {
        if (this.alwaysRunCode != null) {
            this.alwaysRunCode.run();
        }
    }
}

