/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.ws.protocol.fsm;

import de.fhg.aisec.ids.comm.ws.protocol.ProtocolState;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Event;
import java.util.function.Function;
import org.slf4j.LoggerFactory;

public class Transition {
    final Object event;
    final String startState;
    final String endState;
    final Function<Event, Boolean> runBeforeTransition;

    public Transition(String eventName, String startState, String endState, Function<Event, Boolean> runBeforeTransition) {
        this.event = eventName;
        this.startState = startState;
        this.endState = endState;
        this.runBeforeTransition = runBeforeTransition;
    }

    public Transition(Object evtKey, String startState, String endState, Function<Event, Boolean> runBeforeTransition) {
        this.event = evtKey;
        this.startState = startState;
        this.endState = endState;
        this.runBeforeTransition = runBeforeTransition;
    }

    public Transition(Object evtKey, ProtocolState startState, ProtocolState endState, Function<Event, Boolean> runBeforeTransition) {
        this.event = evtKey;
        this.startState = startState.id();
        this.endState = endState.id();
        this.runBeforeTransition = runBeforeTransition;
    }

    protected boolean doBeforeTransition(Event event) {
        if (this.runBeforeTransition != null) {
            try {
                this.runBeforeTransition.apply(event);
            }
            catch (Throwable t) {
                LoggerFactory.getLogger((String)this.getClass().getName()).warn("Error in before-transition-procedure", t);
                return false;
            }
        }
        return true;
    }
}

