/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.ws.protocol.rat;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import de.fhg.aisec.ids.comm.CertificatePair;
import de.fhg.aisec.ids.comm.IdscpConfiguration;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Event;
import de.fhg.aisec.ids.comm.ws.protocol.rat.NonceGenerator;
import de.fhg.aisec.ids.comm.ws.protocol.rat.RemoteAttestationHandler;
import de.fhg.aisec.ids.messages.AttestationProtos;
import de.fhg.aisec.ids.messages.Idscp;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAttestationClientHandler
extends RemoteAttestationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAttestationClientHandler.class);
    private byte[] myNonce;
    private byte[] yourNonce;
    private AttestationProtos.IdsAttestationType aType;
    private long sessionID = 0L;
    private final URI ttpUri;
    private final int attestationMask;
    private final CertificatePair certificatePair;

    public RemoteAttestationClientHandler(@NonNull IdscpConfiguration clientConfiguration, @Nullable URI ttpUri, @Nullable String socket) {
        this.ttpUri = ttpUri;
        this.aType = clientConfiguration.getAttestationType();
        this.attestationMask = clientConfiguration.getAttestationMask();
        this.certificatePair = clientConfiguration.getCertificatePair();
    }

    public MessageLite enterRatRequest(@NonNull Event e) {
        this.myNonce = NonceGenerator.generate(20);
        this.sessionID = e.getMessage().getId();
        return Idscp.ConnectorMessage.newBuilder().setId(++this.sessionID).setType(Idscp.ConnectorMessage.Type.RAT_REQUEST).setAttestationRequest(Idscp.AttestationRequest.newBuilder().setAtype(this.aType).setNonce(ByteString.copyFrom((byte[])this.myNonce)).build()).build();
    }

    public MessageLite sendTPM2Ddata(@NonNull Event e) {
        this.yourNonce = e.getMessage().getAttestationRequest().getNonce().toByteArray();
        byte[] hash = RemoteAttestationClientHandler.calculateHash(this.yourNonce, this.certificatePair.getRemoteCertificate());
        if (++this.sessionID != e.getMessage().getId()) {
            return RemoteAttestationHandler.sendError(++this.sessionID, "Invalid session ID " + e.getMessage().getId());
        }
        String halg = "";
        ByteString quoted = ByteString.EMPTY;
        ByteString signature = ByteString.EMPTY;
        List pcrValues = Collections.emptyList();
        ByteString certificate = ByteString.EMPTY;
        if (this.tpm2dSocket != null) {
            try {
                AttestationProtos.RemoteToTpm2d.Builder msgBuilder = AttestationProtos.RemoteToTpm2d.newBuilder().setAtype(this.aType).setQualifyingData(ByteString.copyFrom((byte[])hash)).setCode(AttestationProtos.RemoteToTpm2d.Code.ATTESTATION_REQ).setPcrs(this.attestationMask);
                if (this.aType.equals((Object)AttestationProtos.IdsAttestationType.ADVANCED)) {
                    msgBuilder.setPcrs(this.attestationMask);
                }
                AttestationProtos.Tpm2dToRemote response = this.tpm2dSocket.requestAttestation(msgBuilder.build());
                halg = response.getHalg().name();
                quoted = response.getQuoted();
                signature = response.getSignature();
                pcrValues = response.getPcrValuesList();
                certificate = response.getCertificate();
            }
            catch (IOException ex) {
                lastError = "IOException during communication with tpm2d: " + ex.getMessage();
                LOG.error(lastError, (Throwable)ex);
            }
        } else {
            LOG.warn("Tpm2dSocket is not available. No TPM present?");
        }
        return Idscp.ConnectorMessage.newBuilder().setId(++this.sessionID).setType(Idscp.ConnectorMessage.Type.RAT_RESPONSE).setAttestationResponse(Idscp.AttestationResponse.newBuilder().setAtype(this.aType).setHalg(halg).setQuoted(quoted).setSignature(signature).addAllPcrValues(pcrValues).setCertificate(certificate).build()).build();
    }

    public MessageLite sendResult(@NonNull Event e) {
        byte[] hash = RemoteAttestationClientHandler.calculateHash(this.myNonce, this.certificatePair.getLocalCertificate());
        Idscp.AttestationResponse response = e.getMessage().getAttestationResponse();
        assert (response != null);
        if (++this.sessionID != e.getMessage().getId()) {
            lastError = "error: sessionID not correct ! (is " + e.getMessage().getId() + " but should have been " + (this.sessionID + 1L) + ")";
            LOG.debug(lastError);
            return RemoteAttestationHandler.sendError(++this.sessionID, RemoteAttestationHandler.lastError);
        }
        if (this.checkSignature(response, hash) && RemoteAttestationClientHandler.checkRepository(this.aType, response, this.ttpUri)) {
            this.mySuccess = true;
        } else {
            LOG.warn("Could not verify signature or could not validate PCR values via trusted third party. Remote attestation failed.");
        }
        return Idscp.ConnectorMessage.newBuilder().setId(++this.sessionID).setType(Idscp.ConnectorMessage.Type.RAT_RESULT).setAttestationResult(Idscp.AttestationResult.newBuilder().setAtype(this.aType).setResult(this.mySuccess).build()).build();
    }

    public MessageLite leaveRatRequest(@NonNull Event e) {
        if (++this.sessionID != e.getMessage().getId()) {
            lastError = "error: sessionID not correct ! (is " + e.getMessage().getId() + " but should have been " + (this.sessionID + 1L) + ")";
            LOG.debug(lastError);
            return RemoteAttestationHandler.sendError(++this.sessionID, RemoteAttestationHandler.lastError);
        }
        return Idscp.ConnectorMessage.newBuilder().setId(++this.sessionID).setType(Idscp.ConnectorMessage.Type.RAT_LEAVE).setAttestationLeave(Idscp.AttestationLeave.newBuilder().setAtype(this.aType).build()).build();
    }
}

