/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.ws.protocol.rat;

import com.google.protobuf.MessageLite;
import de.fhg.aisec.ids.api.conm.RatResult;
import de.fhg.aisec.ids.comm.ByteArrayUtil;
import de.fhg.aisec.ids.comm.ws.protocol.rat.RemoteAttestationClientHandler;
import de.fhg.aisec.ids.comm.ws.protocol.rat.Tpm2dSocket;
import de.fhg.aisec.ids.messages.Idscp;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tss.tpm.TPMS_ATTEST;
import tss.tpm.TPMS_SIGNATURE_RSAPSS;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMT_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

public class RemoteAttestationHandler {
    public static final String CONTROL_SOCKET = "/var/run/tpm2d/control.sock";
    protected static final Logger LOG = LoggerFactory.getLogger(RemoteAttestationClientHandler.class);
    static String lastError = "";
    private static long privateID = new Random().nextLong();
    boolean mySuccess = false;
    boolean yourSuccess = false;
    Tpm2dSocket tpm2dSocket;

    RemoteAttestationHandler() {
        try {
            String host = System.getenv("TPM_HOST") != null ? System.getenv("TPM_HOST") : "localhost";
            this.tpm2dSocket = new Tpm2dSocket(host);
        }
        catch (IOException e) {
            lastError = "Could not create Tpm2dSocket. No TPM present?";
            LOG.warn(lastError);
        }
    }

    public RatResult handleAttestationResult(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Idscp.AttestationResult result) {
        this.yourSuccess = result.getResult();
        LOG.debug("your success: {}    my success: {}", (Object)this.yourSuccess, (Object)this.mySuccess);
        if (!this.mySuccess) {
            return new RatResult(RatResult.Status.FAILED, "Could not verify");
        }
        if (!this.yourSuccess) {
            return new RatResult(RatResult.Status.FAILED, "Remote party did not verify successfully");
        }
        return new RatResult(RatResult.Status.SUCCESS, null);
    }

    static boolean checkRepository(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AttestationProtos.IdsAttestationType aType, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Idscp.AttestationResponse response, @Nullable URI ttpUri) {
        if (aType == null || response == null || ttpUri == null) {
            return false;
        }
        List values = response.getPcrValuesList();
        try {
            Idscp.ConnectorMessage msgRepo = RemoteAttestationHandler.readRepositoryResponse(Idscp.ConnectorMessage.newBuilder().setId(privateID).setType(Idscp.ConnectorMessage.Type.RAT_REPO_REQUEST).setAttestationRepositoryRequest(Idscp.AttestationRepositoryRequest.newBuilder().setAtype(aType).addAllPcrValues((Iterable)values).build()).build(), ttpUri.toURL());
            LOG.debug("//Q///////////////////////////////////////////////////////////////////////////");
            LOG.debug(response.toString());
            LOG.debug("//A///////////////////////////////////////////////////////////////////////////");
            LOG.debug(msgRepo.toString());
            LOG.debug("/////////////////////////////////////////////////////////////////////////////");
            return msgRepo.getAttestationRepositoryResponse().getResult() && msgRepo.getId() == privateID + 1L && msgRepo.getType().equals((Object)Idscp.ConnectorMessage.Type.RAT_REPO_RESPONSE);
        }
        catch (Exception ex) {
            lastError = "Exception: " + ex.getMessage();
            LOG.error("Exception in checkRepository(): ", (Throwable)ex);
            return false;
        }
    }

    static byte[] calculateHash(byte[] nonce, @Nullable Certificate certificate) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(nonce);
            if (certificate != null) {
                digest.update(certificate.getEncoded());
            } else {
                LOG.warn("No client certificate available. Cannot bind nonce to public key to prevent masquerading attack. TLS misconfiguration!");
            }
            return digest.digest();
        }
        catch (Exception e1) {
            LOG.error("Could not create hash of own nonce and local certificate", (Throwable)e1);
            return nonce;
        }
    }

    boolean checkSignature(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Idscp.AttestationResponse response, byte[] hash) {
        byte[] byteSignature = response.getSignature().toByteArray();
        byte[] byteCert = response.getCertificate().toByteArray();
        byte[] byteQuoted = response.getQuoted().toByteArray();
        if (LOG.isDebugEnabled()) {
            LOG.debug("signature: {}", (Object)ByteArrayUtil.toPrintableHexString(byteSignature));
            LOG.debug("cert: {}", (Object)ByteArrayUtil.toPrintableHexString(byteCert));
            LOG.debug("quoted: {}", (Object)ByteArrayUtil.toPrintableHexString(byteQuoted));
        }
        if (byteSignature.length == 0 || byteCert.length == 0 || byteQuoted.length == 0) {
            LOG.warn("Some required part (signature, cert or quoted) is empty!");
            return false;
        }
        try {
            byte[] tpmSig;
            int tpmSigHashAlg;
            TPMS_ATTEST tpmsAttest;
            TPMT_SIGNATURE tpmtSignature;
            X509Certificate rootCertificate;
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Path rootCertPath = FileSystems.getDefault().getPath("etc", "rootca-cert.pem");
            try (BufferedReader reader = Files.newBufferedReader(rootCertPath, StandardCharsets.US_ASCII);){
                StringBuilder builder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    if (!line.startsWith("-")) {
                        builder.append(line.trim());
                    }
                    line = reader.readLine();
                }
                byte[] rootCertBytes = Base64.getDecoder().decode(builder.toString());
                rootCertificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(rootCertBytes));
            }
            catch (Exception e) {
                LOG.error("Error parsing root certificate", (Throwable)e);
                return false;
            }
            X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(byteCert));
            try {
                certificate.verify(rootCertificate.getPublicKey());
            }
            catch (Exception e) {
                LOG.error("TPM certificate is invalid", (Throwable)e);
                return false;
            }
            try {
                tpmtSignature = TPMT_SIGNATURE.fromTpm((byte[])byteSignature);
            }
            catch (Exception ex) {
                LOG.warn("Could not create a TPMT_SIGNATURE from bytes:\n" + ByteArrayUtil.toPrintableHexString(byteSignature), (Throwable)ex);
                return false;
            }
            try {
                tpmsAttest = TPMS_ATTEST.fromTpm((byte[])byteQuoted);
            }
            catch (Exception ex) {
                LOG.warn("Could not create a TPMS_ATTEST from bytes:\n" + ByteArrayUtil.toPrintableHexString(byteQuoted), (Throwable)ex);
                return false;
            }
            byte[] extraBytes = tpmsAttest.extraData;
            if (!Arrays.equals(extraBytes, hash)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("The hash (extra data) in TPMS_ATTEST structure is invalid!\nextra data: {}\nhash: {}", (Object)ByteArrayUtil.toPrintableHexString(extraBytes), (Object)ByteArrayUtil.toPrintableHexString(hash));
                }
                return false;
            }
            int tpmSigAlg = tpmtSignature.GetUnionSelector_signature();
            if (tpmSigAlg == TPM_ALG_ID.RSAPSS.toInt()) {
                tpmSigHashAlg = ((TPMS_SIGNATURE_RSAPSS)tpmtSignature.signature).hash.toInt();
                tpmSig = ((TPMS_SIGNATURE_RSAPSS)tpmtSignature.signature).sig;
            } else if (tpmSigAlg == TPM_ALG_ID.RSASSA.toInt()) {
                tpmSigHashAlg = ((TPMS_SIGNATURE_RSASSA)tpmtSignature.signature).hash.toInt();
                tpmSig = ((TPMS_SIGNATURE_RSASSA)tpmtSignature.signature).sig;
            } else {
                throw new Exception("Unknown or unimplemented signature scheme: " + tpmtSignature.signature.getClass());
            }
            if (tpmSigHashAlg != TPM_ALG_ID.SHA256.toInt()) {
                throw new Exception("Only SHA256withRSA TPM signature hash algorithm is allowed!");
            }
            Signature sig = Signature.getInstance("SHA256withRSA");
            sig.initVerify(certificate.getPublicKey());
            sig.update(byteQuoted);
            boolean result = sig.verify(tpmSig);
            if (!result && LOG.isWarnEnabled()) {
                LOG.warn("Attestation signature invalid!");
            }
            return result;
        }
        catch (Exception ex) {
            LOG.warn("Error during attestation validation", (Throwable)ex);
            return false;
        }
    }

    static MessageLite sendError(long id, @Nullable String error) {
        if (error == null) {
            error = "";
        }
        return Idscp.ConnectorMessage.newBuilder().setId(id).setType(Idscp.ConnectorMessage.Type.ERROR).setError(Idscp.Error.newBuilder().setErrorCode("").setErrorMessage(error).build()).build();
    }

    private static Idscp.ConnectorMessage readRepositoryResponse(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull Idscp.ConnectorMessage msg, URL adr) throws IOException, GeneralSecurityException {
        HttpsURLConnection urlc = (HttpsURLConnection)adr.openConnection();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, null, null);
        urlc.setSSLSocketFactory(sslContext.getSocketFactory());
        urlc.setUseCaches(false);
        urlc.setDoInput(true);
        urlc.setDoOutput(true);
        urlc.setRequestMethod("POST");
        urlc.setRequestProperty("Accept", "application/x-protobuf");
        urlc.setRequestProperty("Content-Type", "application/x-protobuf");
        urlc.setRequestProperty("User-Agent", "IDS-Connector");
        urlc.setRequestProperty("Content-length", String.valueOf(msg.toByteArray().length));
        msg.writeTo(urlc.getOutputStream());
        return ((Idscp.ConnectorMessage.Builder)Idscp.ConnectorMessage.newBuilder().mergeFrom(urlc.getInputStream())).build();
    }
}

