/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.comm.ws.protocol.rat;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import de.fhg.aisec.ids.comm.CertificatePair;
import de.fhg.aisec.ids.comm.IdscpConfiguration;
import de.fhg.aisec.ids.comm.ws.protocol.fsm.Event;
import de.fhg.aisec.ids.comm.ws.protocol.rat.NonceGenerator;
import de.fhg.aisec.ids.comm.ws.protocol.rat.RemoteAttestationHandler;
import de.fhg.aisec.ids.messages.AttestationProtos;
import de.fhg.aisec.ids.messages.Idscp;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteAttestationServerHandler
extends RemoteAttestationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAttestationServerHandler.class);
    private byte[] myNonce;
    private byte[] yourNonce;
    private long sessionID = 0L;
    private final URI ttpUri;
    private final int attestationMask;
    private final AttestationProtos.IdsAttestationType aType;
    private final CertificatePair certificatePair;
    private Idscp.AttestationResponse resp;

    public RemoteAttestationServerHandler(IdscpConfiguration serverConfiguration, URI ttpUri, String socket) {
        this.ttpUri = ttpUri;
        this.aType = serverConfiguration.getAttestationType();
        this.attestationMask = serverConfiguration.getAttestationMask();
        this.certificatePair = serverConfiguration.getCertificatePair();
    }

    public MessageLite enterRatRequest(Event e) {
        this.yourNonce = e.getMessage().getAttestationRequest().getNonce().toByteArray();
        this.myNonce = NonceGenerator.generate(20);
        this.sessionID = e.getMessage().getId();
        return Idscp.ConnectorMessage.newBuilder().setId(++this.sessionID).setType(Idscp.ConnectorMessage.Type.RAT_REQUEST).setAttestationRequest(Idscp.AttestationRequest.newBuilder().setAtype(this.aType).setNonce(ByteString.copyFrom((byte[])this.myNonce)).build()).build();
    }

    public MessageLite sendTPM2Ddata(Event e) {
        this.resp = e.getMessage().getAttestationResponse();
        byte[] hash = RemoteAttestationServerHandler.calculateHash(this.yourNonce, this.certificatePair.getRemoteCertificate());
        if (++this.sessionID != e.getMessage().getId()) {
            return RemoteAttestationHandler.sendError(++this.sessionID, "error: sessionID not correct ! (is " + e.getMessage().getId() + " but should have been " + (this.sessionID + 1L) + ")");
        }
        String halg = "";
        ByteString quoted = ByteString.EMPTY;
        ByteString signature = ByteString.EMPTY;
        List pcrValues = Collections.emptyList();
        ByteString certificate = ByteString.EMPTY;
        if (this.tpm2dSocket != null) {
            try {
                AttestationProtos.RemoteToTpm2d.Builder msgBuilder = AttestationProtos.RemoteToTpm2d.newBuilder().setAtype(this.aType).setQualifyingData(ByteString.copyFrom((byte[])hash)).setCode(AttestationProtos.RemoteToTpm2d.Code.ATTESTATION_REQ).setPcrs(this.attestationMask);
                if (this.aType.equals((Object)AttestationProtos.IdsAttestationType.ADVANCED)) {
                    msgBuilder.setPcrs(this.attestationMask);
                }
                AttestationProtos.Tpm2dToRemote response = this.tpm2dSocket.requestAttestation(msgBuilder.build());
                LOG.debug("Tpm2dToRemote message: {}", (Object)response.toString());
                halg = response.getHalg().name();
                quoted = response.getQuoted();
                signature = response.getSignature();
                pcrValues = response.getPcrValuesList();
                certificate = response.getCertificate();
            }
            catch (IOException ex) {
                lastError = "IOException during communication with tpm2d: " + ex.getMessage();
                LOG.error(lastError, (Throwable)ex);
            }
        } else {
            LOG.warn("Tpm2dSocket is not available. No TPM present?");
        }
        return Idscp.ConnectorMessage.newBuilder().setId(++this.sessionID).setType(Idscp.ConnectorMessage.Type.RAT_RESPONSE).setAttestationResponse(Idscp.AttestationResponse.newBuilder().setAtype(this.aType).setHalg(halg).setQuoted(quoted).setSignature(signature).addAllPcrValues(pcrValues).setCertificate(certificate).build()).build();
    }

    public MessageLite sendResult(Event e) {
        byte[] hash = RemoteAttestationServerHandler.calculateHash(this.myNonce, this.certificatePair.getLocalCertificate());
        if (++this.sessionID == e.getMessage().getId()) {
            if (this.checkSignature(this.resp, hash) && RemoteAttestationServerHandler.checkRepository(this.aType, this.resp, this.ttpUri)) {
                this.mySuccess = true;
            } else {
                lastError = "error: signature check not ok";
            }
            return Idscp.ConnectorMessage.newBuilder().setId(++this.sessionID).setType(Idscp.ConnectorMessage.Type.RAT_RESULT).setAttestationResult(Idscp.AttestationResult.newBuilder().setAtype(this.aType).setResult(this.mySuccess).build()).build();
        }
        lastError = "error: sessionID not correct ! (is " + e.getMessage().getId() + " but should have been " + (this.sessionID + 1L) + ")";
        LOG.debug(lastError);
        return RemoteAttestationHandler.sendError(++this.sessionID, RemoteAttestationHandler.lastError);
    }

    public MessageLite leaveRatRequest(Event e) {
        this.yourSuccess = e.getMessage().getAttestationResult().getResult();
        if (++this.sessionID == e.getMessage().getId()) {
            return Idscp.ConnectorMessage.newBuilder().setId(++this.sessionID).setType(Idscp.ConnectorMessage.Type.RAT_LEAVE).setAttestationLeave(Idscp.AttestationLeave.newBuilder().setAtype(this.aType).build()).build();
        }
        lastError = "error: sessionID not correct ! (is " + e.getMessage().getId() + " but should have been " + (this.sessionID + 1L) + ")";
        LOG.debug(lastError);
        return RemoteAttestationHandler.sendError(++this.sessionID, RemoteAttestationHandler.lastError);
    }
}

