/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0013J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0015R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/fhg/aisec/ids/tpm2d/TpmHelper;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sr", "Ljava/security/SecureRandom;", "calculateHash", "", "nonce", "certificate", "Ljava/security/cert/Certificate;", "generateNonce", "numBytes", "", "loadCertificateFromKeystore", "Ljava/security/cert/X509Certificate;", "keyStorePath", "Ljava/nio/file/Path;", "keyStorePassword", "", "keyAlias", "", "loadCertificateFromPem", "path", "loadCertificatesFromTruststore", "", "trustStorePath", "trustStorePassword", "idscp2-rat-tpm2d"})
public final class TpmHelper {
    @NotNull
    public static final TpmHelper INSTANCE = new TpmHelper();
    private static final Logger LOG = LoggerFactory.getLogger(TpmHelper.class);
    @NotNull
    private static final SecureRandom sr = new SecureRandom();

    private TpmHelper() {
    }

    @NotNull
    public final byte[] generateNonce(int numBytes) {
        byte[] randBytes = new byte[numBytes];
        sr.nextBytes(randBytes);
        return randBytes;
    }

    @NotNull
    public final byte[] calculateHash(@NotNull byte[] nonce, @NotNull Certificate certificate) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(nonce);
            digest.update(certificate.getEncoded());
            byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n            val digest = MessageDigest.getInstance(\"SHA-1\")\n            digest.update(nonce)\n            digest.update(certificate.encoded)\n            digest.digest()\n        }");
        }
        catch (Exception e1) {
            LOG.error("Could not create hash of own nonce and local certificate", (Throwable)e1);
            byArray = nonce;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<X509Certificate> loadCertificatesFromTruststore(@NotNull Path trustStorePath, @NotNull char[] trustStorePassword) {
        Intrinsics.checkNotNullParameter((Object)trustStorePath, (String)"trustStorePath");
        Intrinsics.checkNotNullParameter((Object)trustStorePassword, (String)"trustStorePassword");
        Object object = KeyStore.getInstance("PKCS12");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(\"PKCS12\")");
        KeyStore ks = object;
        object = Files.newInputStream(trustStorePath, new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream keyStoreInputStream = (InputStream)object;
            boolean bl3 = false;
            ks.load(keyStoreInputStream, trustStorePassword);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Set<TrustAnchor> trustAnchors = new PKIXParameters(ks).getTrustAnchors();
        List<X509Certificate> list = trustAnchors.stream().map(TpmHelper::loadCertificatesFromTruststore$lambda-1).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"trustAnchors.stream().map { it.trustedCert }.collect(Collectors.toList())");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final X509Certificate loadCertificateFromKeystore(@NotNull Path keyStorePath, @NotNull char[] keyStorePassword, @NotNull String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)keyStorePath, (String)"keyStorePath");
        Intrinsics.checkNotNullParameter((Object)keyStorePassword, (String)"keyStorePassword");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        Closeable closeable = Files.newInputStream(keyStorePath, new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream keyStoreInputStream = (InputStream)closeable;
            boolean bl3 = false;
            ks.load(keyStoreInputStream, keyStorePassword);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Certificate certificate = ks.getCertificate(keyAlias);
        if (certificate == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
        }
        X509Certificate cert = (X509Certificate)certificate;
        ks.getKey(keyAlias, keyStorePassword);
        return cert;
    }

    @NotNull
    public final X509Certificate loadCertificateFromPem(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        FileInputStream ins = new FileInputStream(path.toFile());
        Certificate certificate = factory.generateCertificate(ins);
        if (certificate == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
        }
        return (X509Certificate)certificate;
    }

    private static final X509Certificate loadCertificatesFromTruststore$lambda-1(TrustAnchor it) {
        return it.getTrustedCert();
    }
}

