/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d;

import com.google.protobuf.ByteString;
import de.fhg.aisec.ids.tpm2d.messages.TpmAttestation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0014"}, d2={"Lde/fhg/aisec/ids/tpm2d/TpmMessageFactory;", "", "()V", "getAttestationChallengeMessage", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmMessage;", "nonce", "", "aType", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$IdsAttestationType;", "pcrIndices", "", "getAttestationResponseMessage", "response", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmToRemote;", "getAttestationResultMessage", "result", "", "getRemoteToTPM2dMessage", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$RemoteToTpm;", "hash", "idscp2-rat-tpm2d"})
public final class TpmMessageFactory {
    @NotNull
    public static final TpmMessageFactory INSTANCE = new TpmMessageFactory();

    private TpmMessageFactory() {
    }

    @NotNull
    public final TpmAttestation.TpmMessage getAttestationChallengeMessage(@NotNull byte[] nonce, @NotNull TpmAttestation.IdsAttestationType aType, int pcrIndices) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)((Object)aType), (String)"aType");
        TpmAttestation.TpmMessage tpmMessage = TpmAttestation.TpmMessage.newBuilder().setRatChallenge(TpmAttestation.TpmChallenge.newBuilder().setAtype(aType).setNonce(ByteString.copyFrom((byte[])nonce)).setPcrIndices(pcrIndices).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)tpmMessage, (String)"newBuilder().setRatChallenge(\n            TpmChallenge.newBuilder()\n                .setAtype(aType)\n                .setNonce(ByteString.copyFrom(nonce))\n                .setPcrIndices(pcrIndices)\n                .build()\n        ).build()");
        return tpmMessage;
    }

    @NotNull
    public final TpmAttestation.TpmMessage getAttestationResponseMessage(@NotNull TpmAttestation.TpmToRemote response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        TpmAttestation.TpmMessage tpmMessage = TpmAttestation.TpmMessage.newBuilder().setRatResponse(TpmAttestation.TpmResponse.newBuilder().setAtype(response.getAtype()).setHashAlg(response.getHalg().name()).setQuoted(response.getQuoted()).setSignature(response.getSignature()).addAllPcrValues((Iterable<? extends TpmAttestation.Pcr>)response.getPcrValuesList()).setCertificate(response.getCertificate()).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)tpmMessage, (String)"newBuilder().setRatResponse(\n            TpmResponse.newBuilder()\n                .setAtype(response.atype)\n                .setHashAlg(response.halg.name)\n                .setQuoted(response.quoted)\n                .setSignature(response.signature)\n                .addAllPcrValues(response.pcrValuesList)\n                .setCertificate(response.certificate)\n                .build()\n        ).build()");
        return tpmMessage;
    }

    @NotNull
    public final TpmAttestation.TpmMessage getAttestationResultMessage(boolean result) {
        TpmAttestation.TpmMessage tpmMessage = TpmAttestation.TpmMessage.newBuilder().setRatResult(TpmAttestation.TpmResult.newBuilder().setResult(result).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)tpmMessage, (String)"newBuilder().setRatResult(\n            TpmResult.newBuilder()\n                .setResult(result)\n                .build()\n        ).build()");
        return tpmMessage;
    }

    @NotNull
    public final TpmAttestation.RemoteToTpm getRemoteToTPM2dMessage(@NotNull TpmAttestation.IdsAttestationType aType, @NotNull byte[] hash, int pcrIndices) {
        Intrinsics.checkNotNullParameter((Object)((Object)aType), (String)"aType");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        TpmAttestation.RemoteToTpm remoteToTpm = TpmAttestation.RemoteToTpm.newBuilder().setAtype(aType).setQualifyingData(ByteString.copyFrom((byte[])hash)).setCode(TpmAttestation.RemoteToTpm.Code.ATTESTATION_REQ).setPcrs(pcrIndices).build();
        Intrinsics.checkNotNullExpressionValue((Object)remoteToTpm, (String)"newBuilder()\n            .setAtype(aType)\n            .setQualifyingData(ByteString.copyFrom(hash))\n            .setCode(RemoteToTpm.Code.ATTESTATION_REQ)\n            .setPcrs(pcrIndices)\n            .build()");
        return remoteToTpm;
    }
}

