/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d.tpm2d_verifier;

import de.fhg.aisec.ids.tpm2d.messages.TpmAttestation;
import de.fhg.aisec.ids.tpm2d.tpm2d_verifier.PcrValues;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jose4j.base64url.Base64;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/fhg/aisec/ids/tpm2d/tpm2d_verifier/PcrValues;", "", "pcrValues", "", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$Pcr;", "(Ljava/util/List;)V", "dat", "", "([B)V", "Lde/fhg/aisec/ids/tpm2d/tpm2d_verifier/PcrValues$PcrEntry;", "isTrusted", "", "goldenValues", "aType", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$IdsAttestationType;", "mask", "", "toString", "", "PcrEntry", "idscp2-rat-tpm2d"})
public final class PcrValues {
    @NotNull
    private final List<PcrEntry> pcrValues;

    /*
     * WARNING - void declaration
     */
    public PcrValues(@NotNull List<TpmAttestation.Pcr> pcrValues) {
        Collection<PcrEntry> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(pcrValues, (String)"pcrValues");
        if (pcrValues.size() > 24) {
            throw new IllegalArgumentException("Invalid number of pcr registers in TpmResponse");
        }
        Iterable iterable = pcrValues;
        PcrValues pcrValues2 = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TpmAttestation.Pcr pcr = (TpmAttestation.Pcr)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            int n = it.getNumber();
            byte[] byArray = it.getValue().toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.value.toByteArray()");
            PcrEntry pcrEntry = new PcrEntry(n, byArray);
            collection.add(pcrEntry);
        }
        collection = (List)destination$iv$iv;
        Iterable $this$sortedBy$iv = collection;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List list = Collections.unmodifiableList(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PcrEntry it = (PcrEntry)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getNumber());
                it = (PcrEntry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getNumber();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        }));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(\n            pcrValues.map { PcrEntry(it.number, it.value.toByteArray()) }.sortedBy { it.number }\n        )");
        pcrValues2.pcrValues = list;
    }

    /*
     * WARNING - void declaration
     */
    public PcrValues(@NotNull byte[] dat) {
        Collection<PcrEntry> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)dat, (String)"dat");
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        boolean bl = false;
        JwtClaims claims = jwtConsumer.processToClaims(new String(dat, charset));
        if (!claims.isClaimValueStringList("pcrGoldenValues")) {
            throw new IllegalArgumentException("DAT does not contain golden values");
        }
        List goldenValueList = claims.getStringListClaimValue("pcrGoldenValues");
        if (goldenValueList.size() != 24) {
            throw new IllegalArgumentException("Golden values are not complete");
        }
        Intrinsics.checkNotNullExpressionValue((Object)goldenValueList, (String)"goldenValueList");
        Iterable iterable = goldenValueList;
        PcrValues pcrValues = this;
        boolean $i$f$mapIndexed = false;
        void var8_10 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void n;
            void v;
            int n2 = index$iv$iv++;
            boolean bl2 = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n3 = n2;
            collection = destination$iv$iv;
            boolean bl3 = false;
            byte[] byArray = Base64.decode((String)v);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(v)");
            PcrEntry pcrEntry = new PcrEntry((int)n, byArray);
            collection.add(pcrEntry);
        }
        collection = (List)destination$iv$iv;
        List list = Collections.unmodifiableList(collection);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(\n            goldenValueList.mapIndexed { n, v ->\n                PcrEntry(n, Base64.decode(v))\n            }\n        )");
        pcrValues.pcrValues = list;
    }

    public final boolean isTrusted(@NotNull PcrValues goldenValues, @NotNull TpmAttestation.IdsAttestationType aType, int mask) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)goldenValues, (String)"goldenValues");
        Intrinsics.checkNotNullParameter((Object)((Object)aType), (String)"aType");
        TpmAttestation.IdsAttestationType idsAttestationType = aType;
        int n3 = WhenMappings.$EnumSwitchMapping$0[idsAttestationType.ordinal()];
        switch (n3) {
            case 1: {
                n2 = 12;
                break;
            }
            case 2: {
                n2 = 24;
                break;
            }
            case 3: {
                if (mask < 1) {
                    throw new IllegalArgumentException("Requested advanced PCR comparison with invalid PCR mask");
                }
                n = mask;
                boolean bl = false;
                n2 = Integer.bitCount(n);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int count = n2;
        if (this.pcrValues.size() < count) {
            throw new IllegalArgumentException("Expected " + count + " PCR values, but only " + this.pcrValues.size() + " values are available.");
        }
        if (aType == TpmAttestation.IdsAttestationType.ADVANCED) {
            n3 = mask;
            n = 0;
            BigInteger bigInteger = BigInteger.valueOf(n3);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.valueOf(this.toLong())");
            BigInteger biMask = bigInteger;
            Iterable $this$forEach$iv = this.pcrValues;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PcrEntry it = (PcrEntry)element$iv;
                boolean bl = false;
                if (!biMask.testBit(it.getNumber()) || Intrinsics.areEqual((Object)it, (Object)goldenValues.pcrValues.get(it.getNumber()))) continue;
                return false;
            }
        } else {
            int n4 = 0;
            if (n4 < count) {
                do {
                    int i;
                    if (Intrinsics.areEqual((Object)this.pcrValues.get(i = n4++), (Object)goldenValues.pcrValues.get(i))) continue;
                    return false;
                } while (n4 < count);
            }
        }
        return true;
    }

    @NotNull
    public String toString() {
        return "PCR {\n" + CollectionsKt.joinToString$default((Iterable)this.pcrValues, (CharSequence)"\n", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null) + "\n}";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lde/fhg/aisec/ids/tpm2d/tpm2d_verifier/PcrValues$PcrEntry;", "", "number", "", "value", "", "(I[B)V", "getNumber", "()I", "getValue", "()[B", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "idscp2-rat-tpm2d"})
    public static final class PcrEntry {
        private final int number;
        @NotNull
        private final byte[] value;

        public PcrEntry(int number, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.number = number;
            this.value = value;
        }

        public final int getNumber() {
            return this.number;
        }

        @NotNull
        public final byte[] getValue() {
            return this.value;
        }

        public boolean equals(@Nullable Object other) {
            Object object;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.fhg.aisec.ids.tpm2d.tpm2d_verifier.PcrValues.PcrEntry");
            }
            PcrEntry cfr_ignored_0 = (PcrEntry)other;
            if (this.number != ((PcrEntry)other).number) {
                return false;
            }
            object = this.value;
            byte[] byArray = ((PcrEntry)other).value;
            boolean bl = false;
            return Arrays.equals((byte[])object, byArray);
        }

        public int hashCode() {
            int result = this.number;
            byte[] byArray = this.value;
            boolean bl = false;
            result = 31 * result + Arrays.hashCode(byArray);
            return result;
        }

        public final int component1() {
            return this.number;
        }

        @NotNull
        public final byte[] component2() {
            return this.value;
        }

        @NotNull
        public final PcrEntry copy(int number, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new PcrEntry(number, value);
        }

        public static /* synthetic */ PcrEntry copy$default(PcrEntry pcrEntry, int n, byte[] byArray, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = pcrEntry.number;
            }
            if ((n2 & 2) != 0) {
                byArray = pcrEntry.value;
            }
            return pcrEntry.copy(n, byArray);
        }

        @NotNull
        public String toString() {
            return "PcrEntry(number=" + this.number + ", value=" + Arrays.toString(this.value) + ")";
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TpmAttestation.IdsAttestationType.values().length];
            nArray[TpmAttestation.IdsAttestationType.BASIC.ordinal()] = 1;
            nArray[TpmAttestation.IdsAttestationType.ALL.ordinal()] = 2;
            nArray[TpmAttestation.IdsAttestationType.ADVANCED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

