/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d.tpm2d_verifier;

import de.fhg.aisec.ids.idscp2.idscp_core.drivers.RatVerifierDriver;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.InternalControlMessage;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.RatVerifierFsmListener;
import de.fhg.aisec.ids.tpm2d.TpmException;
import de.fhg.aisec.ids.tpm2d.TpmHelper;
import de.fhg.aisec.ids.tpm2d.TpmMessageFactory;
import de.fhg.aisec.ids.tpm2d.UtilsKt;
import de.fhg.aisec.ids.tpm2d.messages.TpmAttestation;
import de.fhg.aisec.ids.tpm2d.tpm2d_verifier.PcrValues;
import de.fhg.aisec.ids.tpm2d.tpm2d_verifier.TpmVerifierConfig;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tss.tpm.TPMS_ATTEST;
import tss.tpm.TPMS_QUOTE_INFO;
import tss.tpm.TPMS_SIGNATURE_RSAPSS;
import tss.tpm.TPMS_SIGNATURE_RSASSA;
import tss.tpm.TPMT_SIGNATURE;
import tss.tpm.TPMU_ATTEST;
import tss.tpm.TPMU_SIGNATURE;
import tss.tpm.TPM_ALG_ID;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/fhg/aisec/ids/tpm2d/tpm2d_verifier/TpmVerifier;", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/RatVerifierDriver;", "Lde/fhg/aisec/ids/tpm2d/tpm2d_verifier/TpmVerifierConfig;", "fsmListener", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RatVerifierFsmListener;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/RatVerifierFsmListener;)V", "config", "queue", "Ljava/util/concurrent/BlockingQueue;", "", "checkPcrValues", "", "response", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmResponse;", "checkSignature", "hash", "delegate", "", "message", "run", "sendRatResult", "result", "setConfig", "waitForProverMsg", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$TpmMessage;", "Companion", "idscp2-rat-tpm2d"})
public final class TpmVerifier
extends RatVerifierDriver<TpmVerifierConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<byte[]> queue;
    private TpmVerifierConfig config;
    @NotNull
    public static final String ID = "TPM";
    private static final Logger LOG = LoggerFactory.getLogger(TpmVerifier.class);

    public TpmVerifier(@NotNull RatVerifierFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        super(fsmListener);
        this.queue = new LinkedBlockingQueue();
    }

    public void setConfig(@NotNull TpmVerifierConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public void delegate(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Delegated TPM prover message to TPM verifier");
        }
        this.queue.add(message);
    }

    private final TpmAttestation.TpmMessage waitForProverMsg() {
        try {
            byte[] msg = this.queue.take();
            TpmAttestation.TpmMessage tpmMessage = TpmAttestation.TpmMessage.parseFrom(msg);
            Intrinsics.checkNotNullExpressionValue((Object)tpmMessage, (String)"parseFrom(msg)");
            return tpmMessage;
        }
        catch (Exception e) {
            if (this.getRunning()) {
                this.getFsmListener().onRatVerifierMessage(InternalControlMessage.RAT_VERIFIER_FAILED);
            }
            throw new TpmException("Interrupted or invalid message", e);
        }
    }

    private final void sendRatResult(boolean result) {
        byte[] ratResult = TpmMessageFactory.INSTANCE.getAttestationResultMessage(result).toByteArray();
        RatVerifierFsmListener ratVerifierFsmListener = this.getFsmListener();
        Intrinsics.checkNotNullExpressionValue((Object)ratResult, (String)"ratResult");
        ratVerifierFsmListener.onRatVerifierMessage(InternalControlMessage.RAT_VERIFIER_MSG, ratResult);
        if (result) {
            this.getFsmListener().onRatVerifierMessage(InternalControlMessage.RAT_VERIFIER_OK);
        } else {
            this.getFsmListener().onRatVerifierMessage(InternalControlMessage.RAT_VERIFIER_FAILED);
        }
    }

    public void run() {
        try {
            byte[] nonce;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Generate and send TPM challenge to remote TPM prover");
            }
            byte[] byArray = nonce = TpmHelper.INSTANCE.generateNonce(20);
            boolean bl = false;
            String string = Arrays.toString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
            LOG.debug("Challenge nonce is: " + string);
            TpmVerifierConfig tpmVerifierConfig = this.config;
            if (tpmVerifierConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            TpmAttestation.IdsAttestationType idsAttestationType = tpmVerifierConfig.getExpectedAType();
            tpmVerifierConfig = this.config;
            if (tpmVerifierConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            byte[] ratChallenge = TpmMessageFactory.INSTANCE.getAttestationChallengeMessage(nonce, idsAttestationType, tpmVerifierConfig.getExpectedAttestationMask()).toByteArray();
            RatVerifierFsmListener ratVerifierFsmListener = this.getFsmListener();
            Intrinsics.checkNotNullExpressionValue((Object)ratChallenge, (String)"ratChallenge");
            ratVerifierFsmListener.onRatVerifierMessage(InternalControlMessage.RAT_VERIFIER_MSG, ratChallenge);
            LOG.debug("Wait for RAT prover message with TPM attestation response");
            TpmAttestation.TpmMessage ratProverMsg = this.waitForProverMsg();
            if (!ratProverMsg.hasRatResponse()) {
                this.getFsmListener().onRatVerifierMessage(InternalControlMessage.RAT_VERIFIER_FAILED);
                throw new TpmException("Missing TPM challenge response");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got TPM challenge response. Start validation ...");
            }
            TpmAttestation.TpmResponse resp = ratProverMsg.getRatResponse();
            Intrinsics.checkNotNullExpressionValue((Object)resp, (String)"resp");
            TpmVerifierConfig tpmVerifierConfig2 = this.config;
            if (tpmVerifierConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            if (!this.checkSignature(resp, TpmHelper.INSTANCE.calculateHash(nonce, tpmVerifierConfig2.getLocalCertificate()))) {
                this.sendRatResult(false);
                throw new TpmException("Invalid TPM signature");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("TPM signature valid and certificate trusted");
            }
            if (!this.checkPcrValues(resp)) {
                this.sendRatResult(false);
                throw new TpmException("Mismatch between PCR values and golden values");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("PCR values trusted");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("TPM verification succeed");
            }
            this.sendRatResult(true);
        }
        catch (Throwable t) {
            LOG.error("Error in TPM Verifier", t);
            throw t;
        }
    }

    private final boolean checkPcrValues(TpmAttestation.TpmResponse response) {
        try {
            TpmVerifierConfig tpmVerifierConfig;
            List<TpmAttestation.Pcr> list = response.getPcrValuesList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"response.pcrValuesList");
            PcrValues pcrValues = new PcrValues(list);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Peer PCR values from TPM response: " + pcrValues);
            }
            PcrValues goldenValues = new PcrValues(this.getFsmListener().getRemotePeerDat());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Golden values from DAPS: " + goldenValues);
            }
            if ((tpmVerifierConfig = this.config) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            TpmAttestation.IdsAttestationType idsAttestationType = tpmVerifierConfig.getExpectedAType();
            tpmVerifierConfig = this.config;
            if (tpmVerifierConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            return pcrValues.isTrusted(goldenValues, idsAttestationType, tpmVerifierConfig.getExpectedAttestationMask());
        }
        catch (Exception e) {
            LOG.error("Cannot check PCR values against golden values", (Throwable)e);
            return false;
        }
    }

    private final boolean checkSignature(TpmAttestation.TpmResponse response, byte[] hash) {
        boolean bl;
        byte[] byteQuoted;
        byte[] byteCert;
        byte[] byteSignature;
        block31: {
            block30: {
                byteSignature = response.getSignature().toByteArray();
                byteCert = response.getCertificate().toByteArray();
                byteQuoted = response.getQuoted().toByteArray();
                if (LOG.isTraceEnabled()) {
                    Intrinsics.checkNotNullExpressionValue((Object)byteSignature, (String)"byteSignature");
                    LOG.trace("signature: {}", (Object)UtilsKt.toHexString(byteSignature));
                    Intrinsics.checkNotNullExpressionValue((Object)byteCert, (String)"byteCert");
                    LOG.trace("cert: {}", (Object)UtilsKt.toHexString(byteCert));
                    Intrinsics.checkNotNullExpressionValue((Object)byteQuoted, (String)"byteQuoted");
                    LOG.trace("quoted: {}", (Object)UtilsKt.toHexString(byteQuoted));
                }
                Intrinsics.checkNotNullExpressionValue((Object)byteSignature, (String)"byteSignature");
                byte[] byArray = byteSignature;
                boolean bl2 = false;
                if (byArray.length == 0) break block30;
                Intrinsics.checkNotNullExpressionValue((Object)byteCert, (String)"byteCert");
                byArray = byteCert;
                bl2 = false;
                if (byArray.length == 0) break block30;
                Intrinsics.checkNotNullExpressionValue((Object)byteQuoted, (String)"byteQuoted");
                byArray = byteQuoted;
                bl2 = false;
                if (!(byArray.length == 0)) break block31;
            }
            LOG.warn("Some required part (signature, cert or quoted) is empty!");
            return false;
        }
        try {
            byte[] extraBytes;
            TPMS_ATTEST ex2;
            X509Certificate caCert2;
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certFactory.generateCertificate(new ByteArrayInputStream(byteCert));
            if (certificate == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            X509Certificate certificate2 = (X509Certificate)certificate;
            TpmVerifierConfig tpmVerifierConfig = this.config;
            if (tpmVerifierConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                throw null;
            }
            List<X509Certificate> rootCertificates = tpmVerifierConfig.getCaCertificates();
            String certificateIssuer = certificate2.getIssuerDN().getName();
            boolean trusted = false;
            for (X509Certificate caCert2 : rootCertificates) {
                if (!Intrinsics.areEqual((Object)caCert2.getSubjectDN().getName(), (Object)certificateIssuer)) continue;
                try {
                    certificate2.verify(caCert2.getPublicKey());
                    trusted = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (!trusted) {
                LOG.warn("TPM Certificate is not trusted");
                return false;
            }
            try {
                caCert2 = TPMT_SIGNATURE.fromBytes((byte[])byteSignature);
                Intrinsics.checkNotNullExpressionValue((Object)caCert2, (String)"{\n                TPMT_SIGNATURE.fromBytes(byteSignature)\n            }");
            }
            catch (Exception ex2) {
                LOG.warn(StringsKt.trimIndent((String)("\n                Could not create a TPMT_SIGNATURE from bytes:\n                " + UtilsKt.toHexString(byteSignature) + "\n                    ")), (Throwable)ex2);
                return false;
            }
            X509Certificate tpmtSignature = caCert2;
            try {
                ex2 = TPMS_ATTEST.fromBytes((byte[])byteQuoted);
                Intrinsics.checkNotNullExpressionValue((Object)ex2, (String)"{\n                TPMS_ATTEST.fromBytes(byteQuoted)\n            }");
            }
            catch (Exception ex3) {
                LOG.warn(StringsKt.trimIndent((String)("\n                Could not create a TPMS_ATTEST from bytes:\n                " + UtilsKt.toHexString(byteQuoted) + "\n                    ")), (Throwable)ex3);
                return false;
            }
            TPMS_ATTEST tpmsAttest = ex2;
            TPMU_ATTEST ex3 = tpmsAttest.attested;
            if (ex3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type tss.tpm.TPMS_QUOTE_INFO");
            }
            TPMS_QUOTE_INFO attested = (TPMS_QUOTE_INFO)ex3;
            Object object = MessageDigest.getInstance("SHA-256");
            boolean bl3 = false;
            boolean bl4 = false;
            MessageDigest $this$checkSignature_u24lambda_u2d1 = object;
            boolean $i$a$-apply-TpmVerifier$checkSignature$digest$22 = false;
            List<TpmAttestation.Pcr> list = response.getPcrValuesList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"response.pcrValuesList");
            Object $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                TpmAttestation.Pcr it = (TpmAttestation.Pcr)element$iv;
                boolean bl5 = false;
                $this$checkSignature_u24lambda_u2d1.update(it.getValue().toByteArray());
            }
            byte[] digest = ((MessageDigest)object).digest();
            object = digest;
            byte[] byArray = attested.pcrDigest;
            bl4 = false;
            if (!Arrays.equals((byte[])object, byArray)) {
                object = attested.pcrDigest;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"attested.pcrDigest");
                String string = UtilsKt.toHexString((byte[])object);
                Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
                LOG.warn("PCR digest {} does not match SHA-256 hash {} over PCR list", (Object)string, (Object)UtilsKt.toHexString(digest));
            }
            if (!Arrays.equals(extraBytes = tpmsAttest.extraData, hash)) {
                Intrinsics.checkNotNullExpressionValue((Object)extraBytes, (String)"extraBytes");
                LOG.warn("The hash (extra data) in TPMS_ATTEST structure is invalid!\nextra data: {}\nhash: {}", (Object)UtilsKt.toHexString(extraBytes), (Object)UtilsKt.toHexString(hash));
                return false;
            }
            TPM_ALG_ID tpmSigAlg = tpmtSignature.sigAlg();
            int tpmSigHashAlg = 0;
            Object tpmSig = null;
            TPM_ALG_ID $i$a$-apply-TpmVerifier$checkSignature$digest$22 = tpmSigAlg;
            if (Intrinsics.areEqual((Object)$i$a$-apply-TpmVerifier$checkSignature$digest$22, (Object)TPM_ALG_ID.RSAPSS)) {
                $this$forEach$iv = ((TPMT_SIGNATURE)tpmtSignature).signature;
                if ($this$forEach$iv == null) {
                    throw new NullPointerException("null cannot be cast to non-null type tss.tpm.TPMS_SIGNATURE_RSAPSS");
                }
                tpmSigHashAlg = ((TPMS_SIGNATURE_RSAPSS)$this$forEach$iv).hash.toInt();
                TPMU_SIGNATURE tPMU_SIGNATURE = ((TPMT_SIGNATURE)tpmtSignature).signature;
                if (tPMU_SIGNATURE == null) {
                    throw new NullPointerException("null cannot be cast to non-null type tss.tpm.TPMS_SIGNATURE_RSAPSS");
                }
                $this$forEach$iv = ((TPMS_SIGNATURE_RSAPSS)tPMU_SIGNATURE).sig;
                Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"tpmtSignature.signature as TPMS_SIGNATURE_RSAPSS).sig");
                tpmSig = $this$forEach$iv;
            } else if (Intrinsics.areEqual((Object)$i$a$-apply-TpmVerifier$checkSignature$digest$22, (Object)TPM_ALG_ID.RSASSA)) {
                $this$forEach$iv = ((TPMT_SIGNATURE)tpmtSignature).signature;
                if ($this$forEach$iv == null) {
                    throw new NullPointerException("null cannot be cast to non-null type tss.tpm.TPMS_SIGNATURE_RSASSA");
                }
                tpmSigHashAlg = ((TPMS_SIGNATURE_RSASSA)$this$forEach$iv).hash.toInt();
                TPMU_SIGNATURE tPMU_SIGNATURE = ((TPMT_SIGNATURE)tpmtSignature).signature;
                if (tPMU_SIGNATURE == null) {
                    throw new NullPointerException("null cannot be cast to non-null type tss.tpm.TPMS_SIGNATURE_RSASSA");
                }
                $this$forEach$iv = ((TPMS_SIGNATURE_RSASSA)tPMU_SIGNATURE).sig;
                Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"tpmtSignature.signature as TPMS_SIGNATURE_RSASSA).sig");
                tpmSig = $this$forEach$iv;
            } else {
                LOG.warn("Unknown or unimplemented signature scheme: " + ((TPMT_SIGNATURE)tpmtSignature).signature.getClass());
                return false;
            }
            if (tpmSigHashAlg != TPM_ALG_ID.SHA256.toInt()) {
                LOG.warn("Only SHA256withRSA TPM signature hash algorithm is allowed");
                return false;
            }
            Signature sig = Signature.getInstance("SHA256withRSA");
            sig.initVerify(certificate2.getPublicKey());
            sig.update(byteQuoted);
            boolean result = sig.verify((byte[])tpmSig);
            if (!result && LOG.isWarnEnabled()) {
                LOG.warn("Attestation signature invalid!");
            }
            bl = result;
        }
        catch (Exception ex) {
            LOG.warn("Error during attestation validation", (Throwable)ex);
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lde/fhg/aisec/ids/tpm2d/tpm2d_verifier/TpmVerifier$Companion;", "", "()V", "ID", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2-rat-tpm2d"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

