/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.tpm2d.tpm2d_verifier;

import de.fhg.aisec.ids.tpm2d.TpmHelper;
import de.fhg.aisec.ids.tpm2d.messages.TpmAttestation;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lde/fhg/aisec/ids/tpm2d/tpm2d_verifier/TpmVerifierConfig;", "", "()V", "<set-?>", "", "Ljava/security/cert/X509Certificate;", "caCertificates", "getCaCertificates", "()Ljava/util/List;", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$IdsAttestationType;", "expectedAType", "getExpectedAType", "()Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$IdsAttestationType;", "", "expectedAttestationMask", "getExpectedAttestationMask", "()I", "localCertificate", "getLocalCertificate", "()Ljava/security/cert/X509Certificate;", "Builder", "idscp2-rat-tpm2d"})
public final class TpmVerifierConfig {
    private X509Certificate localCertificate;
    private List<? extends X509Certificate> caCertificates;
    @NotNull
    private TpmAttestation.IdsAttestationType expectedAType = TpmAttestation.IdsAttestationType.BASIC;
    private int expectedAttestationMask;

    private TpmVerifierConfig() {
    }

    @NotNull
    public final X509Certificate getLocalCertificate() {
        X509Certificate x509Certificate = this.localCertificate;
        if (x509Certificate != null) {
            return x509Certificate;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"localCertificate");
        throw null;
    }

    @NotNull
    public final List<X509Certificate> getCaCertificates() {
        List<X509Certificate> list = this.caCertificates;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"caCertificates");
        throw null;
    }

    @NotNull
    public final TpmAttestation.IdsAttestationType getExpectedAType() {
        return this.expectedAType;
    }

    public final int getExpectedAttestationMask() {
        return this.expectedAttestationMask;
    }

    public /* synthetic */ TpmVerifierConfig(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/fhg/aisec/ids/tpm2d/tpm2d_verifier/TpmVerifierConfig$Builder;", "", "()V", "caCertificates", "", "Ljava/security/cert/X509Certificate;", "config", "Lde/fhg/aisec/ids/tpm2d/tpm2d_verifier/TpmVerifierConfig;", "addRootCaCertificate", "cert", "addRootCaCertificateFromPem", "certPath", "Ljava/nio/file/Path;", "addRootCaCertificates", "truststore", "trustStorePwd", "", "build", "setExpectedAttestationMask", "mask", "", "setExpectedAttestationType", "aType", "Lde/fhg/aisec/ids/tpm2d/messages/TpmAttestation$IdsAttestationType;", "setLocalCertificate", "localCert", "idscp2-rat-tpm2d"})
    public static final class Builder {
        @NotNull
        private final TpmVerifierConfig config = new TpmVerifierConfig(null);
        @NotNull
        private final List<X509Certificate> caCertificates;

        public Builder() {
            boolean bl = false;
            this.caCertificates = new ArrayList();
        }

        @NotNull
        public final Builder setLocalCertificate(@NotNull X509Certificate localCert) {
            Intrinsics.checkNotNullParameter((Object)localCert, (String)"localCert");
            this.config.localCertificate = localCert;
            return this;
        }

        @NotNull
        public final Builder addRootCaCertificates(@NotNull Path truststore, @NotNull char[] trustStorePwd) {
            Intrinsics.checkNotNullParameter((Object)truststore, (String)"truststore");
            Intrinsics.checkNotNullParameter((Object)trustStorePwd, (String)"trustStorePwd");
            this.caCertificates.addAll((Collection<X509Certificate>)TpmHelper.INSTANCE.loadCertificatesFromTruststore(truststore, trustStorePwd));
            return this;
        }

        @NotNull
        public final Builder addRootCaCertificate(@NotNull X509Certificate cert) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            this.caCertificates.add(cert);
            return this;
        }

        @NotNull
        public final Builder addRootCaCertificateFromPem(@NotNull Path certPath) {
            Intrinsics.checkNotNullParameter((Object)certPath, (String)"certPath");
            this.caCertificates.add(TpmHelper.INSTANCE.loadCertificateFromPem(certPath));
            return this;
        }

        @NotNull
        public final Builder setExpectedAttestationType(@NotNull TpmAttestation.IdsAttestationType aType) {
            Intrinsics.checkNotNullParameter((Object)((Object)aType), (String)"aType");
            this.config.expectedAType = aType;
            return this;
        }

        @NotNull
        public final Builder setExpectedAttestationMask(int mask) {
            this.config.expectedAttestationMask = mask;
            return this;
        }

        @NotNull
        public final TpmVerifierConfig build() {
            List<X509Certificate> list = Collections.unmodifiableList(this.caCertificates);
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(caCertificates)");
            this.config.caCertificates = list;
            return this.config;
        }
    }
}

