/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common.attributes;

import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.AttributeExtractor;
import de.flapdoodle.os.common.attributes.MappedTextFile;
import de.flapdoodle.os.common.attributes.MappedTextFileResolver;
import de.flapdoodle.os.common.attributes.SystemProperty;
import de.flapdoodle.os.common.attributes.SystemPropertyResolver;
import de.flapdoodle.os.common.attributes.TextFile;
import de.flapdoodle.os.common.attributes.TextFileResolver;
import de.flapdoodle.os.common.attributes.TypeCheckPredicate;
import java.util.Optional;

@FunctionalInterface
public interface AttributeExtractorLookup {
    public <T, A extends Attribute<T>> Optional<AttributeExtractor<T, A>> extractor(A var1);

    default public AttributeExtractorLookup join(final AttributeExtractorLookup other) {
        final AttributeExtractorLookup that = this;
        return new AttributeExtractorLookup(){

            @Override
            public <T, A extends Attribute<T>> Optional<AttributeExtractor<T, A>> extractor(A attribute) {
                Optional first = that.extractor(attribute);
                if (first.isPresent()) {
                    return first;
                }
                return other.extractor(attribute);
            }
        };
    }

    public static <T, A extends Attribute<T>> AttributeExtractorLookup with(final TypeCheckPredicate<? super A> attributeTypeCheck, final AttributeExtractor<T, A> extractor) {
        return new AttributeExtractorLookup(){

            public <_T, _A extends Attribute<_T>> Optional<AttributeExtractor<_T, _A>> extractor(_A attribute) {
                return attributeTypeCheck.test(attribute) ? Optional.of(extractor) : Optional.empty();
            }
        };
    }

    public static AttributeExtractorLookup failing() {
        return new AttributeExtractorLookup(){

            @Override
            public <T, A extends Attribute<T>> Optional<AttributeExtractor<T, A>> extractor(A attribute) {
                throw new IllegalArgumentException("no attribute extractor for " + attribute + "(" + attribute.getClass() + ")");
            }
        };
    }

    public static AttributeExtractorLookup systemDefault() {
        return AttributeExtractorLookup.with(TextFile.any(), new TextFileResolver()).join(AttributeExtractorLookup.with(SystemProperty.any(), new SystemPropertyResolver())).join(AttributeExtractorLookup.with(MappedTextFile.any(), new MappedTextFileResolver())).join(AttributeExtractorLookup.failing());
    }
}

